/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.batch.item.ExecutionContext;

public class JobParameterExecutionContextCopyListener
extends StepExecutionListenerSupport {
    private Collection<String> keys = null;

    public void setKeys(String[] keys) {
        this.keys = Arrays.asList(keys);
    }

    public void beforeStep(StepExecution stepExecution) {
        ExecutionContext stepContext = stepExecution.getExecutionContext();
        JobParameters jobParameters = stepExecution.getJobParameters();
        Collection keys = this.keys;
        if (keys == null) {
            keys = jobParameters.getParameters().keySet();
        }
        for (String key : keys) {
            if (stepContext.containsKey(key)) continue;
            stepContext.put(key, jobParameters.getParameters().get(key).getValue());
        }
    }
}

