/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.ExecutionContextStringSerializer;
import org.springframework.batch.core.repository.dao.XStreamExecutionContextStringSerializer;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.util.Assert;

public class JdbcExecutionContextDao
extends AbstractJdbcBatchMetadataDao
implements ExecutionContextDao {
    private static final String FIND_JOB_EXECUTION_CONTEXT = "SELECT SHORT_CONTEXT, SERIALIZED_CONTEXT FROM %PREFIX%JOB_EXECUTION_CONTEXT WHERE JOB_EXECUTION_ID = ?";
    private static final String INSERT_JOB_EXECUTION_CONTEXT = "INSERT INTO %PREFIX%JOB_EXECUTION_CONTEXT (SHORT_CONTEXT, SERIALIZED_CONTEXT, JOB_EXECUTION_ID) VALUES(?, ?, ?)";
    private static final String UPDATE_JOB_EXECUTION_CONTEXT = "UPDATE %PREFIX%JOB_EXECUTION_CONTEXT SET SHORT_CONTEXT = ?, SERIALIZED_CONTEXT = ? WHERE JOB_EXECUTION_ID = ?";
    private static final String FIND_STEP_EXECUTION_CONTEXT = "SELECT SHORT_CONTEXT, SERIALIZED_CONTEXT FROM %PREFIX%STEP_EXECUTION_CONTEXT WHERE STEP_EXECUTION_ID = ?";
    private static final String INSERT_STEP_EXECUTION_CONTEXT = "INSERT INTO %PREFIX%STEP_EXECUTION_CONTEXT (SHORT_CONTEXT, SERIALIZED_CONTEXT, STEP_EXECUTION_ID) VALUES(?, ?, ?)";
    private static final String UPDATE_STEP_EXECUTION_CONTEXT = "UPDATE %PREFIX%STEP_EXECUTION_CONTEXT SET SHORT_CONTEXT = ?, SERIALIZED_CONTEXT = ? WHERE STEP_EXECUTION_ID = ?";
    private static final int MAX_VARCHAR_LENGTH = 2500;
    private LobHandler lobHandler = new DefaultLobHandler();
    private ExecutionContextStringSerializer serializer;

    public ExecutionContext getExecutionContext(JobExecution jobExecution) {
        Long executionId = jobExecution.getId();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        List results = this.getJdbcTemplate().query(this.getQuery(FIND_JOB_EXECUTION_CONTEXT), (ParameterizedRowMapper)new ExecutionContextRowMapper(), new Object[]{executionId});
        if (results.size() > 0) {
            return (ExecutionContext)results.get(0);
        }
        return new ExecutionContext();
    }

    public ExecutionContext getExecutionContext(StepExecution stepExecution) {
        Long executionId = stepExecution.getId();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        List results = this.getJdbcTemplate().query(this.getQuery(FIND_STEP_EXECUTION_CONTEXT), (ParameterizedRowMapper)new ExecutionContextRowMapper(), new Object[]{executionId});
        if (results.size() > 0) {
            return (ExecutionContext)results.get(0);
        }
        return new ExecutionContext();
    }

    public void updateExecutionContext(JobExecution jobExecution) {
        Long executionId = jobExecution.getId();
        ExecutionContext executionContext = jobExecution.getExecutionContext();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
        String serializedContext = this.serializeContext(executionContext);
        this.persistSerializedContext(executionId, serializedContext, UPDATE_JOB_EXECUTION_CONTEXT);
    }

    public void updateExecutionContext(StepExecution stepExecution) {
        Long executionId = stepExecution.getId();
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
        String serializedContext = this.serializeContext(executionContext);
        this.persistSerializedContext(executionId, serializedContext, UPDATE_STEP_EXECUTION_CONTEXT);
    }

    public void saveExecutionContext(JobExecution jobExecution) {
        Long executionId = jobExecution.getId();
        ExecutionContext executionContext = jobExecution.getExecutionContext();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
        String serializedContext = this.serializeContext(executionContext);
        this.persistSerializedContext(executionId, serializedContext, INSERT_JOB_EXECUTION_CONTEXT);
    }

    public void saveExecutionContext(StepExecution stepExecution) {
        Long executionId = stepExecution.getId();
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
        String serializedContext = this.serializeContext(executionContext);
        this.persistSerializedContext(executionId, serializedContext, INSERT_STEP_EXECUTION_CONTEXT);
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.serializer = new XStreamExecutionContextStringSerializer();
        ((XStreamExecutionContextStringSerializer)this.serializer).afterPropertiesSet();
    }

    private void persistSerializedContext(final Long executionId, String serializedContext, String sql) {
        String longContext;
        String shortContext;
        if (serializedContext.length() > 2500) {
            shortContext = String.valueOf(serializedContext.substring(0, 2496)) + " ...";
            longContext = serializedContext;
        } else {
            shortContext = serializedContext;
            longContext = null;
        }
        this.getJdbcTemplate().getJdbcOperations().update(this.getQuery(sql), new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, shortContext);
                if (longContext != null) {
                    JdbcExecutionContextDao.this.lobHandler.getLobCreator().setClobAsString(ps, 2, longContext);
                } else {
                    ps.setNull(2, JdbcExecutionContextDao.this.getClobTypeToUse());
                }
                ps.setLong(3, executionId);
            }
        });
    }

    private String serializeContext(ExecutionContext ctx) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry me : ctx.entrySet()) {
            m.put((String)me.getKey(), me.getValue());
        }
        return this.serializer.serialize(m);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecutionContextRowMapper
    implements ParameterizedRowMapper<ExecutionContext> {
        private ExecutionContextRowMapper() {
        }

        public ExecutionContext mapRow(ResultSet rs, int i) throws SQLException {
            ExecutionContext executionContext = new ExecutionContext();
            String serializedContext = rs.getString("SERIALIZED_CONTEXT");
            if (serializedContext == null) {
                serializedContext = rs.getString("SHORT_CONTEXT");
            }
            Map<String, Object> map = JdbcExecutionContextDao.this.serializer.deserialize(serializedContext);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                executionContext.put(entry.getKey(), entry.getValue());
            }
            return executionContext;
        }
    }
}

