/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcJobInstanceDao
extends AbstractJdbcBatchMetadataDao
implements JobInstanceDao,
InitializingBean {
    private static final String CREATE_JOB_INSTANCE = "INSERT into %PREFIX%JOB_INSTANCE(JOB_INSTANCE_ID, JOB_NAME, JOB_KEY, VERSION) values (?, ?, ?, ?)";
    private static final String CREATE_JOB_PARAMETERS = "INSERT into %PREFIX%JOB_PARAMS(JOB_INSTANCE_ID, KEY_NAME, TYPE_CD, STRING_VAL, DATE_VAL, LONG_VAL, DOUBLE_VAL) values (?, ?, ?, ?, ?, ?, ?)";
    private static final String FIND_JOBS_WITH_NAME = "SELECT JOB_INSTANCE_ID, JOB_NAME from %PREFIX%JOB_INSTANCE where JOB_NAME = ?";
    private static final String FIND_JOBS_WITH_KEY = "SELECT JOB_INSTANCE_ID, JOB_NAME from %PREFIX%JOB_INSTANCE where JOB_NAME = ? and JOB_KEY = ?";
    private static final String FIND_JOBS_WITH_EMPTY_KEY = "SELECT JOB_INSTANCE_ID, JOB_NAME from %PREFIX%JOB_INSTANCE where JOB_NAME = ? and (JOB_KEY = ? OR JOB_KEY is NULL)";
    private static final String GET_JOB_FROM_ID = "SELECT JOB_INSTANCE_ID, JOB_NAME, JOB_KEY, VERSION from %PREFIX%JOB_INSTANCE where JOB_INSTANCE_ID = ?";
    private static final String GET_JOB_FROM_EXECUTION_ID = "SELECT ji.JOB_INSTANCE_ID, JOB_NAME, JOB_KEY, ji.VERSION from %PREFIX%JOB_INSTANCE ji, %PREFIX%JOB_EXECUTION je where JOB_EXECUTION_ID = ? and ji.JOB_INSTANCE_ID = je.JOB_INSTANCE_ID";
    private static final String FIND_PARAMS_FROM_ID = "SELECT JOB_INSTANCE_ID, KEY_NAME, TYPE_CD, STRING_VAL, DATE_VAL, LONG_VAL, DOUBLE_VAL from %PREFIX%JOB_PARAMS where JOB_INSTANCE_ID = ?";
    private static final String FIND_JOB_NAMES = "SELECT distinct JOB_NAME from %PREFIX%JOB_INSTANCE order by JOB_NAME";
    private static final String FIND_LAST_JOBS_BY_NAME = "SELECT JOB_INSTANCE_ID, JOB_NAME from %PREFIX%JOB_INSTANCE where JOB_NAME = ? order by JOB_INSTANCE_ID desc";
    private DataFieldMaxValueIncrementer jobIncrementer;

    @Override
    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        Assert.state((this.getJobInstance(jobName, jobParameters) == null ? 1 : 0) != 0, (String)"JobInstance must not already exist");
        Long jobId = this.jobIncrementer.nextLongValue();
        JobInstance jobInstance = new JobInstance(jobId, jobParameters, jobName);
        jobInstance.incrementVersion();
        Object[] parameters = new Object[]{jobId, jobName, this.createJobKey(jobParameters), jobInstance.getVersion()};
        this.getJdbcTemplate().getJdbcOperations().update(this.getQuery(CREATE_JOB_INSTANCE), parameters, new int[]{4, 12, 12, 4});
        this.insertJobParameters(jobId, jobParameters);
        return jobInstance;
    }

    protected String createJobKey(JobParameters jobParameters) {
        MessageDigest digest;
        Map<String, JobParameter> props = jobParameters.getParameters();
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList keys = new ArrayList(props.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            stringBuffer.append(String.valueOf(key) + "=" + props.get(key).toString() + ";");
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("MD5 algorithm not available.  Fatal (should be in the JDK).");
        }
        try {
            byte[] bytes = digest.digest(stringBuffer.toString().getBytes("UTF-8"));
            return String.format("%032x", new BigInteger(1, bytes));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("UTF-8 encoding not available.  Fatal (should be in the JDK).");
        }
    }

    private void insertJobParameters(Long jobId, JobParameters jobParameters) {
        for (Map.Entry<String, JobParameter> entry : jobParameters.getParameters().entrySet()) {
            JobParameter jobParameter = entry.getValue();
            this.insertParameter(jobId, jobParameter.getType(), entry.getKey(), jobParameter.getValue());
        }
    }

    private void insertParameter(Long jobId, JobParameter.ParameterType type, String key, Object value) {
        Object[] args = new Object[]{};
        int[] argTypes = new int[]{-5, 12, 12, 12, 93, -5, 8};
        if (type == JobParameter.ParameterType.STRING) {
            args = new Object[]{jobId, key, type, value, new Timestamp(0L), 0L, 0.0};
        } else if (type == JobParameter.ParameterType.LONG) {
            args = new Object[]{jobId, key, type, "", new Timestamp(0L), value, new Double(0.0)};
        } else if (type == JobParameter.ParameterType.DOUBLE) {
            args = new Object[]{jobId, key, type, "", new Timestamp(0L), 0L, value};
        } else if (type == JobParameter.ParameterType.DATE) {
            args = new Object[]{jobId, key, type, "", value, 0L, 0.0};
        }
        this.getJdbcTemplate().getJdbcOperations().update(this.getQuery(CREATE_JOB_PARAMETERS), args, argTypes);
    }

    @Override
    public JobInstance getJobInstance(String jobName, JobParameters jobParameters) {
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        String jobKey = this.createJobKey(jobParameters);
        JobInstanceRowMapper rowMapper = new JobInstanceRowMapper(jobParameters);
        List instances = StringUtils.hasLength((String)jobKey) ? this.getJdbcTemplate().query(this.getQuery(FIND_JOBS_WITH_KEY), (ParameterizedRowMapper)rowMapper, new Object[]{jobName, jobKey}) : this.getJdbcTemplate().query(this.getQuery(FIND_JOBS_WITH_EMPTY_KEY), (ParameterizedRowMapper)rowMapper, new Object[]{jobName, jobKey});
        if (instances.isEmpty()) {
            return null;
        }
        Assert.state((instances.size() == 1 ? 1 : 0) != 0);
        return (JobInstance)instances.get(0);
    }

    @Override
    public JobInstance getJobInstance(Long instanceId) {
        try {
            return (JobInstance)this.getJdbcTemplate().queryForObject(this.getQuery(GET_JOB_FROM_ID), (ParameterizedRowMapper)new JobInstanceRowMapper(), new Object[]{instanceId});
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
    }

    private JobParameters getJobParameters(Long instanceId) {
        final HashMap<String, JobParameter> map = new HashMap<String, JobParameter>();
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                JobParameter.ParameterType type = JobParameter.ParameterType.valueOf(rs.getString(3));
                JobParameter value = null;
                if (type == JobParameter.ParameterType.STRING) {
                    value = new JobParameter(rs.getString(4));
                } else if (type == JobParameter.ParameterType.LONG) {
                    value = new JobParameter(rs.getLong(6));
                } else if (type == JobParameter.ParameterType.DOUBLE) {
                    value = new JobParameter(rs.getDouble(7));
                } else if (type == JobParameter.ParameterType.DATE) {
                    value = new JobParameter(rs.getTimestamp(5));
                }
                map.put(rs.getString(2), value);
            }
        };
        this.getJdbcTemplate().getJdbcOperations().query(this.getQuery(FIND_PARAMS_FROM_ID), new Object[]{instanceId}, handler);
        return new JobParameters(map);
    }

    @Override
    public List<String> getJobNames() {
        return this.getJdbcTemplate().query(this.getQuery(FIND_JOB_NAMES), (ParameterizedRowMapper)new ParameterizedRowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(1);
            }
        }, new Object[0]);
    }

    @Override
    public List<JobInstance> getJobInstances(String jobName, final int start, final int count) {
        ResultSetExtractor extractor = new ResultSetExtractor(){
            private List<JobInstance> list = new ArrayList<JobInstance>();

            public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
                int rowNum = 0;
                while (rowNum < start && rs.next()) {
                    ++rowNum;
                }
                while (rowNum < start + count && rs.next()) {
                    JobInstanceRowMapper rowMapper = new JobInstanceRowMapper();
                    this.list.add((JobInstance)rowMapper.mapRow(rs, rowNum));
                    ++rowNum;
                }
                return this.list;
            }
        };
        List result = (List)this.getJdbcTemplate().getJdbcOperations().query(this.getQuery(FIND_LAST_JOBS_BY_NAME), new Object[]{jobName}, extractor);
        return result;
    }

    @Override
    public JobInstance getJobInstance(JobExecution jobExecution) {
        try {
            return (JobInstance)this.getJdbcTemplate().queryForObject(this.getQuery(GET_JOB_FROM_EXECUTION_ID), (ParameterizedRowMapper)new JobInstanceRowMapper(), new Object[]{jobExecution.getId()});
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
    }

    public void setJobIncrementer(DataFieldMaxValueIncrementer jobIncrementer) {
        this.jobIncrementer = jobIncrementer;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.jobIncrementer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class JobInstanceRowMapper
    implements ParameterizedRowMapper<JobInstance> {
        private JobParameters jobParameters;

        public JobInstanceRowMapper() {
        }

        public JobInstanceRowMapper(JobParameters jobParameters) {
            this.jobParameters = jobParameters;
        }

        public JobInstance mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long id = rs.getLong(1);
            if (this.jobParameters == null) {
                this.jobParameters = JdbcJobInstanceDao.this.getJobParameters(id);
            }
            JobInstance jobInstance = new JobInstance(rs.getLong(1), this.jobParameters, rs.getString(2));
            jobInstance.incrementVersion();
            return jobInstance;
        }
    }
}

