/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.List;
import org.springframework.batch.core.configuration.xml.AbstractStepParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ChunkElementParser {
    private static final String ID_ATTR = "id";
    private static final String REF_ATTR = "ref";
    private static final String CLASS_ATTR = "class";
    private static final String MERGE_ATTR = "merge";
    private static final String COMMIT_INTERVAL_ATTR = "commit-interval";
    private static final String CHUNK_COMPLETION_POLICY_ATTR = "chunk-completion-policy";

    protected void parse(Element element, AbstractBeanDefinition bd, ParserContext parserContext, boolean underspecified) {
        String isReaderTransactionalQueue;
        String cacheCapacity;
        String throttleLimit;
        String retryLimit;
        String skipLimit;
        String completionPolicyRef;
        String commitInterval;
        String taskExecutorBeanId;
        String writerBeanId;
        String processorBeanId;
        MutablePropertyValues propertyValues = bd.getPropertyValues();
        propertyValues.addPropertyValue("hasChunkElement", (Object)Boolean.TRUE);
        String readerBeanId = element.getAttribute("reader");
        if (StringUtils.hasText((String)readerBeanId)) {
            RuntimeBeanReference readerRef = new RuntimeBeanReference(readerBeanId);
            propertyValues.addPropertyValue("itemReader", (Object)readerRef);
        }
        if (StringUtils.hasText((String)(processorBeanId = element.getAttribute("processor")))) {
            RuntimeBeanReference processorRef = new RuntimeBeanReference(processorBeanId);
            propertyValues.addPropertyValue("itemProcessor", (Object)processorRef);
        }
        if (StringUtils.hasText((String)(writerBeanId = element.getAttribute("writer")))) {
            RuntimeBeanReference writerRef = new RuntimeBeanReference(writerBeanId);
            propertyValues.addPropertyValue("itemWriter", (Object)writerRef);
        }
        if (StringUtils.hasText((String)(taskExecutorBeanId = element.getAttribute("task-executor")))) {
            RuntimeBeanReference taskExecutorRef = new RuntimeBeanReference(taskExecutorBeanId);
            propertyValues.addPropertyValue("taskExecutor", (Object)taskExecutorRef);
        }
        if (StringUtils.hasText((String)(commitInterval = element.getAttribute(COMMIT_INTERVAL_ATTR)))) {
            propertyValues.addPropertyValue("commitInterval", (Object)commitInterval);
        }
        if (StringUtils.hasText((String)(completionPolicyRef = element.getAttribute(CHUNK_COMPLETION_POLICY_ATTR)))) {
            RuntimeBeanReference completionPolicy = new RuntimeBeanReference(completionPolicyRef);
            propertyValues.addPropertyValue("chunkCompletionPolicy", (Object)completionPolicy);
        }
        if (!underspecified && propertyValues.contains("commitInterval") == propertyValues.contains("chunkCompletionPolicy")) {
            if (propertyValues.contains("commitInterval")) {
                parserContext.getReaderContext().error("The <" + element.getNodeName() + "/> element must contain either '" + COMMIT_INTERVAL_ATTR + "' " + "or '" + CHUNK_COMPLETION_POLICY_ATTR + "', but not both.", (Object)element);
            } else {
                parserContext.getReaderContext().error("The <" + element.getNodeName() + "/> element must contain either '" + COMMIT_INTERVAL_ATTR + "' " + "or '" + CHUNK_COMPLETION_POLICY_ATTR + "'.", (Object)element);
            }
        }
        if (StringUtils.hasText((String)(skipLimit = element.getAttribute("skip-limit")))) {
            propertyValues.addPropertyValue("skipLimit", (Object)skipLimit);
        }
        if (StringUtils.hasText((String)(retryLimit = element.getAttribute("retry-limit")))) {
            propertyValues.addPropertyValue("retryLimit", (Object)retryLimit);
        }
        if (StringUtils.hasText((String)(throttleLimit = element.getAttribute("throttle-limit")))) {
            propertyValues.addPropertyValue("throttleLimit", (Object)throttleLimit);
        }
        if (StringUtils.hasText((String)(cacheCapacity = element.getAttribute("cache-capacity")))) {
            propertyValues.addPropertyValue("cacheCapacity", (Object)cacheCapacity);
        }
        if (StringUtils.hasText((String)(isReaderTransactionalQueue = element.getAttribute("is-reader-transactional-queue")))) {
            propertyValues.addPropertyValue("isReaderTransactionalQueue", (Object)isReaderTransactionalQueue);
        }
        AbstractStepParser.handleExceptionElement(element, parserContext, propertyValues, "skippable-exception-classes", "skippableExceptionClasses");
        AbstractStepParser.handleExceptionElement(element, parserContext, propertyValues, "retryable-exception-classes", "retryableExceptionClasses");
        AbstractStepParser.handleExceptionElement(element, parserContext, propertyValues, "fatal-exception-classes", "fatalExceptionClasses");
        this.handleRetryListenersElement(element, propertyValues, parserContext);
        this.handleStreamsElement(element, propertyValues, parserContext);
    }

    private void handleRetryListenersElement(Element element, MutablePropertyValues propertyValues, ParserContext parserContext) {
        Element listenersElement = DomUtils.getChildElementByTagName((Element)element, (String)"retry-listeners");
        if (listenersElement != null) {
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(listenersElement.getTagName(), parserContext.extractSource((Object)element));
            parserContext.pushContainingComponent(compositeDef);
            ManagedList retryListenerBeans = new ManagedList();
            retryListenerBeans.setMergeEnabled(listenersElement.hasAttribute(MERGE_ATTR) && Boolean.valueOf(listenersElement.getAttribute(MERGE_ATTR)) != false);
            this.handleRetryListenerElements(parserContext, listenersElement, retryListenerBeans);
            propertyValues.addPropertyValue("retryListeners", (Object)retryListenerBeans);
            parserContext.popAndRegisterContainingComponent();
        }
    }

    private void handleRetryListenerElements(ParserContext parserContext, Element element, ManagedList beans) {
        List listenerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"listener");
        if (listenerElements != null) {
            for (Element listenerElement : listenerElements) {
                String id = listenerElement.getAttribute(ID_ATTR);
                String listenerRef = listenerElement.getAttribute(REF_ATTR);
                String className = listenerElement.getAttribute(CLASS_ATTR);
                this.checkListenerElementAttributes(parserContext, element, listenerElement, id, listenerRef, className);
                if (StringUtils.hasText((String)listenerRef)) {
                    RuntimeBeanReference bean = new RuntimeBeanReference(listenerRef);
                    beans.add((Object)bean);
                    continue;
                }
                if (StringUtils.hasText((String)className)) {
                    RootBeanDefinition beanDef = new RootBeanDefinition(className, null, null);
                    if (!StringUtils.hasText((String)id)) {
                        id = parserContext.getReaderContext().generateBeanName((BeanDefinition)beanDef);
                    }
                    beans.add((Object)beanDef);
                    continue;
                }
                parserContext.getReaderContext().error("Neither 'ref' or 'class' specified for <" + listenerElement.getTagName() + "> element", (Object)element);
            }
        }
    }

    private void checkListenerElementAttributes(ParserContext parserContext, Element element, Element listenerElement, String id, String listenerRef, String className) {
        if (StringUtils.hasText((String)className) && StringUtils.hasText((String)listenerRef)) {
            NamedNodeMap attributeNodes = listenerElement.getAttributes();
            StringBuilder attributes = new StringBuilder();
            for (int i = 0; i < attributeNodes.getLength(); ++i) {
                if (i > 0) {
                    attributes.append(" ");
                }
                attributes.append(attributeNodes.item(i));
            }
            parserContext.getReaderContext().error("Both 'ref' and 'class' specified; use 'class' with an optional 'id' or just 'ref' for <" + listenerElement.getTagName() + "> element specified with attributes: " + attributes, (Object)element);
        }
    }

    private void handleStreamsElement(Element element, MutablePropertyValues propertyValues, ParserContext parserContext) {
        Element streamsElement = DomUtils.getChildElementByTagName((Element)element, (String)"streams");
        if (streamsElement != null) {
            ManagedList streamBeans = new ManagedList();
            streamBeans.setMergeEnabled(streamsElement.hasAttribute(MERGE_ATTR) && Boolean.valueOf(streamsElement.getAttribute(MERGE_ATTR)) != false);
            List streamElements = DomUtils.getChildElementsByTagName((Element)streamsElement, (String)"stream");
            if (streamElements != null) {
                for (Element streamElement : streamElements) {
                    String streamRef = streamElement.getAttribute(REF_ATTR);
                    if (StringUtils.hasText((String)streamRef)) {
                        RuntimeBeanReference bean = new RuntimeBeanReference(streamRef);
                        streamBeans.add((Object)bean);
                        continue;
                    }
                    parserContext.getReaderContext().error("ref not specified for <" + streamElement.getTagName() + "> element", (Object)element);
                }
            }
            propertyValues.addPropertyValue("streams", (Object)streamBeans);
        }
    }
}

