/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.skip;

import java.util.Collection;
import java.util.Collections;
import org.springframework.batch.classify.BinaryExceptionClassifier;
import org.springframework.batch.classify.Classifier;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.core.step.skip.SkipPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitCheckingItemSkipPolicy
implements SkipPolicy {
    private final int skipLimit;
    private final Classifier<Throwable, Boolean> fatalExceptionClassifier;
    private final Classifier<Throwable, Boolean> skippableExceptionClassifier;

    public LimitCheckingItemSkipPolicy(int skipLimit) {
        this(skipLimit, Collections.singleton(Exception.class), Collections.emptyList());
    }

    public LimitCheckingItemSkipPolicy(int skipLimit, Collection<Class<? extends Throwable>> skippableExceptions, Collection<Class<? extends Throwable>> fatalExceptions) {
        this(skipLimit, (Classifier<Throwable, Boolean>)new BinaryExceptionClassifier(skippableExceptions), (Classifier<Throwable, Boolean>)new BinaryExceptionClassifier(fatalExceptions));
    }

    public LimitCheckingItemSkipPolicy(int skipLimit, Classifier<Throwable, Boolean> skippableExceptionClassifier, Classifier<Throwable, Boolean> fatalExceptionClassifier) {
        this.skipLimit = skipLimit;
        this.skippableExceptionClassifier = skippableExceptionClassifier;
        this.fatalExceptionClassifier = fatalExceptionClassifier;
    }

    @Override
    public boolean shouldSkip(Throwable t, int skipCount) {
        if (((Boolean)this.fatalExceptionClassifier.classify((Object)t)).booleanValue()) {
            return false;
        }
        if (((Boolean)this.skippableExceptionClassifier.classify((Object)t)).booleanValue()) {
            if (skipCount < this.skipLimit) {
                return true;
            }
            throw new SkipLimitExceededException(this.skipLimit, t);
        }
        return false;
    }
}

