/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathXmlApplicationContextFactory
implements ApplicationContextFactory,
ApplicationContextAware {
    private ConfigurableApplicationContext parent;
    private Resource path;
    private ResourceXmlApplicationContext context;
    private boolean copyConfiguration = true;
    private Collection<Class<? extends BeanFactoryPostProcessor>> beanFactoryPostProcessorClasses;
    private final Object lock = new Object();

    public ClassPathXmlApplicationContextFactory() {
        this.beanFactoryPostProcessorClasses = new ArrayList<Class<? extends BeanFactoryPostProcessor>>();
        this.beanFactoryPostProcessorClasses.add(PropertyPlaceholderConfigurer.class);
        this.beanFactoryPostProcessorClasses.add(CustomEditorConfigurer.class);
    }

    public void setPath(Resource path) {
        this.path = path;
    }

    public void setCopyConfiguration(boolean copyConfiguration) {
        this.copyConfiguration = copyConfiguration;
    }

    protected final boolean isCopyConfiguration() {
        return this.copyConfiguration;
    }

    public void setBeanFactoryPostProcessorClasses(Class<? extends BeanFactoryPostProcessor>[] beanFactoryPostProcessorClasses) {
        this.beanFactoryPostProcessorClasses = new ArrayList<Class<? extends BeanFactoryPostProcessor>>();
        for (int i = 0; i < beanFactoryPostProcessorClasses.length; ++i) {
            this.beanFactoryPostProcessorClasses.add(beanFactoryPostProcessorClasses[i]);
        }
    }

    protected final Collection<Class<? extends BeanFactoryPostProcessor>> getBeanFactoryPostProcessorClasses() {
        return this.beanFactoryPostProcessorClasses;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)applicationContext);
        this.parent = (ConfigurableApplicationContext)applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableApplicationContext createApplicationContext() {
        if (this.path == null) {
            return this.parent;
        }
        if (this.context == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.context == null) {
                    this.context = new ResourceXmlApplicationContext(this.parent);
                }
            }
        }
        return this.context;
    }

    protected void prepareContext(ConfigurableApplicationContext parent, ConfigurableApplicationContext context) {
        for (Class<? extends BeanFactoryPostProcessor> cls : this.beanFactoryPostProcessorClasses) {
            for (String name : parent.getBeanNamesForType(cls)) {
                context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)parent.getBean(name));
            }
        }
    }

    protected void prepareBeanFactory(DefaultListableBeanFactory parent, DefaultListableBeanFactory beanFactory) {
        if (this.copyConfiguration && parent != null) {
            beanFactory.copyConfigurationFrom((ConfigurableBeanFactory)parent);
        }
    }

    private final class ResourceXmlApplicationContext
    extends AbstractXmlApplicationContext {
        private final DefaultListableBeanFactory parentBeanFactory;

        public ResourceXmlApplicationContext(ConfigurableApplicationContext parent) {
            super((ApplicationContext)parent);
            if (parent != null) {
                Assert.isTrue((boolean)(parent.getBeanFactory() instanceof DefaultListableBeanFactory), (String)"The parent application context must have a bean factory of type DefaultListableBeanFactory");
                this.parentBeanFactory = (DefaultListableBeanFactory)parent.getBeanFactory();
                this.refreshBeanFactory();
                ClassPathXmlApplicationContextFactory.this.prepareContext(parent, (ConfigurableApplicationContext)this);
            } else {
                this.parentBeanFactory = null;
            }
            this.refresh();
        }

        protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
            super.customizeBeanFactory(beanFactory);
            if (this.parentBeanFactory != null) {
                ClassPathXmlApplicationContextFactory.this.prepareBeanFactory(this.parentBeanFactory, beanFactory);
            }
        }

        protected Resource[] getConfigResources() {
            return new Resource[]{ClassPathXmlApplicationContextFactory.this.path};
        }
    }
}

