/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.support.ClassPathXmlApplicationContextFactory;
import org.springframework.batch.core.configuration.support.ReferenceJobFactory;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class ClassPathXmlJobLoader
implements ApplicationContextAware,
ApplicationListener,
InitializingBean {
    private static Log logger = LogFactory.getLog(ClassPathXmlJobLoader.class);
    private List<Resource> jobPaths;
    private ApplicationContext parent;
    private JobRegistry jobRegistry;
    private Collection<ConfigurableApplicationContext> contexts = new HashSet<ConfigurableApplicationContext>();

    public void setJobPaths(Resource[] jobPaths) {
        this.jobPaths = Arrays.asList(jobPaths);
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parent = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.jobRegistry != null ? 1 : 0) != 0, (String)"A JobRegistry must be provided");
    }

    public final void onApplicationEvent(ApplicationEvent event) {
        if (event.getSource() == this.parent) {
            if (event instanceof ContextRefreshedEvent) {
                try {
                    this.initialize();
                }
                catch (DuplicateJobException e) {
                    throw new IllegalStateException(e);
                }
                catch (NoSuchJobException e) {
                    throw new IllegalStateException(e);
                }
            } else if (event instanceof ContextClosedEvent) {
                this.clear();
            }
        }
    }

    protected void initialize() throws DuplicateJobException, NoSuchJobException {
        for (Resource resource : this.jobPaths) {
            String[] names;
            ConfigurableApplicationContext context = this.createApplicationContext(this.parent, resource);
            this.contexts.add(context);
            for (String name : names = context.getBeanNamesForType(Job.class)) {
                logger.debug((Object)("Registering job: " + name + " from context: " + resource));
                ReferenceJobFactory jobFactory = new ReferenceJobFactory((Job)context.getBean(name));
                this.jobRegistry.register(jobFactory);
            }
        }
        if (!this.jobPaths.isEmpty() && this.jobRegistry.getJobNames().isEmpty()) {
            throw new NoSuchJobException("Could not locate any jobs in resources provided.");
        }
    }

    protected ConfigurableApplicationContext createApplicationContext(ApplicationContext parent, Resource resource) {
        ClassPathXmlApplicationContextFactory applicationContextFactory = new ClassPathXmlApplicationContextFactory();
        applicationContextFactory.setPath(resource);
        if (parent != null) {
            applicationContextFactory.setApplicationContext(parent);
        }
        return applicationContextFactory.createApplicationContext();
    }

    protected void clear() {
        for (ConfigurableApplicationContext context : this.contexts) {
            if (!context.isActive()) continue;
            context.close();
        }
        for (String jobName : this.jobRegistry.getJobNames()) {
            this.jobRegistry.unregister(jobName);
        }
        this.contexts.clear();
    }
}

