/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.Collection;
import java.util.HashSet;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.support.GroupAwareJob;
import org.springframework.batch.core.configuration.support.ReferenceJobFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.util.Assert;

public class JobRegistryBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
InitializingBean,
DisposableBean {
    private JobRegistry jobRegistry = null;
    private Collection<String> jobNames = new HashSet<String>();
    private String groupName = null;
    private DefaultListableBeanFactory beanFactory;

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof DefaultListableBeanFactory) {
            this.beanFactory = (DefaultListableBeanFactory)beanFactory;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobRegistry, (String)"JobRegistry must not be null");
    }

    public void destroy() throws Exception {
        for (String name : this.jobNames) {
            this.jobRegistry.unregister(name);
        }
        this.jobNames.clear();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Job) {
            Job job = (Job)bean;
            try {
                String groupName = this.groupName;
                if (this.beanFactory != null && this.beanFactory.containsBean(beanName)) {
                    groupName = this.getGroupName(this.beanFactory.getBeanDefinition(beanName), job);
                }
                job = groupName == null ? job : new GroupAwareJob(groupName, job);
                ReferenceJobFactory jobFactory = new ReferenceJobFactory(job);
                this.jobRegistry.register(jobFactory);
                this.jobNames.add(jobFactory.getJobName());
            }
            catch (DuplicateJobException e) {
                throw new FatalBeanException("Cannot register job configuration", (Throwable)e);
            }
            return job;
        }
        return bean;
    }

    protected String getGroupName(BeanDefinition beanDefinition, Job job) {
        return this.groupName;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

