/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.List;
import org.springframework.batch.core.configuration.xml.ChunkElementParser;
import org.springframework.batch.core.configuration.xml.CoreNamespaceUtils;
import org.springframework.batch.core.configuration.xml.StepListenerParser;
import org.springframework.batch.core.configuration.xml.StepParserStepFactoryBean;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractStepParser {
    protected static final String ID_ATTR = "id";
    private static final String PARENT_ATTR = "parent";
    private static final String TASKLET_REF_ATTR = "ref";
    private static final String TASKLET_ELE = "tasklet";
    private static final String CHUNK_ELE = "chunk";
    private static final String LISTENERS_ELE = "listeners";
    private static final String MERGE_ATTR = "merge";
    private static final String TX_ATTRIBUTES_ELE = "transaction-attributes";
    private static final String JOB_REPO_ATTR = "job-repository";
    private static final ChunkElementParser chunkElementParser = new ChunkElementParser();
    private static final StepListenerParser stepListenerParser = new StepListenerParser();

    protected AbstractBeanDefinition parseStep(Element stepElement, ParserContext parserContext, String jobFactoryRef) {
        Element description;
        String isAbstract;
        GenericBeanDefinition bd = new GenericBeanDefinition();
        List taskletElements = DomUtils.getChildElementsByTagName((Element)stepElement, (String)TASKLET_ELE);
        if (taskletElements.size() == 1) {
            boolean stepUnderspecified = CoreNamespaceUtils.isUnderspecified(stepElement);
            this.parseTasklet(stepElement, (Element)taskletElements.get(0), (AbstractBeanDefinition)bd, parserContext, stepUnderspecified);
        } else if (taskletElements.size() > 1) {
            parserContext.getReaderContext().error("The '<tasklet/>' element may not appear more than once in a single <" + stepElement.getNodeName() + "/>.", (Object)stepElement);
        }
        String parentRef = stepElement.getAttribute(PARENT_ATTR);
        if (StringUtils.hasText((String)parentRef)) {
            bd.setParentName(parentRef);
        }
        if (StringUtils.hasText((String)(isAbstract = stepElement.getAttribute("abstract")))) {
            bd.setAbstract(Boolean.valueOf(isAbstract).booleanValue());
        }
        if (StringUtils.hasText((String)jobFactoryRef)) {
            bd.setAttribute("jobParserJobFactoryBeanRef", (Object)jobFactoryRef);
        }
        if ((description = DomUtils.getChildElementByTagName((Element)stepElement, (String)"description")) != null) {
            bd.setDescription(description.getTextContent());
        }
        return bd;
    }

    private void parseTasklet(Element stepElement, Element taskletElement, AbstractBeanDefinition bd, ParserContext parserContext, boolean stepUnderspecified) {
        bd.setBeanClass(StepParserStepFactoryBean.class);
        bd.setAttribute("isNamespaceStep", (Object)true);
        String taskletRef = taskletElement.getAttribute(TASKLET_REF_ATTR);
        List chunkElements = DomUtils.getChildElementsByTagName((Element)taskletElement, (String)CHUNK_ELE);
        if (StringUtils.hasText((String)taskletRef)) {
            if (chunkElements.size() > 0) {
                parserContext.getReaderContext().error("The <chunk/> element can't be combined with the 'ref=\"" + taskletRef + "\"' attribute specification for <" + taskletElement.getNodeName() + "/>", (Object)taskletElement);
            }
            this.parseTaskletRef(taskletRef, bd.getPropertyValues());
        } else if (chunkElements.size() == 1) {
            chunkElementParser.parse((Element)chunkElements.get(0), bd, parserContext, stepUnderspecified);
        } else if (!stepUnderspecified) {
            parserContext.getReaderContext().error("Step [" + stepElement.getAttribute(ID_ATTR) + "] has neither a <" + CHUNK_ELE + "/> element nor a '" + TASKLET_REF_ATTR + "' attribute referencing a Tasklet.", (Object)taskletElement);
        }
        this.handleTaskletElement(taskletElement, bd, parserContext);
    }

    private void parseTaskletRef(String taskletRef, MutablePropertyValues propertyValues) {
        if (StringUtils.hasText((String)taskletRef)) {
            RuntimeBeanReference taskletBeanRef = new RuntimeBeanReference(taskletRef);
            propertyValues.addPropertyValue(TASKLET_ELE, (Object)taskletBeanRef);
        }
    }

    private void handleTaskletElement(Element taskletElement, AbstractBeanDefinition bd, ParserContext parserContext) {
        MutablePropertyValues propertyValues = bd.getPropertyValues();
        this.handleTaskletAttributes(taskletElement, propertyValues);
        this.handleTransactionAttributesElement(taskletElement, propertyValues);
        this.handleListenersElement(taskletElement, propertyValues, parserContext);
        this.handleExceptionElement(taskletElement, parserContext, propertyValues, "no-rollback-exception-classes", "noRollbackExceptionClasses");
        bd.setRole(1);
        bd.setSource(parserContext.extractSource((Object)taskletElement));
    }

    private void handleTransactionAttributesElement(Element stepElement, MutablePropertyValues propertyValues) {
        List txAttrElements = DomUtils.getChildElementsByTagName((Element)stepElement, (String)TX_ATTRIBUTES_ELE);
        if (txAttrElements.size() == 1) {
            String timeout;
            String isolation;
            Element txAttrElement = (Element)txAttrElements.get(0);
            String propagation = txAttrElement.getAttribute("propagation");
            if (StringUtils.hasText((String)propagation)) {
                propertyValues.addPropertyValue("propagation", (Object)propagation);
            }
            if (StringUtils.hasText((String)(isolation = txAttrElement.getAttribute("isolation")))) {
                propertyValues.addPropertyValue("isolation", (Object)isolation);
            }
            if (StringUtils.hasText((String)(timeout = txAttrElement.getAttribute("timeout")))) {
                propertyValues.addPropertyValue("transactionTimeout", (Object)timeout);
            }
        }
    }

    private void handleExceptionElement(Element element, ParserContext parserContext, MutablePropertyValues propertyValues, String exceptionListName, String propertyName) {
        List children = DomUtils.getChildElementsByTagName((Element)element, (String)exceptionListName);
        if (children.size() == 1) {
            Element exceptionClassesElement = (Element)children.get(0);
            ManagedList list = new ManagedList();
            list.setMergeEnabled(exceptionClassesElement.hasAttribute(MERGE_ATTR) && Boolean.valueOf(exceptionClassesElement.getAttribute(MERGE_ATTR)) != false);
            this.addExceptionClasses("include", exceptionClassesElement, list, parserContext);
            propertyValues.addPropertyValue(propertyName, (Object)list);
        } else if (children.size() > 1) {
            parserContext.getReaderContext().error("The <" + exceptionListName + "/> element may not appear more than once in a single <" + element.getNodeName() + "/>.", (Object)element);
        }
    }

    private void addExceptionClasses(String elementName, Element exceptionClassesElement, ManagedList list, ParserContext parserContext) {
        for (Element child : DomUtils.getChildElementsByTagName((Element)exceptionClassesElement, (String)elementName)) {
            String className = child.getAttribute("class");
            try {
                Class<?> cls = Class.forName(className);
                if (!Throwable.class.isAssignableFrom(cls)) {
                    parserContext.getReaderContext().error("Non-Throwable class '" + className + "' found in <" + exceptionClassesElement.getNodeName() + "/> element.", (Object)exceptionClassesElement);
                }
                if (list.contains(cls)) {
                    parserContext.getReaderContext().error("Duplicate entry for class '" + className + "' found in <" + exceptionClassesElement.getNodeName() + "/> element.", (Object)exceptionClassesElement);
                }
                list.add(cls);
            }
            catch (ClassNotFoundException e) {
                parserContext.getReaderContext().error("Cannot find class '" + className + "', given as an attribute of the <" + elementName + "/> element.", (Object)child);
            }
        }
    }

    private void handleTaskletAttributes(Element taskletElement, MutablePropertyValues propertyValues) {
        String throttleLimit;
        String taskExecutorBeanId;
        String allowStartIfComplete;
        String startLimit;
        String transactionManagerRef;
        String jobRepositoryRef = taskletElement.getAttribute(JOB_REPO_ATTR);
        if (StringUtils.hasText((String)jobRepositoryRef)) {
            propertyValues.addPropertyValue("jobRepository", (Object)new RuntimeBeanReference(jobRepositoryRef));
        }
        if (StringUtils.hasText((String)(transactionManagerRef = taskletElement.getAttribute("transaction-manager")))) {
            propertyValues.addPropertyValue("transactionManager", (Object)new RuntimeBeanReference(transactionManagerRef));
        }
        if (StringUtils.hasText((String)(startLimit = taskletElement.getAttribute("start-limit")))) {
            propertyValues.addPropertyValue("startLimit", (Object)startLimit);
        }
        if (StringUtils.hasText((String)(allowStartIfComplete = taskletElement.getAttribute("allow-start-if-complete")))) {
            propertyValues.addPropertyValue("allowStartIfComplete", (Object)allowStartIfComplete);
        }
        if (StringUtils.hasText((String)(taskExecutorBeanId = taskletElement.getAttribute("task-executor")))) {
            RuntimeBeanReference taskExecutorRef = new RuntimeBeanReference(taskExecutorBeanId);
            propertyValues.addPropertyValue("taskExecutor", (Object)taskExecutorRef);
        }
        if (StringUtils.hasText((String)(throttleLimit = taskletElement.getAttribute("throttle-limit")))) {
            propertyValues.addPropertyValue("throttleLimit", (Object)throttleLimit);
        }
    }

    private void handleListenersElement(Element stepElement, MutablePropertyValues propertyValues, ParserContext parserContext) {
        List listenersElements = DomUtils.getChildElementsByTagName((Element)stepElement, (String)LISTENERS_ELE);
        if (listenersElements.size() == 1) {
            Element listenersElement = (Element)listenersElements.get(0);
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(listenersElement.getTagName(), parserContext.extractSource((Object)stepElement));
            parserContext.pushContainingComponent(compositeDef);
            ManagedList listenerBeans = new ManagedList();
            listenerBeans.setMergeEnabled(listenersElement.hasAttribute(MERGE_ATTR) && Boolean.valueOf(listenersElement.getAttribute(MERGE_ATTR)) != false);
            List listenerElements = DomUtils.getChildElementsByTagName((Element)listenersElement, (String)"listener");
            if (listenerElements != null) {
                for (Element listenerElement : listenerElements) {
                    listenerBeans.add((Object)stepListenerParser.parse(listenerElement, parserContext));
                }
            }
            propertyValues.addPropertyValue(LISTENERS_ELE, (Object)listenerBeans);
            parserContext.popAndRegisterContainingComponent();
        }
    }
}

