/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.Arrays;
import java.util.List;
import org.springframework.batch.core.configuration.xml.CoreNamespaceUtils;
import org.springframework.batch.core.configuration.xml.FlowParser;
import org.springframework.batch.core.configuration.xml.JobExecutionListenerParser;
import org.springframework.batch.core.configuration.xml.JobParserJobFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobParser
extends AbstractSingleBeanDefinitionParser {
    private static final String MERGE_ATTR = "merge";
    private static final JobExecutionListenerParser jobListenerParser = new JobExecutionListenerParser();

    protected Class<JobParserJobFactoryBean> getBeanClass(Element element) {
        return JobParserJobFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List listenersElements;
        String incrementer;
        String restartableAttribute;
        String repositoryAttribute;
        CoreNamespaceUtils.autoregisterBeansForNamespace(parserContext, parserContext.extractSource((Object)element));
        String jobName = element.getAttribute("id");
        builder.addConstructorArgValue((Object)jobName);
        boolean isAbstract = CoreNamespaceUtils.isAbstract(element);
        builder.setAbstract(isAbstract);
        String parentRef = element.getAttribute("parent");
        if (StringUtils.hasText((String)parentRef)) {
            builder.setParentName(parentRef);
        }
        if (StringUtils.hasText((String)(repositoryAttribute = element.getAttribute("job-repository")))) {
            builder.addPropertyReference("jobRepository", repositoryAttribute);
        }
        if (StringUtils.hasText((String)(restartableAttribute = element.getAttribute("restartable")))) {
            builder.addPropertyValue("restartable", (Object)restartableAttribute);
        }
        if (StringUtils.hasText((String)(incrementer = element.getAttribute("incrementer")))) {
            builder.addPropertyReference("jobParametersIncrementer", incrementer);
        }
        if (isAbstract) {
            for (String tagName : Arrays.asList("step", "decision", "split")) {
                if (DomUtils.getChildElementsByTagName((Element)element, (String)tagName).isEmpty()) continue;
                parserContext.getReaderContext().error("The <" + tagName + "/> element may not appear on a <job/> with abstract=\"true\" [" + jobName + "]", (Object)element);
            }
        } else {
            FlowParser flowParser = new FlowParser(jobName, jobName);
            BeanDefinition flowDef = flowParser.parse(element, parserContext);
            builder.addPropertyValue("flow", (Object)flowDef);
        }
        Element description = DomUtils.getChildElementByTagName((Element)element, (String)"description");
        if (description != null) {
            builder.getBeanDefinition().setDescription(description.getTextContent());
        }
        if ((listenersElements = DomUtils.getChildElementsByTagName((Element)element, (String)"listeners")).size() == 1) {
            Element listenersElement = (Element)listenersElements.get(0);
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(listenersElement.getTagName(), parserContext.extractSource((Object)element));
            parserContext.pushContainingComponent(compositeDef);
            ManagedList listeners = new ManagedList();
            listeners.setMergeEnabled(listenersElement.hasAttribute(MERGE_ATTR) && Boolean.valueOf(listenersElement.getAttribute(MERGE_ATTR)) != false);
            List listenerElements = DomUtils.getChildElementsByTagName((Element)listenersElement, (String)"listener");
            for (Element listenerElement : listenerElements) {
                listeners.add((Object)jobListenerParser.parse(listenerElement, parserContext));
            }
            builder.addPropertyValue("jobExecutionListeners", (Object)listeners);
            parserContext.popAndRegisterContainingComponent();
        } else if (listenersElements.size() > 1) {
            parserContext.getReaderContext().error("The '<listeners/>' element may not appear more than once in a single <job/>.", (Object)element);
        }
    }
}

