/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job;

import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.CompositeJobExecutionListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJob
implements Job,
StepLocator,
BeanNameAware,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(AbstractJob.class);
    private String name;
    private boolean restartable = true;
    private JobRepository jobRepository;
    private CompositeJobExecutionListener listener = new CompositeJobExecutionListener();
    private JobParametersIncrementer jobParametersIncrementer;

    public AbstractJob() {
    }

    public AbstractJob(String name) {
        this.name = name;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobRepository, (String)"JobRepository must be set");
    }

    public void setBeanName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract Step getStep(String var1);

    @Override
    public abstract Collection<String> getStepNames();

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    @Override
    public boolean isRestartable() {
        return this.restartable;
    }

    public void setJobParametersIncrementer(JobParametersIncrementer jobParametersIncrementer) {
        this.jobParametersIncrementer = jobParametersIncrementer;
    }

    @Override
    public JobParametersIncrementer getJobParametersIncrementer() {
        return this.jobParametersIncrementer;
    }

    public void setJobExecutionListeners(JobExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.listener.register(listeners[i]);
        }
    }

    public void registerJobExecutionListener(JobExecutionListener listener) {
        this.listener.register(listener);
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    protected abstract void doExecute(JobExecution var1) throws JobExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final void execute(JobExecution execution) {
        block19: {
            block17: {
                logger.debug((Object)("Job execution starting: " + execution));
                if (execution.getStatus() != BatchStatus.STOPPING) {
                    execution.setStartTime(new Date());
                    this.updateStatus(execution, BatchStatus.STARTED);
                    this.listener.beforeJob(execution);
                    try {
                        this.doExecute(execution);
                        logger.debug((Object)("Job execution complete: " + execution));
                        break block17;
                    }
                    catch (RepeatException e) {
                        throw e.getCause();
                    }
                }
                execution.setStatus(BatchStatus.STOPPED);
                execution.setExitStatus(ExitStatus.COMPLETED);
                logger.debug((Object)("Job execution was stopped: " + execution));
            }
            Object var4_5 = null;
            if (execution.getStepExecutions().isEmpty()) {
                execution.setExitStatus(ExitStatus.NOOP.addExitDescription("All steps already completed or no steps configured for this job."));
            }
            execution.setEndTime(new Date());
            try {
                this.listener.afterJob(execution);
            }
            catch (Exception e2) {
                logger.error((Object)"Exception encountered in afterStep callback", (Throwable)e2);
            }
            this.jobRepository.update(execution);
            {
                break block19;
                catch (JobInterruptedException e) {
                    logger.error((Object)"Encountered interruption executing job", (Throwable)e);
                    execution.setExitStatus(ExitStatus.STOPPED);
                    execution.setStatus(BatchStatus.STOPPED);
                    execution.addFailureException(e);
                    Object var4_6 = null;
                    if (execution.getStepExecutions().isEmpty()) {
                        execution.setExitStatus(ExitStatus.NOOP.addExitDescription("All steps already completed or no steps configured for this job."));
                    }
                    execution.setEndTime(new Date());
                    try {
                        this.listener.afterJob(execution);
                    }
                    catch (Exception e2) {
                        logger.error((Object)"Exception encountered in afterStep callback", (Throwable)e2);
                    }
                    this.jobRepository.update(execution);
                    break block19;
                }
                catch (Throwable t) {
                    logger.error((Object)"Encountered fatal error executing job", t);
                    execution.setExitStatus(ExitStatus.FAILED);
                    execution.setStatus(BatchStatus.FAILED);
                    execution.addFailureException(t);
                    Object var4_7 = null;
                    if (execution.getStepExecutions().isEmpty()) {
                        execution.setExitStatus(ExitStatus.NOOP.addExitDescription("All steps already completed or no steps configured for this job."));
                    }
                    execution.setEndTime(new Date());
                    try {
                        this.listener.afterJob(execution);
                    }
                    catch (Exception e2) {
                        logger.error((Object)"Exception encountered in afterStep callback", (Throwable)e2);
                    }
                    this.jobRepository.update(execution);
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                if (execution.getStepExecutions().isEmpty()) {
                    execution.setExitStatus(ExitStatus.NOOP.addExitDescription("All steps already completed or no steps configured for this job."));
                }
                execution.setEndTime(new Date());
                try {
                    this.listener.afterJob(execution);
                }
                catch (Exception e2) {
                    logger.error((Object)"Exception encountered in afterStep callback", (Throwable)e2);
                }
                this.jobRepository.update(execution);
                throw throwable;
            }
        }
    }

    protected final StepExecution handleStep(Step step, JobExecution execution) throws JobInterruptedException, JobRestartException, StartLimitExceededException {
        StepExecution lastStepExecution;
        if (execution.isStopping()) {
            throw new JobInterruptedException("JobExecution interrupted.");
        }
        JobInstance jobInstance = execution.getJobInstance();
        StepExecution currentStepExecution = lastStepExecution = this.jobRepository.getLastStepExecution(jobInstance, step.getName());
        if (this.shouldStart(lastStepExecution, jobInstance, step)) {
            boolean isRestart;
            currentStepExecution = execution.createStepExecution(step.getName());
            boolean bl = isRestart = lastStepExecution != null && !lastStepExecution.getStatus().equals((Object)BatchStatus.COMPLETED);
            if (isRestart) {
                currentStepExecution.setExecutionContext(lastStepExecution.getExecutionContext());
            } else {
                currentStepExecution.setExecutionContext(new ExecutionContext());
            }
            this.jobRepository.add(currentStepExecution);
            logger.info((Object)("Executing step: [" + step + "]"));
            try {
                step.execute(currentStepExecution);
            }
            catch (JobInterruptedException e) {
                execution.setStatus(BatchStatus.STOPPING);
                throw e;
            }
            this.jobRepository.updateExecutionContext(execution);
            if (currentStepExecution.getStatus() == BatchStatus.STOPPING || currentStepExecution.getStatus() == BatchStatus.STOPPED) {
                execution.setStatus(BatchStatus.STOPPING);
                throw new JobInterruptedException("Job interrupted by step execution");
            }
        }
        return currentStepExecution;
    }

    protected void updateStepExecution(StepExecution stepExecution) {
        this.jobRepository.update(stepExecution);
    }

    private boolean shouldStart(StepExecution lastStepExecution, JobInstance jobInstance, Step step) throws JobRestartException, StartLimitExceededException {
        BatchStatus stepStatus = lastStepExecution == null ? BatchStatus.STARTING : lastStepExecution.getStatus();
        if (stepStatus == BatchStatus.UNKNOWN) {
            throw new JobRestartException("Cannot restart step from UNKNOWN status.  The last execution ended with a failure that could not be rolled back, so it may be dangerous to proceed.  Manual intervention is probably necessary.");
        }
        if (stepStatus == BatchStatus.COMPLETED && !step.isAllowStartIfComplete() || stepStatus == BatchStatus.ABANDONED) {
            logger.info((Object)("Step already complete or not restartable, so no action to execute: " + lastStepExecution));
            return false;
        }
        if (this.jobRepository.getStepExecutionCount(jobInstance, step.getName()) < step.getStartLimit()) {
            return true;
        }
        throw new StartLimitExceededException("Maximum start limit exceeded for step: " + step.getName() + "StartMax: " + step.getStartLimit());
    }

    private void updateStatus(JobExecution jobExecution, BatchStatus status) {
        jobExecution.setStatus(status);
        this.jobRepository.update(jobExecution);
    }

    public String toString() {
        return ClassUtils.getShortName(this.getClass()) + ": [name=" + this.name + "]";
    }
}

