/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow;

import java.util.Collection;
import java.util.HashSet;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecution;
import org.springframework.batch.core.job.flow.FlowExecutionException;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.State;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.step.StepHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowJob
extends AbstractJob {
    private Flow flow;

    public FlowJob() {
    }

    public FlowJob(String name) {
        super(name);
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    @Override
    public Step getStep(String stepName) {
        State state = this.flow.getState(stepName);
        if (state instanceof StepHolder) {
            return ((StepHolder)((Object)state)).getStep();
        }
        return null;
    }

    @Override
    public Collection<String> getStepNames() {
        HashSet<String> steps = new HashSet<String>();
        for (State state : this.flow.getStates()) {
            if (!(state instanceof StepHolder)) continue;
            steps.add(state.getName());
        }
        return steps;
    }

    @Override
    protected void doExecute(JobExecution execution) throws JobExecutionException {
        try {
            JobFlowExecutor executor = new JobFlowExecutor(execution);
            executor.updateJobExecutionStatus(this.flow.start(executor).getStatus());
        }
        catch (FlowExecutionException e) {
            if (e.getCause() instanceof JobExecutionException) {
                throw (JobExecutionException)e.getCause();
            }
            throw new JobExecutionException("Flow execution ended unexpectedly", e);
        }
    }

    private class JobFlowExecutor
    implements FlowExecutor {
        private final ThreadLocal<StepExecution> stepExecutionHolder = new ThreadLocal();
        private final JobExecution execution;
        private ExitStatus exitStatus = ExitStatus.EXECUTING;

        private JobFlowExecutor(JobExecution execution) {
            this.execution = execution;
            this.stepExecutionHolder.set(null);
        }

        public String executeStep(Step step) throws JobInterruptedException, JobRestartException, StartLimitExceededException {
            StepExecution stepExecution = FlowJob.this.handleStep(step, this.execution);
            this.stepExecutionHolder.set(stepExecution);
            return stepExecution == null ? ExitStatus.COMPLETED.getExitCode() : stepExecution.getExitStatus().getExitCode();
        }

        public void abandonStepExecution() {
            StepExecution lastStepExecution = this.stepExecutionHolder.get();
            if (lastStepExecution != null && lastStepExecution.getStatus().isGreaterThan(BatchStatus.STOPPING)) {
                lastStepExecution.upgradeStatus(BatchStatus.ABANDONED);
                FlowJob.this.updateStepExecution(lastStepExecution);
            }
        }

        public void updateJobExecutionStatus(FlowExecutionStatus status) {
            this.execution.setStatus(this.findBatchStatus(status));
            this.exitStatus = this.exitStatus.and(new ExitStatus(status.getName()));
            this.execution.setExitStatus(this.exitStatus);
        }

        public JobExecution getJobExecution() {
            return this.execution;
        }

        public StepExecution getStepExecution() {
            return this.stepExecutionHolder.get();
        }

        public void close(FlowExecution result) {
            this.stepExecutionHolder.set(null);
        }

        public boolean isRestart() {
            if (this.getStepExecution() != null && this.getStepExecution().getStatus() == BatchStatus.ABANDONED) {
                return true;
            }
            return this.execution.getStepExecutions().isEmpty();
        }

        public void addExitStatus(String code) {
            this.exitStatus = this.exitStatus.and(new ExitStatus(code));
        }

        private BatchStatus findBatchStatus(FlowExecutionStatus status) {
            for (BatchStatus batchStatus : BatchStatus.values()) {
                if (!status.getName().startsWith(batchStatus.toString())) continue;
                return batchStatus;
            }
            return BatchStatus.UNKNOWN;
        }
    }
}

