/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.support.ClassPathXmlApplicationContextFactory;
import org.springframework.batch.core.configuration.support.JobRegistryBeanPostProcessor;
import org.springframework.batch.core.configuration.support.ReferenceJobFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobRegistryBackgroundJobRunner {
    public static final String EMBEDDED = JobRegistryBackgroundJobRunner.class.getSimpleName() + ".EMBEDDED";
    private static Log logger = LogFactory.getLog(JobRegistryBackgroundJobRunner.class);
    private JobRegistry registry;
    private ApplicationContext parentContext = null;
    public static boolean testing = false;
    private final String parentContextPath;
    private Collection<ConfigurableApplicationContext> contexts = new HashSet<ConfigurableApplicationContext>();
    private static List<Exception> errors = Collections.synchronizedList(new ArrayList());

    public JobRegistryBackgroundJobRunner(String parentContextPath) {
        this.parentContextPath = parentContextPath;
    }

    public void setRegistry(JobRegistry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Exception> getErrors() {
        List<Exception> list = errors;
        synchronized (list) {
            return new ArrayList<Exception>(errors);
        }
    }

    private void register(String[] paths) throws DuplicateJobException, IOException {
        for (int i = 0; i < paths.length; ++i) {
            boolean postProcessorExists = this.parentContext.getBeanNamesForType(JobRegistryBeanPostProcessor.class).length > 0;
            Object[] resources = this.parentContext.getResources(paths[i]);
            for (int j = 0; j < resources.length; ++j) {
                Resource path = resources[j];
                logger.info((Object)("Registering Job definitions from " + Arrays.toString(resources)));
                ConfigurableApplicationContext context = this.createApplicationContext(this.parentContext, path);
                this.contexts.add(context);
                String[] names = context.getBeanNamesForType(Job.class);
                Collection<String> registered = this.registry.getJobNames();
                for (String name : names) {
                    if (registered.contains(name) || !postProcessorExists) continue;
                    logger.debug((Object)("Registering job: " + name + " from context: " + path));
                    ReferenceJobFactory jobFactory = new ReferenceJobFactory((Job)context.getBean(name));
                    this.registry.register(jobFactory);
                }
            }
        }
    }

    protected ConfigurableApplicationContext createApplicationContext(ApplicationContext parent, Resource resource) {
        ClassPathXmlApplicationContextFactory applicationContextFactory = new ClassPathXmlApplicationContextFactory();
        applicationContextFactory.setPath(resource);
        if (parent != null) {
            applicationContextFactory.setApplicationContext(parent);
        }
        return applicationContextFactory.createApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        Assert.state((args.length >= 1 ? 1 : 0) != 0, (String)"At least one argument (the parent context path) must be provided.");
        final JobRegistryBackgroundJobRunner launcher = new JobRegistryBackgroundJobRunner(args[0]);
        errors.clear();
        logger.info((Object)("Starting job registry in parent context from XML at: [" + args[0] + "]"));
        new Thread(new Runnable(){

            public void run() {
                try {
                    launcher.run();
                }
                catch (RuntimeException e) {
                    errors.add(e);
                    throw e;
                }
            }
        }).start();
        logger.info((Object)"Waiting for parent context to start.");
        while (launcher.parentContext == null && errors.isEmpty()) {
            Thread.sleep(100L);
        }
        List<Exception> list = errors;
        synchronized (list) {
            if (!errors.isEmpty()) {
                logger.info((Object)(errors.size() + " errors detected on startup of parent context.  Rethrowing."));
                throw errors.get(0);
            }
        }
        errors.clear();
        String[] paths = new String[args.length - 1];
        System.arraycopy(args, 1, paths, 0, paths.length);
        logger.info((Object)("Parent context started.  Registering jobs from paths: " + Arrays.asList(paths)));
        launcher.register(paths);
        if (System.getProperty(EMBEDDED) != null) {
            launcher.destroy();
            return;
        }
        Class<JobRegistryBackgroundJobRunner> clazz = JobRegistryBackgroundJobRunner.class;
        synchronized (JobRegistryBackgroundJobRunner.class) {
            System.out.println("Started application.  Interrupt (CTRL-C) or call JobRegistryBackgroundJobRunner.stop() to exit.");
            JobRegistryBackgroundJobRunner.class.wait();
            // ** MonitorExit[var3_4] (shouldn't be in output)
            launcher.destroy();
            return;
        }
    }

    private void destroy() throws Exception {
        for (ConfigurableApplicationContext context : this.contexts) {
            if (!context.isActive()) continue;
            context.close();
        }
        for (String jobName : this.registry.getJobNames()) {
            this.registry.unregister(jobName);
        }
        this.contexts.clear();
    }

    private void run() {
        ClassPathXmlApplicationContext parent = new ClassPathXmlApplicationContext(this.parentContextPath);
        parent.getAutowireCapableBeanFactory().autowireBeanProperties((Object)this, 2, false);
        parent.getAutowireCapableBeanFactory().initializeBean((Object)this, this.getClass().getSimpleName());
        this.parentContext = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Class<JobRegistryBackgroundJobRunner> clazz = JobRegistryBackgroundJobRunner.class;
        synchronized (JobRegistryBackgroundJobRunner.class) {
            JobRegistryBackgroundJobRunner.class.notify();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

