/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.SerializationUtils;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.support.transaction.TransactionAwareProxyFactory;

public class MapExecutionContextDao
implements ExecutionContextDao {
    private static Map<Long, ExecutionContext> contextsByStepExecutionId = TransactionAwareProxyFactory.createTransactionalMap();
    private static Map<Long, ExecutionContext> contextsByJobExecutionId = TransactionAwareProxyFactory.createTransactionalMap();

    public static void clear() {
        contextsByJobExecutionId.clear();
        contextsByStepExecutionId.clear();
    }

    private static ExecutionContext copy(ExecutionContext original) {
        return (ExecutionContext)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)original));
    }

    public ExecutionContext getExecutionContext(StepExecution stepExecution) {
        return MapExecutionContextDao.copy(contextsByStepExecutionId.get(stepExecution.getId()));
    }

    public void updateExecutionContext(StepExecution stepExecution) {
        contextsByStepExecutionId.put(stepExecution.getId(), MapExecutionContextDao.copy(stepExecution.getExecutionContext()));
    }

    public ExecutionContext getExecutionContext(JobExecution jobExecution) {
        return MapExecutionContextDao.copy(contextsByJobExecutionId.get(jobExecution.getId()));
    }

    public void updateExecutionContext(JobExecution jobExecution) {
        contextsByJobExecutionId.put(jobExecution.getId(), MapExecutionContextDao.copy(jobExecution.getExecutionContext()));
    }

    public void saveExecutionContext(JobExecution jobExecution) {
        this.updateExecutionContext(jobExecution);
    }

    public void saveExecutionContext(StepExecution stepExecution) {
        this.updateExecutionContext(stepExecution);
    }
}

