/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.StepContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepSynchronizationManager {
    private static final ThreadLocal<Stack<StepExecution>> executionHolder = new ThreadLocal();
    private static final Map<StepExecution, AtomicInteger> counts = new HashMap<StepExecution, AtomicInteger>();
    private static final Map<StepExecution, StepContext> contexts = new HashMap<StepExecution, StepContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StepContext getContext() {
        if (StepSynchronizationManager.getCurrent().isEmpty()) {
            return null;
        }
        Map<StepExecution, StepContext> map = contexts;
        synchronized (map) {
            return contexts.get(StepSynchronizationManager.getCurrent().peek());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StepContext register(StepExecution stepExecution) {
        StepContext context;
        if (stepExecution == null) {
            return null;
        }
        StepSynchronizationManager.getCurrent().push(stepExecution);
        Map<StepExecution, StepContext> map = contexts;
        synchronized (map) {
            context = contexts.get(stepExecution);
            if (context == null) {
                context = new StepContext(stepExecution);
                contexts.put(stepExecution, context);
            }
        }
        StepSynchronizationManager.increment();
        return context;
    }

    public static void close() {
        StepContext oldSession = StepSynchronizationManager.getContext();
        if (oldSession == null) {
            return;
        }
        StepSynchronizationManager.decrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decrement() {
        int remaining;
        StepExecution current = StepSynchronizationManager.getCurrent().pop();
        if (current != null && (remaining = counts.get(current).decrementAndGet()) <= 0) {
            Map<StepExecution, StepContext> map = contexts;
            synchronized (map) {
                contexts.remove(current);
                counts.remove(current);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void increment() {
        StepExecution current = StepSynchronizationManager.getCurrent().peek();
        if (current != null) {
            AtomicInteger count;
            Map<StepExecution, AtomicInteger> map = counts;
            synchronized (map) {
                count = counts.get(current);
                if (count == null) {
                    count = new AtomicInteger();
                    counts.put(current, count);
                }
            }
            count.incrementAndGet();
        }
    }

    private static Stack<StepExecution> getCurrent() {
        if (executionHolder.get() == null) {
            executionHolder.set(new Stack());
        }
        return executionHolder.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release() {
        StepContext context = StepSynchronizationManager.getContext();
        try {
            if (context != null) {
                context.close();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            StepSynchronizationManager.close();
            throw throwable;
        }
        StepSynchronizationManager.close();
    }
}

