/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.classify.BinaryExceptionClassifier;
import org.springframework.batch.classify.Classifier;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.step.item.BatchRetryTemplate;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.ChunkMonitor;
import org.springframework.batch.core.step.item.ForceRollbackForWriteSkipException;
import org.springframework.batch.core.step.item.KeyGenerator;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.item.SkipWrapper;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableProcessException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.retry.ExhaustedRetryException;
import org.springframework.batch.retry.RecoveryCallback;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryException;
import org.springframework.batch.retry.RetryState;
import org.springframework.batch.retry.support.DefaultRetryState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultTolerantChunkProcessor<I, O>
extends SimpleChunkProcessor<I, O> {
    private SkipPolicy itemProcessSkipPolicy = new LimitCheckingItemSkipPolicy();
    private SkipPolicy itemWriteSkipPolicy = new LimitCheckingItemSkipPolicy();
    private final BatchRetryTemplate batchRetryTemplate;
    private Classifier<Throwable, Boolean> rollbackClassifier = new BinaryExceptionClassifier(true);
    private Log logger = LogFactory.getLog(this.getClass());
    private boolean buffering = true;
    private KeyGenerator keyGenerator;
    private ChunkMonitor chunkMonitor = new ChunkMonitor();

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setProcessSkipPolicy(SkipPolicy SkipPolicy2) {
        this.itemProcessSkipPolicy = SkipPolicy2;
    }

    public void setWriteSkipPolicy(SkipPolicy SkipPolicy2) {
        this.itemWriteSkipPolicy = SkipPolicy2;
    }

    public void setRollbackClassifier(Classifier<Throwable, Boolean> rollbackClassifier) {
        this.rollbackClassifier = rollbackClassifier;
    }

    public void setChunkMonitor(ChunkMonitor chunkMonitor) {
        this.chunkMonitor = chunkMonitor;
    }

    public void setBuffering(boolean buffering) {
        this.buffering = buffering;
    }

    public FaultTolerantChunkProcessor(ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter, BatchRetryTemplate batchRetryTemplate) {
        super(itemProcessor, itemWriter);
        this.batchRetryTemplate = batchRetryTemplate;
    }

    @Override
    protected void initializeUserData(Chunk<I> inputs) {
        UserData data = (UserData)inputs.getUserData();
        if (data == null) {
            data = new UserData(inputs.size());
            inputs.setUserData(data);
            data.setOutputs(new Chunk());
        }
    }

    @Override
    protected int getFilterCount(Chunk<I> inputs, Chunk<O> outputs) {
        UserData data = (UserData)inputs.getUserData();
        return data.size() - outputs.size() - inputs.getSkips().size();
    }

    @Override
    protected boolean isComplete(Chunk<I> inputs) {
        UserData data = (UserData)inputs.getUserData();
        Chunk previous = data.getOutputs();
        return inputs.isEmpty() && previous.getSkips().isEmpty();
    }

    @Override
    protected Chunk<O> getAdjustedOutputs(Chunk<I> inputs, Chunk<O> outputs) {
        UserData data = (UserData)inputs.getUserData();
        Chunk previous = data.getOutputs();
        Chunk<O> next = new Chunk<O>(outputs.getItems(), previous.getSkips());
        next.setBusy(previous.isBusy());
        data.setOutputs(next);
        return next;
    }

    @Override
    protected Chunk<O> transform(final StepContribution contribution, Chunk<I> inputs) throws Exception {
        Chunk outputs = new Chunk();
        UserData data = (UserData)inputs.getUserData();
        Chunk cache = data.getOutputs();
        final Chunk.ChunkIterator cacheIterator = cache.isEmpty() ? null : cache.iterator();
        final AtomicInteger count = new AtomicInteger(0);
        final Chunk.ChunkIterator iterator = inputs.iterator();
        while (iterator.hasNext()) {
            RecoveryCallback recoveryCallback;
            final Object item = iterator.next();
            RetryCallback retryCallback = new RetryCallback<O>(){

                public O doWithRetry(RetryContext context) throws Exception {
                    Object output = null;
                    try {
                        Object cached;
                        count.incrementAndGet();
                        Object o = cached = cacheIterator != null ? (Object)cacheIterator.next() : null;
                        output = cached != null && count.get() > 1 ? cached : (Object)FaultTolerantChunkProcessor.this.doProcess(item);
                    }
                    catch (Exception e) {
                        if (((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify((Object)e)).booleanValue()) {
                            throw e;
                        }
                        if (FaultTolerantChunkProcessor.this.itemProcessSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
                            contribution.incrementProcessSkipCount();
                            FaultTolerantChunkProcessor.this.logger.debug((Object)"Skipping after failed process with no rollback", (Throwable)e);
                            FaultTolerantChunkProcessor.this.callProcessSkipListener(item, e);
                        }
                        throw new NonSkippableProcessException("Non-skippable exception in processor.  Make sure any exceptions that do not cause a rollback are skippable.", e);
                    }
                    if (output == null) {
                        iterator.remove();
                    }
                    return output;
                }
            };
            Object output = this.batchRetryTemplate.execute(retryCallback, recoveryCallback = new RecoveryCallback<O>(){

                public O recover(RetryContext context) throws Exception {
                    Throwable e = context.getLastThrowable();
                    if (FaultTolerantChunkProcessor.this.itemProcessSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
                        contribution.incrementProcessSkipCount();
                        iterator.remove(e);
                        FaultTolerantChunkProcessor.this.logger.debug((Object)"Skipping after failed process", e);
                        return null;
                    }
                    throw new RetryException("Non-skippable exception in recoverer while processing", e);
                }
            }, (RetryState)new DefaultRetryState(this.getInputKey(item), this.rollbackClassifier));
            if (output == null) continue;
            outputs.add(output);
        }
        return outputs;
    }

    @Override
    protected void write(final StepContribution contribution, final Chunk<I> inputs, final Chunk<O> outputs) throws Exception {
        RetryCallback<Object> retryCallback = new RetryCallback<Object>(){

            public Object doWithRetry(RetryContext context) throws Exception {
                if (!inputs.isBusy()) {
                    FaultTolerantChunkProcessor.this.chunkMonitor.setChunkSize(inputs.size());
                    try {
                        FaultTolerantChunkProcessor.this.doWrite(outputs.getItems());
                    }
                    catch (Exception e) {
                        if (((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify((Object)e)).booleanValue()) {
                            throw e;
                        }
                        throw new ForceRollbackForWriteSkipException("Force rollback on skippable exception so that skipped item can be located.", e);
                    }
                    contribution.incrementWriteCount(outputs.size());
                } else {
                    FaultTolerantChunkProcessor.this.scan(contribution, inputs, outputs, FaultTolerantChunkProcessor.this.chunkMonitor);
                }
                return null;
            }
        };
        if (!this.buffering) {
            RecoveryCallback<Object> batchRecoveryCallback = new RecoveryCallback<Object>(){

                public Object recover(RetryContext context) throws Exception {
                    Throwable e = context.getLastThrowable();
                    if (outputs.size() > 1 && !((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify((Object)e)).booleanValue()) {
                        throw new RetryException("Invalid retry state during write caused by exception that does not classify for rollback: ", e);
                    }
                    Chunk.ChunkIterator inputIterator = inputs.iterator();
                    Chunk.ChunkIterator outputIterator = outputs.iterator();
                    while (outputIterator.hasNext()) {
                        inputIterator.next();
                        outputIterator.next();
                        FaultTolerantChunkProcessor.this.checkSkipPolicy(inputIterator, outputIterator, e, contribution);
                        if (((Boolean)FaultTolerantChunkProcessor.this.rollbackClassifier.classify((Object)e)).booleanValue()) continue;
                        throw new RetryException("Invalid retry state during recovery caused by exception that does not classify for rollback: ", e);
                    }
                    return null;
                }
            };
            this.batchRetryTemplate.execute(retryCallback, batchRecoveryCallback, BatchRetryTemplate.createState(this.getInputKeys(inputs), this.rollbackClassifier));
        } else {
            RecoveryCallback<Object> recoveryCallback = new RecoveryCallback<Object>(){

                public Object recover(RetryContext context) throws Exception {
                    if (!FaultTolerantChunkProcessor.this.itemWriteSkipPolicy.shouldSkip(context.getLastThrowable(), -1)) {
                        throw new ExhaustedRetryException("Retry exhausted after last attempt in recovery path, but exception is not skippable.", context.getLastThrowable());
                    }
                    inputs.setBusy(true);
                    FaultTolerantChunkProcessor.this.scan(contribution, inputs, outputs, FaultTolerantChunkProcessor.this.chunkMonitor);
                    return null;
                }
            };
            this.logger.debug((Object)("Attempting to write: " + inputs));
            this.batchRetryTemplate.execute(retryCallback, recoveryCallback, (RetryState)new DefaultRetryState(inputs, this.rollbackClassifier));
        }
        this.callSkipListeners(inputs, outputs);
    }

    private void callSkipListeners(Chunk<I> inputs, Chunk<O> outputs) {
        for (SkipWrapper<I> skipWrapper : inputs.getSkips()) {
            I item = skipWrapper.getItem();
            if (item == null) continue;
            Throwable e = skipWrapper.getException();
            this.callProcessSkipListener(item, e);
        }
        for (SkipWrapper<Object> skipWrapper : outputs.getSkips()) {
            Throwable e = skipWrapper.getException();
            try {
                this.getListener().onSkipInWrite(skipWrapper.getItem(), e);
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, e);
            }
        }
        outputs.clearSkips();
        inputs.clearSkips();
    }

    private void callProcessSkipListener(I item, Throwable e) {
        try {
            this.getListener().onSkipInProcess(item, e);
        }
        catch (RuntimeException ex) {
            throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, e);
        }
    }

    private Object getInputKey(I item) {
        if (this.keyGenerator == null) {
            return item;
        }
        return this.keyGenerator.getKey(item);
    }

    private List<?> getInputKeys(Chunk<I> inputs) {
        if (this.keyGenerator == null) {
            return inputs.getItems();
        }
        ArrayList<Object> keys = new ArrayList<Object>();
        for (I item : inputs.getItems()) {
            keys.add(this.keyGenerator.getKey(item));
        }
        return keys;
    }

    private void checkSkipPolicy(Chunk.ChunkIterator inputIterator, Chunk.ChunkIterator outputIterator, Throwable e, StepContribution contribution) {
        this.logger.debug((Object)"Checking skip policy after failed write");
        if (!this.itemWriteSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
            throw new RetryException("Non-skippable exception in recoverer", e);
        }
        contribution.incrementWriteSkipCount();
        inputIterator.remove();
        outputIterator.remove(e);
        this.logger.debug((Object)"Skipping after failed write", e);
    }

    private void scan(StepContribution contribution, Chunk<I> inputs, Chunk<O> outputs, ChunkMonitor chunkMonitor) throws Exception {
        block6: {
            this.logger.debug((Object)("Scanning for failed item on write: " + inputs));
            if (outputs.isEmpty()) {
                inputs.setBusy(false);
                return;
            }
            Chunk.ChunkIterator inputIterator = inputs.iterator();
            Chunk.ChunkIterator outputIterator = outputs.iterator();
            List items = Collections.singletonList(outputIterator.next());
            inputIterator.next();
            try {
                this.writeItems(items);
                this.doAfterWrite(items);
                contribution.incrementWriteCount(1);
                inputIterator.remove();
                outputIterator.remove();
            }
            catch (Exception e) {
                if (!this.itemWriteSkipPolicy.shouldSkip(e, -1) && !((Boolean)this.rollbackClassifier.classify((Object)e)).booleanValue()) {
                    inputIterator.remove();
                    outputIterator.remove();
                } else {
                    this.checkSkipPolicy(inputIterator, outputIterator, e, contribution);
                }
                if (!((Boolean)this.rollbackClassifier.classify((Object)e)).booleanValue()) break block6;
                throw e;
            }
        }
        chunkMonitor.incrementOffset();
        if (outputs.isEmpty()) {
            inputs.setBusy(false);
            chunkMonitor.resetOffset();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserData<O> {
        private final int size;
        private Chunk<O> outputs;

        public UserData(int size) {
            this.size = size;
        }

        public int size() {
            return this.size;
        }

        public Chunk<O> getOutputs() {
            return this.outputs;
        }

        public void setOutputs(Chunk<O> outputs) {
            this.outputs = outputs;
        }
    }
}

