/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow.support.state;

import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.support.state.AbstractState;

public class EndState
extends AbstractState {
    private final FlowExecutionStatus status;
    private final boolean abandon;
    private final String code;

    public EndState(FlowExecutionStatus status, String name) {
        this(status, status.getName(), name);
    }

    public EndState(FlowExecutionStatus status, String code, String name) {
        this(status, code, name, false);
    }

    public EndState(FlowExecutionStatus status, String code, String name, boolean abandon) {
        super(name);
        this.status = status;
        this.code = code;
        this.abandon = abandon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowExecutionStatus handle(FlowExecutor executor) throws Exception {
        FlowExecutor flowExecutor = executor;
        synchronized (flowExecutor) {
            StepExecution stepExecution = executor.getStepExecution();
            if (stepExecution != null && executor.getStepExecution().getStatus() == BatchStatus.UNKNOWN) {
                return FlowExecutionStatus.UNKNOWN;
            }
            if (this.status.isStop()) {
                if (!executor.isRestart()) {
                    if (this.abandon) {
                        executor.abandonStepExecution();
                    }
                } else {
                    return FlowExecutionStatus.COMPLETED;
                }
            }
            executor.addExitStatus(this.code);
            return this.status;
        }
    }

    public boolean isEndState() {
        return !this.status.isStop();
    }

    public String toString() {
        return super.toString() + " status=[" + this.status + "]";
    }
}

