/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.batch.classify.BinaryExceptionClassifier;
import org.springframework.batch.classify.Classifier;
import org.springframework.batch.classify.SubclassClassifier;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.step.FatalStepExecutionException;
import org.springframework.batch.core.step.item.BatchRetryTemplate;
import org.springframework.batch.core.step.item.ChunkMonitor;
import org.springframework.batch.core.step.item.FaultTolerantChunkProcessor;
import org.springframework.batch.core.step.item.FaultTolerantChunkProvider;
import org.springframework.batch.core.step.item.ForceRollbackForWriteSkipException;
import org.springframework.batch.core.step.item.KeyGenerator;
import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.core.step.item.SimpleChunkProvider;
import org.springframework.batch.core.step.item.SimpleRetryExceptionHandler;
import org.springframework.batch.core.step.item.SimpleStepFactoryBean;
import org.springframework.batch.core.step.skip.ExceptionClassifierSkipPolicy;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NeverSkipItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableReadException;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.core.step.skip.SkipPolicyFailedException;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.retry.ExhaustedRetryException;
import org.springframework.batch.retry.RetryException;
import org.springframework.batch.retry.RetryListener;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.backoff.BackOffPolicy;
import org.springframework.batch.retry.policy.ExceptionClassifierRetryPolicy;
import org.springframework.batch.retry.policy.MapRetryContextCache;
import org.springframework.batch.retry.policy.NeverRetryPolicy;
import org.springframework.batch.retry.policy.RetryContextCache;
import org.springframework.batch.retry.policy.SimpleRetryPolicy;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultTolerantStepFactoryBean<T, S>
extends SimpleStepFactoryBean<T, S> {
    private Map<Class<? extends Throwable>, Boolean> skippableExceptionClasses = new HashMap<Class<? extends Throwable>, Boolean>();
    private Collection<Class<? extends Throwable>> nonSkippableExceptionClasses = new HashSet<Class<? extends Throwable>>();
    private Collection<Class<? extends Throwable>> noRollbackExceptionClasses = new HashSet<Class<? extends Throwable>>();
    private Map<Class<? extends Throwable>, Boolean> retryableExceptionClasses = new HashMap<Class<? extends Throwable>, Boolean>();
    private Collection<Class<? extends Throwable>> nonRetryableExceptionClasses = new HashSet<Class<? extends Throwable>>();
    private int cacheCapacity = 0;
    private int retryLimit = 0;
    private int skipLimit = 0;
    private SkipPolicy skipPolicy;
    private BackOffPolicy backOffPolicy;
    private RetryListener[] retryListeners;
    private RetryPolicy retryPolicy;
    private RetryContextCache retryContextCache;
    private KeyGenerator keyGenerator;
    private ChunkMonitor chunkMonitor = new ChunkMonitor();
    private boolean processorTransactional = true;

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void setRetryContextCache(RetryContextCache retryContextCache) {
        this.retryContextCache = retryContextCache;
    }

    public void setRetryableExceptionClasses(Map<Class<? extends Throwable>, Boolean> retryableExceptionClasses) {
        this.retryableExceptionClasses = retryableExceptionClasses;
    }

    public void setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
    }

    public void setRetryListeners(RetryListener ... retryListeners) {
        this.retryListeners = retryListeners;
    }

    public void setSkipLimit(int skipLimit) {
        this.skipLimit = skipLimit;
    }

    public void setSkipPolicy(SkipPolicy skipPolicy) {
        this.skipPolicy = skipPolicy;
    }

    public void setSkippableExceptionClasses(Map<Class<? extends Throwable>, Boolean> exceptionClasses) {
        this.skippableExceptionClasses = exceptionClasses;
    }

    public void setNoRollbackExceptionClasses(Collection<Class<? extends Throwable>> noRollbackExceptionClasses) {
        this.noRollbackExceptionClasses = noRollbackExceptionClasses;
    }

    public void setProcessorTransactional(boolean processorTransactional) {
        this.processorTransactional = processorTransactional;
    }

    protected Classifier<Throwable, Boolean> getRollbackClassifier() {
        Object classifier = new BinaryExceptionClassifier(this.noRollbackExceptionClasses, false);
        if (!((Boolean)classifier.classify((Object)new ForceRollbackForWriteSkipException("test", new RuntimeException()))).booleanValue() || !((Boolean)classifier.classify((Object)new ExhaustedRetryException("test"))).booleanValue()) {
            BinaryExceptionClassifier binary = classifier;
            HashSet<Class> types = new HashSet<Class>();
            types.add(ForceRollbackForWriteSkipException.class);
            types.add(ExhaustedRetryException.class);
            BinaryExceptionClassifier panic = new BinaryExceptionClassifier(types, true);
            classifier = new Classifier<Throwable, Boolean>((Classifier)panic, (Classifier)binary){
                final /* synthetic */ Classifier val$panic;
                final /* synthetic */ Classifier val$binary;
                {
                    this.val$panic = classifier;
                    this.val$binary = classifier2;
                }

                public Boolean classify(Throwable classifiable) {
                    return (Boolean)this.val$panic.classify((Object)classifiable) != false || (Boolean)this.val$binary.classify((Object)classifiable) != false;
                }
            };
        }
        return classifier;
    }

    @Override
    protected TransactionAttribute getTransactionAttribute() {
        TransactionAttribute attribute = super.getTransactionAttribute();
        final Classifier<Throwable, Boolean> classifier = this.getRollbackClassifier();
        return new DefaultTransactionAttribute(attribute){

            public boolean rollbackOn(Throwable ex) {
                return (Boolean)classifier.classify((Object)ex);
            }
        };
    }

    @Override
    protected void applyConfiguration(TaskletStep step) {
        this.addNonSkippableExceptionIfMissing(SkipLimitExceededException.class, NonSkippableReadException.class, SkipListenerFailedException.class, SkipPolicyFailedException.class, RetryException.class, JobInterruptedException.class, Error.class);
        this.addNonRetryableExceptionIfMissing(SkipLimitExceededException.class, NonSkippableReadException.class, TransactionException.class, FatalStepExecutionException.class, SkipListenerFailedException.class, SkipPolicyFailedException.class, RetryException.class, JobInterruptedException.class, Error.class);
        super.applyConfiguration(step);
    }

    @Override
    protected void registerStreams(TaskletStep step, ItemStream[] streams) {
        boolean streamIsReader = false;
        ItemReader itemReader = this.getItemReader();
        for (ItemStream stream : streams) {
            if (stream instanceof ItemReader) {
                streamIsReader = true;
                this.chunkMonitor.registerItemStream(stream);
                continue;
            }
            step.registerStream(stream);
        }
        TaskExecutor taskExecutor = this.getTaskExecutor();
        if (streamIsReader) {
            boolean concurrent;
            step.registerStream(this.chunkMonitor);
            boolean bl = concurrent = taskExecutor != null && !(taskExecutor instanceof SyncTaskExecutor);
            if (!concurrent) {
                this.chunkMonitor.setItemReader(itemReader);
            } else {
                this.logger.warn((Object)("Asynchronous TaskExecutor detected (" + taskExecutor.getClass() + ") with ItemStream reader.  This is probably an error, " + "and may lead to incorrect restart data being stored."));
            }
        }
    }

    @Override
    protected SimpleChunkProvider<T> configureChunkProvider() {
        if (this.skipPolicy != null) {
            if (!this.skippableExceptionClasses.isEmpty()) {
                this.logger.info((Object)"Skippable exceptions will be ignored because a SkipPolicy was specified explicitly");
            }
            if (this.skipLimit > 0) {
                this.logger.info((Object)"Skip limit will be ignored because a SkipPolicy was specified explicitly");
            }
        }
        SkipPolicy readSkipPolicy = this.skipPolicy != null ? this.skipPolicy : new LimitCheckingItemSkipPolicy(this.skipLimit, this.getSkippableExceptionClasses());
        readSkipPolicy = this.getFatalExceptionAwareProxy(readSkipPolicy);
        FaultTolerantChunkProvider chunkProvider = new FaultTolerantChunkProvider(this.getItemReader(), this.getChunkOperations());
        chunkProvider.setMaxSkipsOnRead(Math.max(this.getCommitInterval(), 100));
        chunkProvider.setSkipPolicy(readSkipPolicy);
        chunkProvider.setRollbackClassifier(this.getRollbackClassifier());
        return chunkProvider;
    }

    @Override
    protected SimpleChunkProcessor<T, S> configureChunkProcessor() {
        BatchRetryTemplate batchRetryTemplate = this.configureRetry();
        FaultTolerantChunkProcessor chunkProcessor = new FaultTolerantChunkProcessor(this.getItemProcessor(), this.getItemWriter(), batchRetryTemplate);
        chunkProcessor.setBuffering(!this.isReaderTransactionalQueue());
        chunkProcessor.setProcessorTransactional(this.processorTransactional);
        SkipPolicy writeSkipPolicy = this.skipPolicy != null ? this.skipPolicy : new LimitCheckingItemSkipPolicy(this.skipLimit, this.getSkippableExceptionClasses());
        writeSkipPolicy = this.getFatalExceptionAwareProxy(writeSkipPolicy);
        chunkProcessor.setWriteSkipPolicy(writeSkipPolicy);
        chunkProcessor.setProcessSkipPolicy(writeSkipPolicy);
        chunkProcessor.setRollbackClassifier(this.getRollbackClassifier());
        chunkProcessor.setKeyGenerator(this.keyGenerator);
        chunkProcessor.setChunkMonitor(this.chunkMonitor);
        return chunkProcessor;
    }

    private Map<Class<? extends Throwable>, Boolean> getSkippableExceptionClasses() {
        HashMap<Class<? extends Throwable>, Boolean> map = new HashMap<Class<? extends Throwable>, Boolean>(this.skippableExceptionClasses);
        map.put(ForceRollbackForWriteSkipException.class, true);
        return map;
    }

    private BatchRetryTemplate configureRetry() {
        if (this.retryPolicy == null) {
            HashMap<Class<? extends Throwable>, Boolean> map = new HashMap<Class<? extends Throwable>, Boolean>(this.retryableExceptionClasses);
            map.put(ForceRollbackForWriteSkipException.class, true);
            this.retryPolicy = new SimpleRetryPolicy(this.retryLimit, map);
        }
        RetryPolicy retryPolicyWrapper = this.getFatalExceptionAwareProxy(this.retryPolicy);
        BatchRetryTemplate batchRetryTemplate = new BatchRetryTemplate();
        if (this.backOffPolicy != null) {
            batchRetryTemplate.setBackOffPolicy(this.backOffPolicy);
        }
        batchRetryTemplate.setRetryPolicy(retryPolicyWrapper);
        RepeatOperations stepOperations = this.getStepOperations();
        if (stepOperations instanceof RepeatTemplate) {
            SimpleRetryExceptionHandler exceptionHandler = new SimpleRetryExceptionHandler(retryPolicyWrapper, this.getExceptionHandler(), this.nonRetryableExceptionClasses);
            ((RepeatTemplate)stepOperations).setExceptionHandler((ExceptionHandler)exceptionHandler);
        }
        if (this.retryContextCache == null) {
            if (this.cacheCapacity > 0) {
                batchRetryTemplate.setRetryContextCache((RetryContextCache)new MapRetryContextCache(this.cacheCapacity));
            }
        } else {
            batchRetryTemplate.setRetryContextCache(this.retryContextCache);
        }
        if (this.retryListeners != null) {
            batchRetryTemplate.setListeners(this.retryListeners);
        }
        return batchRetryTemplate;
    }

    private RetryPolicy getFatalExceptionAwareProxy(RetryPolicy retryPolicy) {
        NeverRetryPolicy neverRetryPolicy = new NeverRetryPolicy();
        HashMap<Class<? extends Throwable>, NeverRetryPolicy> map = new HashMap<Class<? extends Throwable>, NeverRetryPolicy>();
        for (Class<? extends Throwable> fatal : this.nonRetryableExceptionClasses) {
            map.put(fatal, neverRetryPolicy);
        }
        SubclassClassifier classifier = new SubclassClassifier((Object)retryPolicy);
        classifier.setTypeMap(map);
        ExceptionClassifierRetryPolicy retryPolicyWrapper = new ExceptionClassifierRetryPolicy();
        retryPolicyWrapper.setExceptionClassifier((Classifier)classifier);
        return retryPolicyWrapper;
    }

    private SkipPolicy getFatalExceptionAwareProxy(SkipPolicy skipPolicy) {
        NeverSkipItemSkipPolicy neverSkipPolicy = new NeverSkipItemSkipPolicy();
        HashMap<Class<? extends Throwable>, NeverSkipItemSkipPolicy> map = new HashMap<Class<? extends Throwable>, NeverSkipItemSkipPolicy>();
        for (Class<? extends Throwable> fatal : this.nonSkippableExceptionClasses) {
            map.put(fatal, neverSkipPolicy);
        }
        SubclassClassifier classifier = new SubclassClassifier((Object)skipPolicy);
        classifier.setTypeMap(map);
        ExceptionClassifierSkipPolicy skipPolicyWrapper = new ExceptionClassifierSkipPolicy();
        skipPolicyWrapper.setExceptionClassifier((SubclassClassifier<Throwable, SkipPolicy>)classifier);
        return skipPolicyWrapper;
    }

    private void addNonSkippableExceptionIfMissing(Class ... cls) {
        ArrayList<Class<? extends Throwable>> exceptions = new ArrayList<Class<? extends Throwable>>();
        for (Class<? extends Throwable> exceptionClass : this.nonSkippableExceptionClasses) {
            exceptions.add(exceptionClass);
        }
        for (Class fatal : cls) {
            if (exceptions.contains(fatal)) continue;
            exceptions.add(fatal);
        }
        this.nonSkippableExceptionClasses = exceptions;
    }

    private void addNonRetryableExceptionIfMissing(Class ... cls) {
        ArrayList<Class<? extends Throwable>> exceptions = new ArrayList<Class<? extends Throwable>>();
        for (Class<? extends Throwable> exceptionClass : this.nonRetryableExceptionClasses) {
            exceptions.add(exceptionClass);
        }
        for (Class fatal : cls) {
            if (exceptions.contains(fatal)) continue;
            exceptions.add(fatal);
        }
        this.nonRetryableExceptionClasses = exceptions;
    }
}

