/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.MulticasterBatchListener;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.ChunkProvider;
import org.springframework.batch.core.step.item.SkipOverflowException;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.RepeatStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleChunkProvider<I>
implements ChunkProvider<I> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ItemReader<? extends I> itemReader;
    private final MulticasterBatchListener<I, ?> listener = new MulticasterBatchListener();
    private final RepeatOperations repeatOperations;

    public SimpleChunkProvider(ItemReader<? extends I> itemReader, RepeatOperations repeatOperations) {
        this.itemReader = itemReader;
        this.repeatOperations = repeatOperations;
    }

    public void setListeners(List<? extends StepListener> listeners) {
        for (StepListener stepListener : listeners) {
            this.registerListener(stepListener);
        }
    }

    public void registerListener(StepListener listener) {
        this.listener.register(listener);
    }

    protected MulticasterBatchListener<I, ?> getListener() {
        return this.listener;
    }

    protected final I doRead() throws Exception {
        try {
            this.listener.beforeRead();
            Object item = this.itemReader.read();
            this.listener.afterRead(item);
            return (I)item;
        }
        catch (Exception e) {
            this.listener.onReadError(e);
            throw e;
        }
    }

    @Override
    public Chunk<I> provide(final StepContribution contribution) throws Exception {
        final Chunk inputs = new Chunk();
        this.repeatOperations.iterate(new RepeatCallback(){

            public RepeatStatus doInIteration(RepeatContext context) throws Exception {
                Object item = null;
                try {
                    item = SimpleChunkProvider.this.read(contribution, inputs);
                }
                catch (SkipOverflowException e) {
                    return RepeatStatus.FINISHED;
                }
                if (item == null) {
                    inputs.setEnd();
                    return RepeatStatus.FINISHED;
                }
                inputs.add(item);
                contribution.incrementReadCount();
                return RepeatStatus.CONTINUABLE;
            }
        });
        return inputs;
    }

    @Override
    public void postProcess(StepContribution contribution, Chunk<I> chunk) {
    }

    protected I read(StepContribution contribution, Chunk<I> chunk) throws SkipOverflowException, Exception {
        return this.doRead();
    }
}

