/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.tasklet;

import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.listener.CompositeChunkListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.scope.context.StepContextRepeatCallback;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.core.step.FatalStepExecutionException;
import org.springframework.batch.core.step.StepInterruptionPolicy;
import org.springframework.batch.core.step.ThreadStepInterruptionPolicy;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.support.CompositeItemStream;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class TaskletStep
extends AbstractStep {
    private static final Log logger = LogFactory.getLog(TaskletStep.class);
    private RepeatOperations stepOperations = new RepeatTemplate();
    private CompositeChunkListener chunkListener = new CompositeChunkListener();
    private StepInterruptionPolicy interruptionPolicy = new ThreadStepInterruptionPolicy();
    private CompositeItemStream stream = new CompositeItemStream();
    private PlatformTransactionManager transactionManager;
    private TransactionAttribute transactionAttribute = new DefaultTransactionAttribute(){

        public boolean rollbackOn(Throwable ex) {
            return true;
        }
    };
    private Tasklet tasklet;
    private final Semaphore semaphore = new Semaphore(1);

    public TaskletStep() {
        this(null);
    }

    public TaskletStep(String name) {
        super(name);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.state((this.transactionManager != null ? 1 : 0) != 0, (String)"A transaction manager must be provided");
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }

    public void setTasklet(Tasklet tasklet) {
        this.tasklet = tasklet;
        if (tasklet instanceof StepExecutionListener) {
            this.registerStepExecutionListener((StepExecutionListener)((Object)tasklet));
        }
    }

    public void registerChunkListener(ChunkListener listener) {
        this.chunkListener.register(listener);
    }

    public void setChunkListeners(ChunkListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.registerChunkListener(listeners[i]);
        }
    }

    public void setStreams(ItemStream[] streams) {
        for (int i = 0; i < streams.length; ++i) {
            this.registerStream(streams[i]);
        }
    }

    public void registerStream(ItemStream stream) {
        this.stream.register(stream);
    }

    public void setStepOperations(RepeatOperations stepOperations) {
        this.stepOperations = stepOperations;
    }

    public void setInterruptionPolicy(StepInterruptionPolicy interruptionPolicy) {
        this.interruptionPolicy = interruptionPolicy;
    }

    protected void doExecute(StepExecution stepExecution) throws Exception {
        this.stream.update(stepExecution.getExecutionContext());
        this.getJobRepository().updateExecutionContext(stepExecution);
        this.stepOperations.iterate((RepeatCallback)new StepContextRepeatCallback(stepExecution){

            public RepeatStatus doInChunkContext(RepeatContext repeatContext, ChunkContext chunkContext) throws Exception {
                RepeatStatus result;
                StepExecution stepExecution = chunkContext.getStepContext().getStepExecution();
                TaskletStep.this.interruptionPolicy.checkInterrupted(stepExecution);
                try {
                    result = (RepeatStatus)new TransactionTemplate(TaskletStep.this.transactionManager, (TransactionDefinition)TaskletStep.this.transactionAttribute).execute((TransactionCallback)new ChunkTransactionCallback(chunkContext));
                }
                catch (UncheckedTransactionException e) {
                    throw (Exception)e.getCause();
                }
                TaskletStep.this.chunkListener.afterChunk();
                TaskletStep.this.interruptionPolicy.checkInterrupted(stepExecution);
                return result;
            }
        });
    }

    protected void close(ExecutionContext ctx) throws Exception {
        this.stream.close();
    }

    protected void open(ExecutionContext ctx) throws Exception {
        this.stream.open(ctx);
    }

    private static class UncheckedTransactionException
    extends RuntimeException {
        public UncheckedTransactionException(Exception e) {
            super(e);
        }
    }

    private class ChunkTransactionCallback
    extends TransactionSynchronizationAdapter
    implements TransactionCallback {
        private final StepExecution stepExecution;
        private final ChunkContext chunkContext;
        private boolean rolledBack = false;
        private boolean stepExecutionUpdated = false;
        private StepExecution oldVersion;
        private boolean locked = false;

        public ChunkTransactionCallback(ChunkContext chunkContext) {
            this.chunkContext = chunkContext;
            this.stepExecution = chunkContext.getStepContext().getStepExecution();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                if (status != 0 && this.stepExecutionUpdated) {
                    logger.info((Object)"Commit failed while step execution data was already updated. Reverting to old version.");
                    this.copy(this.oldVersion, this.stepExecution);
                    if (status == 1) {
                        this.rollback(this.stepExecution);
                    }
                }
                if (status == 2) {
                    logger.error((Object)"Rolling back with transaction in unknown state");
                    this.rollback(this.stepExecution);
                    this.stepExecution.upgradeStatus(BatchStatus.UNKNOWN);
                    this.stepExecution.setTerminateOnly();
                }
                Object var3_2 = null;
                if (this.locked) {
                    TaskletStep.this.semaphore.release();
                }
                this.locked = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.locked) {
                    TaskletStep.this.semaphore.release();
                }
                this.locked = false;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object doInTransaction(TransactionStatus status) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this);
            RepeatStatus result = RepeatStatus.CONTINUABLE;
            StepContribution contribution = this.stepExecution.createStepContribution();
            TaskletStep.this.chunkListener.beforeChunk();
            this.oldVersion = new StepExecution(this.stepExecution.getStepName(), this.stepExecution.getJobExecution());
            this.copy(this.stepExecution, this.oldVersion);
            try {
                block15: {
                    try {
                        block14: {
                            try {
                                result = TaskletStep.this.tasklet.execute(contribution, this.chunkContext);
                                if (result == null) {
                                    result = RepeatStatus.FINISHED;
                                }
                            }
                            catch (Exception e) {
                                if (!TaskletStep.this.transactionAttribute.rollbackOn((Throwable)e)) break block14;
                                throw e;
                            }
                        }
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        try {
                            TaskletStep.this.semaphore.acquire();
                            this.locked = true;
                        }
                        catch (InterruptedException e) {
                            logger.error((Object)"Thread interrupted while locking for repository update");
                            this.stepExecution.setStatus(BatchStatus.STOPPED);
                            this.stepExecution.setTerminateOnly();
                            Thread.currentThread().interrupt();
                        }
                        logger.debug((Object)("Applying contribution: " + contribution));
                        this.stepExecution.apply(contribution);
                        throw throwable;
                    }
                    try {
                        TaskletStep.this.semaphore.acquire();
                        this.locked = true;
                        break block15;
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)"Thread interrupted while locking for repository update");
                        this.stepExecution.setStatus(BatchStatus.STOPPED);
                        this.stepExecution.setTerminateOnly();
                        Thread.currentThread().interrupt();
                    }
                    {
                    }
                }
                logger.debug((Object)("Applying contribution: " + contribution));
                this.stepExecution.apply(contribution);
                this.stepExecutionUpdated = true;
                TaskletStep.this.stream.update(this.stepExecution.getExecutionContext());
                try {
                    TaskletStep.this.getJobRepository().updateExecutionContext(this.stepExecution);
                    this.stepExecution.incrementCommitCount();
                    logger.debug((Object)("Saving step execution before commit: " + this.stepExecution));
                    TaskletStep.this.getJobRepository().update(this.stepExecution);
                }
                catch (Exception e) {
                    String msg = "JobRepository failure forcing exit with unknown status";
                    logger.error((Object)msg, (Throwable)e);
                    this.stepExecution.upgradeStatus(BatchStatus.UNKNOWN);
                    this.stepExecution.setTerminateOnly();
                    throw new FatalStepExecutionException(msg, e);
                }
            }
            catch (Error e) {
                logger.debug((Object)("Rollback for Error: " + e.getClass().getName() + ": " + e.getMessage()));
                this.rollback(this.stepExecution);
                throw e;
            }
            catch (RuntimeException e) {
                logger.debug((Object)("Rollback for RuntimeException: " + e.getClass().getName() + ": " + e.getMessage()));
                this.rollback(this.stepExecution);
                throw e;
            }
            catch (Exception e) {
                logger.debug((Object)("Rollback for Exception: " + e.getClass().getName() + ": " + e.getMessage()));
                this.rollback(this.stepExecution);
                throw new UncheckedTransactionException(e);
            }
            return result;
        }

        private void rollback(StepExecution stepExecution) {
            if (!this.rolledBack) {
                stepExecution.incrementRollbackCount();
                this.rolledBack = true;
            }
        }

        private void copy(StepExecution source, StepExecution target) {
            target.setVersion(source.getVersion());
            target.setWriteCount(source.getWriteCount());
            target.setFilterCount(source.getFilterCount());
            target.setCommitCount(source.getCommitCount());
            target.setExecutionContext(new ExecutionContext(source.getExecutionContext()));
        }
    }
}

