/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.batch.core.configuration.support.JobLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.Lifecycle;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class AutomaticJobRegistrar
implements Ordered,
Lifecycle,
ApplicationListener,
ApplicationContextAware,
InitializingBean {
    private Collection<ApplicationContextFactory> applicationContextFactories = new ArrayList<ApplicationContextFactory>();
    private JobLoader jobLoader;
    private ApplicationContext applicationContext;
    private volatile boolean running = false;
    private Object lifecycleMonitor = new Object();
    private int order = Integer.MAX_VALUE;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setApplicationContextFactories(ApplicationContextFactory[] applicationContextFactories) {
        ApplicationContextFactory[] applicationContextFactoryArray = applicationContextFactories;
        int n = applicationContextFactories.length;
        int n2 = 0;
        while (n2 < n) {
            ApplicationContextFactory applicationContextFactory = applicationContextFactoryArray[n2];
            this.applicationContextFactories.add(applicationContextFactory);
            ++n2;
        }
    }

    public void setJobLoader(JobLoader jobLoader) {
        this.jobLoader = jobLoader;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void afterPropertiesSet() {
        Assert.state((this.jobLoader != null ? 1 : 0) != 0, (String)"A JobLoader must be provided");
    }

    public final void onApplicationEvent(ApplicationEvent event) {
        if (event.getSource() == this.applicationContext) {
            if (event instanceof ContextRefreshedEvent) {
                this.start();
            } else if (event instanceof ContextClosedEvent) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.jobLoader.clear();
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                return;
            }
            for (ApplicationContextFactory factory : this.applicationContextFactories) {
                try {
                    this.jobLoader.load(factory);
                }
                catch (DuplicateJobException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }
}

