/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathXmlApplicationContextFactory
implements ApplicationContextFactory,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(ClassPathXmlApplicationContextFactory.class);
    private Resource resource;
    private ConfigurableApplicationContext parent;
    private boolean copyConfiguration = true;
    private Collection<Class<? extends BeanFactoryPostProcessor>> beanFactoryPostProcessorClasses;
    private Collection<Class<?>> beanPostProcessorExcludeClasses;

    public ClassPathXmlApplicationContextFactory() {
        this(null);
    }

    public ClassPathXmlApplicationContextFactory(Resource resource) {
        this.resource = resource;
        this.beanFactoryPostProcessorClasses = new ArrayList<Class<? extends BeanFactoryPostProcessor>>();
        this.beanFactoryPostProcessorClasses.add(PropertyPlaceholderConfigurer.class);
        this.beanFactoryPostProcessorClasses.add(CustomEditorConfigurer.class);
        this.beanPostProcessorExcludeClasses = new ArrayList();
        this.beanPostProcessorExcludeClasses.add(BeanFactoryAware.class);
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setCopyConfiguration(boolean copyConfiguration) {
        this.copyConfiguration = copyConfiguration;
    }

    protected final boolean isCopyConfiguration() {
        return this.copyConfiguration;
    }

    public void setBeanFactoryPostProcessorClasses(Class<? extends BeanFactoryPostProcessor>[] beanFactoryPostProcessorClasses) {
        this.beanFactoryPostProcessorClasses = new ArrayList<Class<? extends BeanFactoryPostProcessor>>();
        int i = 0;
        while (i < beanFactoryPostProcessorClasses.length) {
            this.beanFactoryPostProcessorClasses.add(beanFactoryPostProcessorClasses[i]);
            ++i;
        }
    }

    public void setBeanPostProcessorExcludeClasses(Class<?>[] beanPostProcessorExcludeClasses) {
        this.beanPostProcessorExcludeClasses = new ArrayList();
        int i = 0;
        while (i < beanPostProcessorExcludeClasses.length) {
            this.beanPostProcessorExcludeClasses.add(beanPostProcessorExcludeClasses[i]);
            ++i;
        }
    }

    protected final Collection<Class<? extends BeanFactoryPostProcessor>> getBeanFactoryPostProcessorClasses() {
        return this.beanFactoryPostProcessorClasses;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext == null) {
            return;
        }
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)applicationContext);
        this.parent = (ConfigurableApplicationContext)applicationContext;
    }

    @Override
    public ConfigurableApplicationContext createApplicationContext() {
        if (this.resource == null) {
            return this.parent;
        }
        return new ResourceXmlApplicationContext(this.parent);
    }

    protected void prepareContext(ConfigurableApplicationContext parent, ConfigurableApplicationContext context) {
        for (Class<? extends BeanFactoryPostProcessor> cls : this.beanFactoryPostProcessorClasses) {
            String[] stringArray = parent.getBeanNamesForType(cls);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)parent.getBean(name));
                ++n2;
            }
        }
    }

    protected void prepareBeanFactory(DefaultListableBeanFactory parent, DefaultListableBeanFactory beanFactory) {
        if (this.copyConfiguration && parent != null) {
            beanFactory.copyConfigurationFrom((ConfigurableBeanFactory)parent);
            List beanPostProcessors = beanFactory.getBeanPostProcessors();
            for (BeanPostProcessor beanPostProcessor : new ArrayList(beanPostProcessors)) {
                for (Class<?> cls : this.beanPostProcessorExcludeClasses) {
                    if (!cls.isAssignableFrom(beanPostProcessor.getClass())) continue;
                    logger.debug((Object)("Removing bean post processor: " + beanPostProcessor + " of type " + cls));
                    beanPostProcessors.remove(beanPostProcessor);
                }
            }
        }
    }

    public String toString() {
        return "ClassPathXmlApplicationContextFactory [resource=" + this.resource + "]";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    private final class ResourceXmlApplicationContext
    extends AbstractXmlApplicationContext {
        private final DefaultListableBeanFactory parentBeanFactory;

        public ResourceXmlApplicationContext(ConfigurableApplicationContext parent) {
            super((ApplicationContext)parent);
            this.setId(this.generateId(ClassPathXmlApplicationContextFactory.this.resource));
            if (parent != null) {
                Assert.isTrue((boolean)(parent.getBeanFactory() instanceof DefaultListableBeanFactory), (String)"The parent application context must have a bean factory of type DefaultListableBeanFactory");
                this.parentBeanFactory = (DefaultListableBeanFactory)parent.getBeanFactory();
                this.refreshBeanFactory();
                ClassPathXmlApplicationContextFactory.this.prepareContext(parent, (ConfigurableApplicationContext)this);
            } else {
                this.parentBeanFactory = null;
            }
            this.refresh();
        }

        private String generateId(Resource resource) {
            try {
                return resource.getURI().toString();
            }
            catch (IOException iOException) {
                return resource.toString();
            }
        }

        protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
            super.customizeBeanFactory(beanFactory);
            if (this.parentBeanFactory != null) {
                ClassPathXmlApplicationContextFactory.this.prepareBeanFactory(this.parentBeanFactory, beanFactory);
            }
        }

        protected Resource[] getConfigResources() {
            return new Resource[]{ClassPathXmlApplicationContextFactory.this.resource};
        }

        public String toString() {
            return "ResourceXmlApplicationContext:" + this.getId();
        }
    }
}

