/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.FlowHolder;
import org.springframework.batch.core.job.flow.State;
import org.springframework.batch.core.job.flow.support.SimpleFlow;
import org.springframework.batch.core.job.flow.support.StateTransition;
import org.springframework.batch.core.job.flow.support.state.AbstractState;
import org.springframework.batch.core.job.flow.support.state.StepState;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFlowFactoryBean
implements FactoryBean,
InitializingBean {
    private String name;
    private List<StateTransition> stateTransitions;
    private String prefix;

    public void setName(String name) {
        this.name = name;
        this.prefix = String.valueOf(name) + ".";
    }

    public void setStateTransitions(List<StateTransition> stateTransitions) {
        this.stateTransitions = stateTransitions;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.name, (String)"The flow must have a name");
    }

    public Object getObject() throws Exception {
        SimpleFlow flow = new SimpleFlow(this.name);
        ArrayList<StateTransition> updatedTransitions = new ArrayList<StateTransition>();
        for (StateTransition stateTransition : this.stateTransitions) {
            State state = this.getProxyState(stateTransition.getState());
            updatedTransitions.add(StateTransition.switchOriginAndDestination(stateTransition, state, this.getNext(stateTransition.getNext())));
        }
        flow.setStateTransitions(updatedTransitions);
        flow.afterPropertiesSet();
        return flow;
    }

    private String getNext(String next) {
        if (next == null) {
            return null;
        }
        return String.valueOf(next.startsWith(this.prefix) ? "" : this.prefix) + next;
    }

    private State getProxyState(State state) {
        String oldName = state.getName();
        if (oldName.startsWith(this.prefix)) {
            return state;
        }
        String stateName = String.valueOf(this.prefix) + oldName;
        if (state instanceof StepState) {
            return new StepState(stateName, ((StepState)state).getStep());
        }
        return new DelegateState(stateName, state);
    }

    public Class<?> getObjectType() {
        return SimpleFlow.class;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegateState
    extends AbstractState
    implements FlowHolder {
        private final State state;

        private DelegateState(String name, State state) {
            super(name);
            this.state = state;
        }

        @Override
        public boolean isEndState() {
            return this.state.isEndState();
        }

        @Override
        public FlowExecutionStatus handle(FlowExecutor executor) throws Exception {
            return this.state.handle(executor);
        }

        @Override
        public Collection<Flow> getFlows() {
            return this.state instanceof FlowHolder ? ((FlowHolder)((Object)this.state)).getFlows() : (Collection<Flow>)Collections.emptyList();
        }
    }
}

