/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.Collection;
import java.util.List;
import org.springframework.batch.core.configuration.xml.InlineFlowParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitParser {
    private static final String PARENT_ATTR = "parent";
    private final String jobFactoryRef;

    public SplitParser(String jobFactoryRef) {
        this.jobFactoryRef = jobFactoryRef;
    }

    public Collection<BeanDefinition> parse(Element element, ParserContext parserContext) {
        List flowElements;
        String idAttribute = element.getAttribute("id");
        BeanDefinitionBuilder stateBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.job.flow.support.state.SplitState");
        String taskExecutorBeanId = element.getAttribute("task-executor");
        if (StringUtils.hasText((String)taskExecutorBeanId)) {
            RuntimeBeanReference taskExecutorRef = new RuntimeBeanReference(taskExecutorBeanId);
            stateBuilder.addPropertyValue("taskExecutor", (Object)taskExecutorRef);
        }
        if ((flowElements = DomUtils.getChildElementsByTagName((Element)element, (String)"flow")).size() < 2) {
            parserContext.getReaderContext().error("A <split/> must contain at least two 'flow' elements.", (Object)element);
        }
        ManagedList flows = new ManagedList();
        int i = 0;
        String prefix = idAttribute;
        for (Element nextElement : flowElements) {
            String ref = nextElement.getAttribute(PARENT_ATTR);
            if (StringUtils.hasText((String)ref)) {
                if (nextElement.getElementsByTagName("*").getLength() > 0) {
                    parserContext.getReaderContext().error("A <flow/> in a <split/> must have ref= or nested <flow/>, but not both.", (Object)nextElement);
                }
                GenericBeanDefinition flowDefinition = new GenericBeanDefinition();
                flowDefinition.setParentName(ref);
                MutablePropertyValues propertyValues = flowDefinition.getPropertyValues();
                propertyValues.addPropertyValue("name", (Object)(String.valueOf(prefix) + "." + i));
                flows.add(flowDefinition);
            } else {
                InlineFlowParser flowParser = new InlineFlowParser(String.valueOf(prefix) + "." + i, this.jobFactoryRef);
                flows.add(flowParser.parse(nextElement, parserContext));
            }
            ++i;
        }
        stateBuilder.addConstructorArgValue((Object)flows);
        stateBuilder.addConstructorArgValue((Object)prefix);
        return InlineFlowParser.getNextElements(parserContext, (BeanDefinition)stateBuilder.getBeanDefinition(), element);
    }
}

