/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.support.CompositeItemStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChunkMonitor
implements ItemStream {
    private Log logger = LogFactory.getLog(this.getClass());
    private boolean streamsRegistered = false;
    private static final String OFFSET = String.valueOf(ChunkMonitor.class.getName()) + ".OFFSET";
    private CompositeItemStream stream = new CompositeItemStream();
    private ThreadLocal<ChunkMonitorData> holder = new ThreadLocal();
    private ItemReader<?> reader;

    ChunkMonitor() {
    }

    public void registerItemStream(ItemStream stream) {
        this.streamsRegistered = true;
        this.stream.register(stream);
    }

    public void setItemReader(ItemReader<?> reader) {
        this.reader = reader;
    }

    public void incrementOffset() {
        ChunkMonitorData data = this.getData();
        ++data.offset;
        if (data.offset >= data.chunkSize) {
            this.resetOffset();
        }
    }

    public int getOffset() {
        return this.getData().offset;
    }

    public void resetOffset() {
        this.getData().offset = 0;
    }

    public void setChunkSize(int chunkSize) {
        this.getData().chunkSize = chunkSize;
        this.resetOffset();
    }

    public void close() throws ItemStreamException {
        this.holder.set(null);
        if (this.streamsRegistered) {
            this.stream.close();
        }
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        if (this.streamsRegistered) {
            this.stream.open(executionContext);
            ChunkMonitorData data = new ChunkMonitorData(executionContext.getInt(OFFSET, 0), 0);
            this.holder.set(data);
            if (this.reader == null) {
                this.logger.warn((Object)"No ItemReader set (must be concurrent step), so ignoring offset data.");
                return;
            }
            int i = 0;
            while (i < data.offset) {
                try {
                    this.reader.read();
                }
                catch (Exception e) {
                    throw new ItemStreamException("Could not position reader with offset: " + data.offset, (Throwable)e);
                }
                ++i;
            }
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.streamsRegistered) {
            ChunkMonitorData data = this.getData();
            if (data.offset == 0) {
                this.stream.update(executionContext);
            } else {
                executionContext.putInt(OFFSET, data.offset);
            }
        }
    }

    private ChunkMonitorData getData() {
        ChunkMonitorData data = this.holder.get();
        if (data == null) {
            if (this.streamsRegistered) {
                this.logger.warn((Object)"ItemStream was opened in a different thread.  Restart data could be compromised.");
            }
            data = new ChunkMonitorData(0, 0);
            this.holder.set(data);
        }
        return data;
    }

    public static class ChunkMonitorData {
        public int offset;
        public int chunkSize;

        public ChunkMonitorData(int offset, int chunkSize) {
            this.offset = offset;
            this.chunkSize = chunkSize;
        }
    }
}

