/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.classify.BinaryExceptionClassifier;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowStep;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.support.PartitionStep;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.core.partition.support.SimpleStepExecutionSplitter;
import org.springframework.batch.core.partition.support.StepExecutionAggregator;
import org.springframework.batch.core.partition.support.TaskExecutorPartitionHandler;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.core.step.item.FaultTolerantStepFactoryBean;
import org.springframework.batch.core.step.item.KeyGenerator;
import org.springframework.batch.core.step.item.SimpleStepFactoryBean;
import org.springframework.batch.core.step.job.JobParametersExtractor;
import org.springframework.batch.core.step.job.JobStep;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.TaskExecutorRepeatTemplate;
import org.springframework.batch.retry.RetryListener;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.backoff.BackOffPolicy;
import org.springframework.batch.retry.policy.RetryContextCache;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StepParserStepFactoryBean<I, O>
implements FactoryBean,
BeanNameAware {
    private static final Log logger = LogFactory.getLog(StepParserStepFactoryBean.class);
    private String name;
    private Boolean allowStartIfComplete;
    private JobRepository jobRepository;
    private Integer startLimit;
    private Tasklet tasklet;
    private PlatformTransactionManager transactionManager;
    private Flow flow;
    private Job job;
    private JobLauncher jobLauncher;
    private JobParametersExtractor jobParametersExtractor;
    private Partitioner partitioner;
    private static final int DEFAULT_GRID_SIZE = 6;
    private Step step;
    private PartitionHandler partitionHandler;
    private int gridSize = 6;
    private StepListener[] listeners;
    private Collection<Class<? extends Throwable>> noRollbackExceptionClasses;
    private Integer transactionTimeout;
    private Propagation propagation;
    private Isolation isolation;
    private Integer cacheCapacity;
    private CompletionPolicy chunkCompletionPolicy;
    private Integer commitInterval;
    private Boolean readerTransactionalQueue;
    private Boolean processorTransactional;
    private Integer retryLimit;
    private BackOffPolicy backOffPolicy;
    private RetryPolicy retryPolicy;
    private RetryContextCache retryContextCache;
    private KeyGenerator keyGenerator;
    private Integer skipLimit;
    private SkipPolicy skipPolicy;
    private TaskExecutor taskExecutor;
    private Integer throttleLimit;
    private ItemReader<? extends I> itemReader;
    private ItemProcessor<? super I, ? extends O> itemProcessor;
    private ItemWriter<? super O> itemWriter;
    private RetryListener[] retryListeners;
    private Map<Class<? extends Throwable>, Boolean> skippableExceptionClasses;
    private Map<Class<? extends Throwable>, Boolean> retryableExceptionClasses;
    private ItemStream[] streams;
    private boolean hasChunkElement = false;
    private StepExecutionAggregator stepExecutionAggregator;

    StepParserStepFactoryBean() {
    }

    public final Object getObject() throws Exception {
        if (this.hasChunkElement) {
            Assert.isNull((Object)this.tasklet, (String)("Step [" + this.name + "] has both a <chunk/> element and a 'ref' attribute  referencing a Tasklet."));
            this.validateFaultTolerantSettings();
            if (this.isFaultTolerant()) {
                FaultTolerantStepFactoryBean fb = new FaultTolerantStepFactoryBean();
                this.configureSimple(fb);
                this.configureFaultTolerant(fb);
                return fb.getObject();
            }
            SimpleStepFactoryBean fb = new SimpleStepFactoryBean();
            this.configureSimple(fb);
            return fb.getObject();
        }
        if (this.tasklet != null) {
            TaskletStep ts = new TaskletStep();
            this.configureTaskletStep(ts);
            return ts;
        }
        if (this.flow != null) {
            FlowStep ts = new FlowStep();
            this.configureFlowStep(ts);
            return ts;
        }
        if (this.job != null) {
            JobStep ts = new JobStep();
            this.configureJobStep(ts);
            return ts;
        }
        PartitionStep ts = new PartitionStep();
        this.configurePartitionStep(ts);
        return ts;
    }

    public boolean requiresTransactionManager() {
        return this.hasChunkElement || this.tasklet != null;
    }

    private void configureAbstractStep(AbstractStep ts) {
        if (this.name != null) {
            ts.setName(this.name);
        }
        if (this.allowStartIfComplete != null) {
            ts.setAllowStartIfComplete(this.allowStartIfComplete);
        }
        if (this.jobRepository != null) {
            ts.setJobRepository(this.jobRepository);
        }
        if (this.startLimit != null) {
            ts.setStartLimit(this.startLimit);
        }
        if (this.listeners != null) {
            ArrayList<StepExecutionListener> newListeners = new ArrayList<StepExecutionListener>();
            for (StepListener listener : this.listeners) {
                if (!(listener instanceof StepExecutionListener)) continue;
                newListeners.add((StepExecutionListener)listener);
            }
            ts.setStepExecutionListeners(newListeners.toArray(new StepExecutionListener[0]));
        }
    }

    private void configurePartitionStep(PartitionStep ts) {
        PartitionHandler handler;
        Assert.state((this.partitioner != null ? 1 : 0) != 0, (String)"A Partitioner must be provided for a partition step");
        this.configureAbstractStep(ts);
        if (this.partitionHandler != null) {
            handler = this.partitionHandler;
            ts.setPartitionHandler(this.partitionHandler);
        } else {
            TaskExecutorPartitionHandler partitionHandler = new TaskExecutorPartitionHandler();
            partitionHandler.setStep(this.step);
            if (this.taskExecutor == null) {
                this.taskExecutor = new SyncTaskExecutor();
            }
            partitionHandler.setGridSize(this.gridSize);
            partitionHandler.setTaskExecutor(this.taskExecutor);
            ts.setPartitionHandler(partitionHandler);
            handler = partitionHandler;
        }
        if (handler instanceof TaskExecutorPartitionHandler) {
            Assert.state((this.step != null ? 1 : 0) != 0, (String)"A Step must be provided for a partition step with a TaskExecutorPartitionHandler");
            try {
                TaskExecutorPartitionHandler taskExecutorPartitionHandler = (TaskExecutorPartitionHandler)handler;
                taskExecutorPartitionHandler.setStep(this.step);
                taskExecutorPartitionHandler.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new BeanCreationException("Could not configure TaskExecutorPartitionHandler", (Throwable)e);
            }
        } else {
            Assert.state((this.step == null ? 1 : 0) != 0, (String)"A Step must not be provided for a custom partition handler (unless it extends TaskExecutorPartitionHandler). It should be configured with its own step reference.");
        }
        boolean allowStartIfComplete = this.allowStartIfComplete != null ? this.allowStartIfComplete : false;
        String name = this.name;
        if (this.step != null) {
            try {
                allowStartIfComplete = this.step.isAllowStartIfComplete();
                name = this.step.getName();
            }
            catch (Exception e) {
                logger.info((Object)("Ignored exception from step asking for name and allowStartIfComplete flag. Using default from enclosing PartitionStep (" + name + "," + allowStartIfComplete + ")."));
            }
        }
        SimpleStepExecutionSplitter splitter = new SimpleStepExecutionSplitter(this.jobRepository, allowStartIfComplete, name, this.partitioner);
        ts.setStepExecutionSplitter(splitter);
        if (this.stepExecutionAggregator != null) {
            ts.setStepExecutionAggregator(this.stepExecutionAggregator);
        }
    }

    private void configureSimple(SimpleStepFactoryBean<I, O> fb) {
        if (this.name != null) {
            fb.setBeanName(this.name);
        }
        if (this.allowStartIfComplete != null) {
            fb.setAllowStartIfComplete(this.allowStartIfComplete);
        }
        if (this.jobRepository != null) {
            fb.setJobRepository(this.jobRepository);
        }
        if (this.startLimit != null) {
            fb.setStartLimit(this.startLimit);
        }
        if (this.transactionManager != null) {
            fb.setTransactionManager(this.transactionManager);
        }
        if (this.listeners != null) {
            fb.setListeners(this.listeners);
        }
        if (this.transactionTimeout != null) {
            fb.setTransactionTimeout(this.transactionTimeout);
        }
        if (this.propagation != null) {
            fb.setPropagation(this.propagation);
        }
        if (this.isolation != null) {
            fb.setIsolation(this.isolation);
        }
        if (this.chunkCompletionPolicy != null) {
            fb.setChunkCompletionPolicy(this.chunkCompletionPolicy);
        }
        if (this.commitInterval != null) {
            fb.setCommitInterval(this.commitInterval);
        }
        if (this.taskExecutor != null) {
            fb.setTaskExecutor(this.taskExecutor);
        }
        if (this.throttleLimit != null) {
            fb.setThrottleLimit(this.throttleLimit);
        }
        if (this.itemReader != null) {
            fb.setItemReader(this.itemReader);
        }
        if (this.itemProcessor != null) {
            fb.setItemProcessor(this.itemProcessor);
        }
        if (this.itemWriter != null) {
            fb.setItemWriter(this.itemWriter);
        }
        if (this.streams != null) {
            fb.setStreams(this.streams);
        }
    }

    private void configureFaultTolerant(FaultTolerantStepFactoryBean<I, O> fb) {
        if (this.cacheCapacity != null) {
            fb.setCacheCapacity(this.cacheCapacity);
        }
        if (this.readerTransactionalQueue != null) {
            fb.setIsReaderTransactionalQueue(this.readerTransactionalQueue);
        }
        if (this.processorTransactional != null) {
            fb.setProcessorTransactional(this.processorTransactional);
        }
        if (this.retryLimit != null) {
            fb.setRetryLimit(this.retryLimit);
        }
        if (this.skipLimit != null) {
            fb.setSkipLimit(this.skipLimit);
        }
        if (this.skipPolicy != null) {
            fb.setSkipPolicy(this.skipPolicy);
        }
        if (this.backOffPolicy != null) {
            fb.setBackOffPolicy(this.backOffPolicy);
        }
        if (this.retryPolicy != null) {
            fb.setRetryPolicy(this.retryPolicy);
        }
        if (this.retryContextCache != null) {
            fb.setRetryContextCache(this.retryContextCache);
        }
        if (this.keyGenerator != null) {
            fb.setKeyGenerator(this.keyGenerator);
        }
        if (this.retryListeners != null) {
            fb.setRetryListeners(this.retryListeners);
        }
        if (this.skippableExceptionClasses != null) {
            fb.setSkippableExceptionClasses(this.skippableExceptionClasses);
        }
        if (this.retryableExceptionClasses != null) {
            fb.setRetryableExceptionClasses(this.retryableExceptionClasses);
        }
        if (this.noRollbackExceptionClasses != null) {
            fb.setNoRollbackExceptionClasses(this.noRollbackExceptionClasses);
        }
    }

    private void configureTaskletStep(TaskletStep ts) {
        this.configureAbstractStep(ts);
        if (this.listeners != null) {
            ArrayList<ChunkListener> newListeners = new ArrayList<ChunkListener>();
            for (StepListener listener : this.listeners) {
                if (!(listener instanceof ChunkListener)) continue;
                newListeners.add((ChunkListener)listener);
            }
            ts.setChunkListeners(newListeners.toArray(new ChunkListener[0]));
        }
        if (this.tasklet != null) {
            ts.setTasklet(this.tasklet);
        }
        if (this.taskExecutor != null) {
            TaskExecutorRepeatTemplate repeatTemplate = new TaskExecutorRepeatTemplate();
            repeatTemplate.setTaskExecutor(this.taskExecutor);
            if (this.throttleLimit != null) {
                repeatTemplate.setThrottleLimit(this.throttleLimit.intValue());
            }
            ts.setStepOperations((RepeatOperations)repeatTemplate);
        }
        if (this.transactionManager != null) {
            ts.setTransactionManager(this.transactionManager);
        }
        if (this.transactionTimeout != null || this.propagation != null || this.isolation != null || this.noRollbackExceptionClasses != null) {
            DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
            if (this.propagation != null) {
                attribute.setPropagationBehavior(this.propagation.value());
            }
            if (this.isolation != null) {
                attribute.setIsolationLevel(this.isolation.value());
            }
            if (this.transactionTimeout != null) {
                attribute.setTimeout(this.transactionTimeout.intValue());
            }
            Collection<Object> exceptions = this.noRollbackExceptionClasses == null ? new HashSet() : this.noRollbackExceptionClasses;
            final BinaryExceptionClassifier classifier = new BinaryExceptionClassifier(exceptions, false);
            ts.setTransactionAttribute((TransactionAttribute)new DefaultTransactionAttribute((TransactionAttribute)attribute){

                public boolean rollbackOn(Throwable ex) {
                    return (Boolean)classifier.classify((Object)ex);
                }
            });
        }
    }

    private void configureFlowStep(FlowStep ts) {
        this.configureAbstractStep(ts);
        if (this.flow != null) {
            ts.setFlow(this.flow);
        }
    }

    private void configureJobStep(JobStep ts) throws Exception {
        this.configureAbstractStep(ts);
        if (this.job != null) {
            ts.setJob(this.job);
        }
        if (this.jobParametersExtractor != null) {
            ts.setJobParametersExtractor(this.jobParametersExtractor);
        }
        if (this.jobLauncher == null) {
            SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
            jobLauncher.setJobRepository(this.jobRepository);
            jobLauncher.afterPropertiesSet();
            this.jobLauncher = jobLauncher;
        }
        ts.setJobLauncher(this.jobLauncher);
    }

    private void validateFaultTolerantSettings() {
        this.validateDependency("skippable-exception-classes", this.skippableExceptionClasses, "skip-limit", this.skipLimit, true);
        this.validateDependency("retryable-exception-classes", this.retryableExceptionClasses, "retry-limit", this.retryLimit, true);
        this.validateDependency("retry-listeners", this.retryListeners, "retry-limit", this.retryLimit, false);
        if (this.isPresent(this.processorTransactional) && !this.processorTransactional.booleanValue() && this.isPresent(this.readerTransactionalQueue) && this.readerTransactionalQueue.booleanValue()) {
            throw new IllegalArgumentException("The field 'processor-transactional' cannot be false if 'reader-transactional-queue' is true");
        }
    }

    private void validateDependency(String dependentName, Object dependentValue, String name, Object value, boolean twoWayDependency) {
        if (this.isPresent(dependentValue) && !this.isPresent(value)) {
            throw new IllegalArgumentException("The field '" + dependentName + "' is not permitted on the step [" + this.name + "] because there is no '" + name + "'.");
        }
        if (twoWayDependency && this.isPresent(value) && !this.isPresent(dependentValue)) {
            throw new IllegalArgumentException("The field '" + name + "' is not permitted on the step [" + this.name + "] because there is no '" + dependentName + "'.");
        }
    }

    private boolean isPresent(Object o) {
        if (o instanceof Integer) {
            return this.isPositive((Integer)o);
        }
        return o != null;
    }

    private boolean isFaultTolerant() {
        return this.backOffPolicy != null || this.skipPolicy != null || this.retryPolicy != null || this.isPositive(this.skipLimit) || this.isPositive(this.retryLimit) || this.isPositive(this.cacheCapacity) || this.isTrue(this.readerTransactionalQueue);
    }

    private boolean isTrue(Boolean b) {
        return b != null && b != false;
    }

    private boolean isPositive(Integer n) {
        return n != null && n > 0;
    }

    public Class<TaskletStep> getObjectType() {
        return TaskletStep.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public void setJobParametersExtractor(JobParametersExtractor jobParametersExtractor) {
        this.jobParametersExtractor = jobParametersExtractor;
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    public void setPartitioner(Partitioner partitioner) {
        this.partitioner = partitioner;
    }

    public void setStepExecutionAggregator(StepExecutionAggregator stepExecutionAggregator) {
        this.stepExecutionAggregator = stepExecutionAggregator;
    }

    public void setPartitionHandler(PartitionHandler partitionHandler) {
        this.partitionHandler = partitionHandler;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setStep(Step step) {
        this.step = step;
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setStartLimit(int startLimit) {
        this.startLimit = startLimit;
    }

    public void setTasklet(Tasklet tasklet) {
        this.tasklet = tasklet;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setListeners(StepListener[] listeners) {
        this.listeners = listeners;
    }

    public void setNoRollbackExceptionClasses(Collection<Class<? extends Throwable>> noRollbackExceptionClasses) {
        this.noRollbackExceptionClasses = noRollbackExceptionClasses;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public void setIsolation(Isolation isolation) {
        this.isolation = isolation;
    }

    public void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    public void setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public void setRetryContextCache(RetryContextCache retryContextCache) {
        this.retryContextCache = retryContextCache;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void setChunkCompletionPolicy(CompletionPolicy chunkCompletionPolicy) {
        this.chunkCompletionPolicy = chunkCompletionPolicy;
    }

    public void setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
    }

    public void setIsReaderTransactionalQueue(boolean isReaderTransactionalQueue) {
        this.readerTransactionalQueue = isReaderTransactionalQueue;
    }

    public void setProcessorTransactional(Boolean processorTransactional) {
        this.processorTransactional = processorTransactional;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public void setSkipLimit(int skipLimit) {
        this.skipLimit = skipLimit;
    }

    public void setSkipPolicy(SkipPolicy skipPolicy) {
        this.skipPolicy = skipPolicy;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setThrottleLimit(Integer throttleLimit) {
        this.throttleLimit = throttleLimit;
    }

    public void setItemReader(ItemReader<? extends I> itemReader) {
        this.itemReader = itemReader;
    }

    public void setItemProcessor(ItemProcessor<? super I, ? extends O> itemProcessor) {
        this.itemProcessor = itemProcessor;
    }

    public void setItemWriter(ItemWriter<? super O> itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void setRetryListeners(RetryListener ... retryListeners) {
        this.retryListeners = retryListeners;
    }

    public void setSkippableExceptionClasses(Map<Class<? extends Throwable>, Boolean> exceptionClasses) {
        this.skippableExceptionClasses = exceptionClasses;
    }

    public void setRetryableExceptionClasses(Map<Class<? extends Throwable>, Boolean> retryableExceptionClasses) {
        this.retryableExceptionClasses = retryableExceptionClasses;
    }

    public void setStreams(ItemStream[] streams) {
        this.streams = streams;
    }

    public void setHasChunkElement(boolean hasChunkElement) {
        this.hasChunkElement = hasChunkElement;
    }
}

