/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.partition.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskExecutorPartitionHandler
implements PartitionHandler,
InitializingBean {
    private int gridSize = 1;
    private TaskExecutor taskExecutor = new SyncTaskExecutor();
    private Step step;

    public void afterPropertiesSet() throws Exception {
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setStep(Step step) {
        this.step = step;
    }

    @Override
    public Collection<StepExecution> handle(StepExecutionSplitter stepExecutionSplitter, StepExecution masterStepExecution) throws Exception {
        Assert.notNull((Object)this.step, (String)"A Step must be provided.");
        HashSet<FutureTask<StepExecution>> tasks = new HashSet<FutureTask<StepExecution>>(this.gridSize);
        ArrayList<StepExecution> result = new ArrayList<StepExecution>();
        for (final StepExecution stepExecution : stepExecutionSplitter.split(masterStepExecution, this.gridSize)) {
            FutureTask<StepExecution> task = new FutureTask<StepExecution>(new Callable<StepExecution>(){

                @Override
                public StepExecution call() throws Exception {
                    TaskExecutorPartitionHandler.this.step.execute(stepExecution);
                    return stepExecution;
                }
            });
            try {
                this.taskExecutor.execute(task);
                tasks.add(task);
            }
            catch (TaskRejectedException e) {
                ExitStatus exitStatus = ExitStatus.FAILED.addExitDescription("TaskExecutor rejected the task for this step.");
                stepExecution.setStatus(BatchStatus.FAILED);
                stepExecution.setExitStatus(exitStatus);
                result.add(stepExecution);
            }
        }
        for (Future future : tasks) {
            result.add((StepExecution)future.get());
        }
        return result;
    }
}

