/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.converter;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.util.StringUtils;

public class DefaultJobParametersConverter
implements JobParametersConverter {
    public static final String DATE_TYPE = "(date)";
    public static final String STRING_TYPE = "(string)";
    public static final String LONG_TYPE = "(long)";
    private static final String DOUBLE_TYPE = "(double)";
    private static NumberFormat DEFAULT_NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);
    private DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
    private NumberFormat numberFormat = DEFAULT_NUMBER_FORMAT;
    private final NumberFormat longNumberFormat = new DecimalFormat("#");

    public JobParameters getJobParameters(Properties props) {
        if (props == null || props.isEmpty()) {
            return new JobParameters();
        }
        JobParametersBuilder propertiesBuilder = new JobParametersBuilder();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            Number result;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.endsWith(DATE_TYPE)) {
                Date date;
                try {
                    date = this.dateFormat.parse(value);
                }
                catch (ParseException ex) {
                    String suffix = this.dateFormat instanceof SimpleDateFormat ? ", use " + ((SimpleDateFormat)this.dateFormat).toPattern() : "";
                    throw new IllegalArgumentException("Date format is invalid: [" + value + "]" + suffix);
                }
                propertiesBuilder.addDate(StringUtils.replace((String)key, (String)DATE_TYPE, (String)""), date);
                continue;
            }
            if (key.endsWith(LONG_TYPE)) {
                try {
                    result = (Long)this.parseNumber(value);
                }
                catch (ClassCastException ex) {
                    throw new IllegalArgumentException("Number format is invalid for long value: [" + value + "], use a format with no decimal places");
                }
                propertiesBuilder.addLong(StringUtils.replace((String)key, (String)LONG_TYPE, (String)""), (Long)result);
                continue;
            }
            if (key.endsWith(DOUBLE_TYPE)) {
                result = this.parseNumber(value).doubleValue();
                propertiesBuilder.addDouble(StringUtils.replace((String)key, (String)DOUBLE_TYPE, (String)""), (Double)result);
                continue;
            }
            if (StringUtils.endsWithIgnoreCase((String)key, (String)STRING_TYPE)) {
                propertiesBuilder.addString(StringUtils.replace((String)key, (String)STRING_TYPE, (String)""), value);
                continue;
            }
            propertiesBuilder.addString(key, value);
        }
        return propertiesBuilder.toJobParameters();
    }

    private Number parseNumber(String value) {
        try {
            return this.numberFormat.parse(value);
        }
        catch (ParseException ex) {
            String suffix = this.numberFormat instanceof DecimalFormat ? ", use " + ((DecimalFormat)this.numberFormat).toPattern() : "";
            throw new IllegalArgumentException("Number format is invalid: [" + value + "], use " + suffix);
        }
    }

    public Properties getProperties(JobParameters params) {
        if (params == null || params.isEmpty()) {
            return new Properties();
        }
        Map<String, JobParameter> parameters = params.getParameters();
        Properties result = new Properties();
        for (Map.Entry<String, JobParameter> entry : parameters.entrySet()) {
            String key = entry.getKey();
            JobParameter jobParameter = entry.getValue();
            Object value = jobParameter.getValue();
            if (value == null) continue;
            if (jobParameter.getType() == JobParameter.ParameterType.DATE) {
                result.setProperty(key + DATE_TYPE, this.dateFormat.format(value));
                continue;
            }
            if (jobParameter.getType() == JobParameter.ParameterType.LONG) {
                result.setProperty(key + LONG_TYPE, this.longNumberFormat.format(value));
                continue;
            }
            if (jobParameter.getType() == JobParameter.ParameterType.DOUBLE) {
                result.setProperty(key + DOUBLE_TYPE, this.decimalFormat((Double)value));
                continue;
            }
            result.setProperty(key, "" + value);
        }
        return result;
    }

    private String decimalFormat(double value) {
        if (this.numberFormat != DEFAULT_NUMBER_FORMAT) {
            return this.numberFormat.format(value);
        }
        return Double.toString(value);
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }
}

