/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow.support.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecution;
import org.springframework.batch.core.job.flow.FlowExecutionException;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.FlowHolder;
import org.springframework.batch.core.job.flow.support.state.AbstractState;
import org.springframework.batch.core.job.flow.support.state.FlowExecutionAggregator;
import org.springframework.batch.core.job.flow.support.state.MaxValueFlowExecutionAggregator;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.TaskRejectedException;

public class SplitState
extends AbstractState
implements FlowHolder {
    private final Collection<Flow> flows;
    private TaskExecutor taskExecutor = new SyncTaskExecutor();
    private FlowExecutionAggregator aggregator = new MaxValueFlowExecutionAggregator();

    public SplitState(Collection<Flow> flows, String name) {
        super(name);
        this.flows = flows;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Override
    public Collection<Flow> getFlows() {
        return this.flows;
    }

    @Override
    public FlowExecutionStatus handle(final FlowExecutor executor) throws Exception {
        ArrayList<Future<FlowExecution>> tasks = new ArrayList<Future<FlowExecution>>();
        for (final Flow flow : this.flows) {
            Future<FlowExecution> task = new FutureTask<FlowExecution>(new Callable<FlowExecution>(){

                @Override
                public FlowExecution call() throws Exception {
                    return flow.start(executor);
                }
            });
            tasks.add(task);
            try {
                this.taskExecutor.execute(task);
            }
            catch (TaskRejectedException e) {
                throw new FlowExecutionException("TaskExecutor rejected task for flow=" + flow.getName());
            }
        }
        ArrayList<FlowExecution> results = new ArrayList<FlowExecution>();
        for (Future<FlowExecution> task : tasks) {
            try {
                results.add(task.get());
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw e;
            }
        }
        return this.aggregator.aggregate(results);
    }

    @Override
    public boolean isEndState() {
        return false;
    }
}

