/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.io.IOException;
import org.springframework.batch.core.configuration.support.AbstractApplicationContextFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class GenericApplicationContextFactory
extends AbstractApplicationContextFactory {
    public GenericApplicationContextFactory(Object resource) {
        super(resource);
    }

    @Override
    protected ConfigurableApplicationContext createApplicationContext(ConfigurableApplicationContext parent, Object resource) {
        if (resource instanceof Resource) {
            return new ResourceXmlApplicationContext(parent, (Resource)resource);
        }
        if (resource instanceof Class) {
            return new ResourceAnnotationApplicationContext(parent, resource);
        }
        if (resource instanceof String) {
            return new ResourceAnnotationApplicationContext(parent, resource);
        }
        throw new IllegalArgumentException("No application context could be created for resource type: " + resource.getClass());
    }

    private final class ResourceAnnotationApplicationContext
    extends AnnotationConfigApplicationContext {
        private final ApplicationContextHelper helper;

        public ResourceAnnotationApplicationContext(ConfigurableApplicationContext parent, Object resource) {
            this.helper = new ApplicationContextHelper(parent, (GenericApplicationContext)this, resource){

                @Override
                protected String generateId(Object config) {
                    if (config instanceof Class) {
                        Class type = (Class)config;
                        return type.getName();
                    }
                    return config.toString();
                }

                @Override
                protected void loadConfiguration(Object config) {
                    if (config instanceof Class) {
                        Class type = (Class)config;
                        ResourceAnnotationApplicationContext.this.register(new Class[]{type});
                    } else {
                        String pkg = (String)config;
                        ResourceAnnotationApplicationContext.this.scan(new String[]{pkg});
                    }
                }
            };
            this.refresh();
        }

        protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            super.prepareBeanFactory(beanFactory);
            this.helper.prepareBeanFactory(beanFactory);
        }

        public String toString() {
            return "ResourceAnnotationApplicationContext:" + this.getId();
        }
    }

    private final class ResourceXmlApplicationContext
    extends GenericXmlApplicationContext {
        private final ApplicationContextHelper helper;

        public ResourceXmlApplicationContext(ConfigurableApplicationContext parent, Resource resource) {
            this.helper = new ApplicationContextHelper(parent, (GenericApplicationContext)this, resource){

                @Override
                protected String generateId(Object config) {
                    Resource resource = (Resource)config;
                    try {
                        return resource.getURI().toString();
                    }
                    catch (IOException e) {
                        return resource.toString();
                    }
                }

                @Override
                protected void loadConfiguration(Object config) {
                    Resource resource = (Resource)config;
                    ResourceXmlApplicationContext.this.load(new Resource[]{resource});
                }
            };
            this.refresh();
        }

        protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            super.prepareBeanFactory(beanFactory);
            this.helper.prepareBeanFactory(beanFactory);
        }

        public String toString() {
            return "ResourceXmlApplicationContext:" + this.getId();
        }
    }

    private abstract class ApplicationContextHelper {
        private final DefaultListableBeanFactory parentBeanFactory;
        private final ConfigurableApplicationContext parent;

        public ApplicationContextHelper(ConfigurableApplicationContext parent, GenericApplicationContext context, Object config) {
            this.parent = parent;
            if (parent != null) {
                Assert.isTrue((boolean)(parent.getBeanFactory() instanceof DefaultListableBeanFactory), (String)"The parent application context must have a bean factory of type DefaultListableBeanFactory");
                this.parentBeanFactory = (DefaultListableBeanFactory)parent.getBeanFactory();
            } else {
                this.parentBeanFactory = null;
            }
            context.setParent((ApplicationContext)parent);
            context.setId(this.generateId(config));
            this.loadConfiguration(config);
            GenericApplicationContextFactory.this.prepareContext(parent, (ConfigurableApplicationContext)context);
        }

        protected abstract String generateId(Object var1);

        protected abstract void loadConfiguration(Object var1);

        protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            if (this.parentBeanFactory != null) {
                GenericApplicationContextFactory.this.prepareBeanFactory((ConfigurableListableBeanFactory)this.parentBeanFactory, beanFactory);
                for (Class<? extends BeanFactoryPostProcessor> cls : GenericApplicationContextFactory.this.getBeanFactoryPostProcessorClasses()) {
                    for (String name : this.parent.getBeanNamesForType(cls)) {
                        beanFactory.registerSingleton(name, this.parent.getBean(name));
                    }
                }
            }
        }
    }
}

