/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.Map;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CoreNamespaceUtils {
    private static final String STEP_SCOPE_PROCESSOR_BEAN_NAME = "org.springframework.batch.core.scope.internalStepScope";
    private static final String STEP_SCOPE_PROCESSOR_CLASS_NAME = "org.springframework.batch.core.scope.StepScope";
    private static final String CUSTOM_EDITOR_CONFIGURER_CLASS_NAME = "org.springframework.beans.factory.config.CustomEditorConfigurer";
    private static final String RANGE_ARRAY_CLASS_NAME = "org.springframework.batch.item.file.transform.Range[]";
    private static final String RANGE_ARRAY_EDITOR_CLASS_NAME = "org.springframework.batch.item.file.transform.RangeArrayPropertyEditor";
    private static final String CORE_NAMESPACE_POST_PROCESSOR_CLASS_NAME = "org.springframework.batch.core.configuration.xml.CoreNamespacePostProcessor";

    protected static void autoregisterBeansForNamespace(ParserContext parserContext, Object source) {
        CoreNamespaceUtils.checkForStepScope(parserContext, source);
        CoreNamespaceUtils.addRangePropertyEditor(parserContext);
        CoreNamespaceUtils.addCoreNamespacePostProcessor(parserContext);
    }

    private static void checkForStepScope(ParserContext parserContext, Object source) {
        String[] beanNames;
        boolean foundStepScope = false;
        for (String beanName : beanNames = parserContext.getRegistry().getBeanDefinitionNames()) {
            BeanDefinition bd = parserContext.getRegistry().getBeanDefinition(beanName);
            if (!STEP_SCOPE_PROCESSOR_CLASS_NAME.equals(bd.getBeanClassName())) continue;
            foundStepScope = true;
            break;
        }
        if (!foundStepScope) {
            BeanDefinitionBuilder stepScopeBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)STEP_SCOPE_PROCESSOR_CLASS_NAME);
            AbstractBeanDefinition abd = stepScopeBuilder.getBeanDefinition();
            abd.setRole(2);
            abd.setSource(source);
            parserContext.getRegistry().registerBeanDefinition(STEP_SCOPE_PROCESSOR_BEAN_NAME, (BeanDefinition)abd);
        }
    }

    private static void addRangePropertyEditor(ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (!CoreNamespaceUtils.rangeArrayEditorAlreadyDefined(registry)) {
            AbstractBeanDefinition customEditorConfigurer = BeanDefinitionBuilder.genericBeanDefinition((String)CUSTOM_EDITOR_CONFIGURER_CLASS_NAME).getBeanDefinition();
            customEditorConfigurer.setRole(2);
            ManagedMap editors = new ManagedMap();
            editors.put((Object)RANGE_ARRAY_CLASS_NAME, (Object)RANGE_ARRAY_EDITOR_CLASS_NAME);
            customEditorConfigurer.getPropertyValues().addPropertyValue("customEditors", (Object)editors);
            registry.registerBeanDefinition(CUSTOM_EDITOR_CONFIGURER_CLASS_NAME, (BeanDefinition)customEditorConfigurer);
        }
    }

    private static boolean rangeArrayEditorAlreadyDefined(BeanDefinitionRegistry registry) {
        for (String beanName : registry.getBeanDefinitionNames()) {
            PropertyValue pv;
            BeanDefinition bd = registry.getBeanDefinition(beanName);
            if (!CUSTOM_EDITOR_CONFIGURER_CLASS_NAME.equals(bd.getBeanClassName()) || (pv = bd.getPropertyValues().getPropertyValue("customEditors")) == null) continue;
            for (Map.Entry entry : ((Map)pv.getValue()).entrySet()) {
                if (!(entry.getKey() instanceof TypedStringValue ? RANGE_ARRAY_CLASS_NAME.equals(((TypedStringValue)entry.getKey()).getValue()) : entry.getKey() instanceof String && RANGE_ARRAY_CLASS_NAME.equals(entry.getKey()))) continue;
                return true;
            }
        }
        return false;
    }

    private static void addCoreNamespacePostProcessor(ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (!CoreNamespaceUtils.coreNamespaceBeanPostProcessorAlreadyDefined(registry)) {
            AbstractBeanDefinition postProcessorBeanDef = BeanDefinitionBuilder.genericBeanDefinition((String)CORE_NAMESPACE_POST_PROCESSOR_CLASS_NAME).getBeanDefinition();
            postProcessorBeanDef.setRole(2);
            registry.registerBeanDefinition(CORE_NAMESPACE_POST_PROCESSOR_CLASS_NAME, (BeanDefinition)postProcessorBeanDef);
        }
    }

    private static boolean coreNamespaceBeanPostProcessorAlreadyDefined(BeanDefinitionRegistry registry) {
        for (String beanName : registry.getBeanDefinitionNames()) {
            BeanDefinition bd = registry.getBeanDefinition(beanName);
            if (!CORE_NAMESPACE_POST_PROCESSOR_CLASS_NAME.equals(bd.getBeanClassName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnderspecified(Element element) {
        return CoreNamespaceUtils.isAbstract(element) || StringUtils.hasText((String)element.getAttribute("parent"));
    }

    public static boolean isAbstract(Element element) {
        String abstractAttr = element.getAttribute("abstract");
        return StringUtils.hasText((String)abstractAttr) && Boolean.valueOf(abstractAttr) != false;
    }

    public static boolean namespaceMatchesVersion(Element element) {
        return CoreNamespaceUtils.matchesVersionInternal(element) && CoreNamespaceUtils.matchesVersionInternal(element.getOwnerDocument().getDocumentElement());
    }

    private static boolean matchesVersionInternal(Element element) {
        String schemaLocation = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        return schemaLocation.matches("(?m).*spring-batch-2.2.xsd.*") || schemaLocation.matches("(?m).*spring-batch.xsd.*") || !schemaLocation.matches("(?m).*spring-batch.*");
    }
}

