/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.NoSuchObjectException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;

public class JdbcJobExecutionDao
extends AbstractJdbcBatchMetadataDao
implements JobExecutionDao,
InitializingBean {
    private static final Log logger = LogFactory.getLog(JdbcJobExecutionDao.class);
    private static final String SAVE_JOB_EXECUTION = "INSERT into %PREFIX%JOB_EXECUTION(JOB_EXECUTION_ID, JOB_INSTANCE_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, VERSION, CREATE_TIME, LAST_UPDATED) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String CHECK_JOB_EXECUTION_EXISTS = "SELECT COUNT(*) FROM %PREFIX%JOB_EXECUTION WHERE JOB_EXECUTION_ID = ?";
    private static final String GET_STATUS = "SELECT STATUS from %PREFIX%JOB_EXECUTION where JOB_EXECUTION_ID = ?";
    private static final String UPDATE_JOB_EXECUTION = "UPDATE %PREFIX%JOB_EXECUTION set START_TIME = ?, END_TIME = ?,  STATUS = ?, EXIT_CODE = ?, EXIT_MESSAGE = ?, VERSION = ?, CREATE_TIME = ?, LAST_UPDATED = ? where JOB_EXECUTION_ID = ? and VERSION = ?";
    private static final String FIND_JOB_EXECUTIONS = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED, VERSION from %PREFIX%JOB_EXECUTION where JOB_INSTANCE_ID = ? order by JOB_EXECUTION_ID desc";
    private static final String GET_LAST_EXECUTION = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED, VERSION from %PREFIX%JOB_EXECUTION E where JOB_INSTANCE_ID = ? and JOB_EXECUTION_ID in (SELECT max(JOB_EXECUTION_ID) from %PREFIX%JOB_EXECUTION E2 where E2.JOB_INSTANCE_ID = ?)";
    private static final String GET_EXECUTION_BY_ID = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED, VERSION from %PREFIX%JOB_EXECUTION where JOB_EXECUTION_ID = ?";
    private static final String GET_RUNNING_EXECUTIONS = "SELECT E.JOB_EXECUTION_ID, E.START_TIME, E.END_TIME, E.STATUS, E.EXIT_CODE, E.EXIT_MESSAGE, E.CREATE_TIME, E.LAST_UPDATED, E.VERSION, E.JOB_INSTANCE_ID from %PREFIX%JOB_EXECUTION E, %PREFIX%JOB_INSTANCE I where E.JOB_INSTANCE_ID=I.JOB_INSTANCE_ID and I.JOB_NAME=? and E.END_TIME is NULL order by E.JOB_EXECUTION_ID desc";
    private static final String CURRENT_VERSION_JOB_EXECUTION = "SELECT VERSION FROM %PREFIX%JOB_EXECUTION WHERE JOB_EXECUTION_ID=?";
    private static final String FIND_PARAMS_FROM_ID = "SELECT JOB_EXECUTION_ID, KEY_NAME, TYPE_CD, STRING_VAL, DATE_VAL, LONG_VAL, DOUBLE_VAL, IDENTIFYING from %PREFIX%JOB_EXECUTION_PARAMS where JOB_EXECUTION_ID = ?";
    private static final String CREATE_JOB_PARAMETERS = "INSERT into %PREFIX%JOB_EXECUTION_PARAMS(JOB_EXECUTION_ID, KEY_NAME, TYPE_CD, STRING_VAL, DATE_VAL, LONG_VAL, DOUBLE_VAL, IDENTIFYING) values (?, ?, ?, ?, ?, ?, ?, ?)";
    private int exitMessageLength = 2500;
    private DataFieldMaxValueIncrementer jobExecutionIncrementer;

    public void setExitMessageLength(int exitMessageLength) {
        this.exitMessageLength = exitMessageLength;
    }

    public void setJobExecutionIncrementer(DataFieldMaxValueIncrementer jobExecutionIncrementer) {
        this.jobExecutionIncrementer = jobExecutionIncrementer;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.jobExecutionIncrementer, (String)"The jobExecutionIncrementer must not be null.");
    }

    @Override
    public List<JobExecution> findJobExecutions(JobInstance job) {
        Assert.notNull((Object)job, (String)"Job cannot be null.");
        Assert.notNull((Object)job.getId(), (String)"Job Id cannot be null.");
        return this.getJdbcTemplate().query(this.getQuery(FIND_JOB_EXECUTIONS), (RowMapper)new JobExecutionRowMapper(job), new Object[]{job.getId()});
    }

    @Override
    public void saveJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        jobExecution.incrementVersion();
        jobExecution.setId(this.jobExecutionIncrementer.nextLongValue());
        Object[] parameters = new Object[]{jobExecution.getId(), jobExecution.getJobId(), jobExecution.getStartTime(), jobExecution.getEndTime(), jobExecution.getStatus().toString(), jobExecution.getExitStatus().getExitCode(), jobExecution.getExitStatus().getExitDescription(), jobExecution.getVersion(), jobExecution.getCreateTime(), jobExecution.getLastUpdated()};
        this.getJdbcTemplate().update(this.getQuery(SAVE_JOB_EXECUTION), parameters, new int[]{-5, -5, 93, 93, 12, 12, 12, 4, 93, 93});
        this.insertJobParameters(jobExecution.getId(), jobExecution.getJobParameters());
    }

    private void validateJobExecution(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution);
        Assert.notNull((Object)jobExecution.getJobId(), (String)"JobExecution Job-Id cannot be null.");
        Assert.notNull((Object)((Object)jobExecution.getStatus()), (String)"JobExecution status cannot be null.");
        Assert.notNull((Object)jobExecution.getCreateTime(), (String)"JobExecution create time cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        Assert.notNull((Object)jobExecution.getId(), (String)"JobExecution ID cannot be null. JobExecution must be saved before it can be updated");
        Assert.notNull((Object)jobExecution.getVersion(), (String)"JobExecution version cannot be null. JobExecution must be saved before it can be updated");
        JobExecution jobExecution2 = jobExecution;
        synchronized (jobExecution2) {
            Integer version = jobExecution.getVersion() + 1;
            String exitDescription = jobExecution.getExitStatus().getExitDescription();
            if (exitDescription != null && exitDescription.length() > this.exitMessageLength) {
                exitDescription = exitDescription.substring(0, this.exitMessageLength);
                logger.debug((Object)("Truncating long message before update of JobExecution: " + jobExecution));
            }
            Object[] parameters = new Object[]{jobExecution.getStartTime(), jobExecution.getEndTime(), jobExecution.getStatus().toString(), jobExecution.getExitStatus().getExitCode(), exitDescription, version, jobExecution.getCreateTime(), jobExecution.getLastUpdated(), jobExecution.getId(), jobExecution.getVersion()};
            if (this.getJdbcTemplate().queryForInt(this.getQuery(CHECK_JOB_EXECUTION_EXISTS), new Object[]{jobExecution.getId()}) != 1) {
                throw new NoSuchObjectException("Invalid JobExecution, ID " + jobExecution.getId() + " not found.");
            }
            int count = this.getJdbcTemplate().update(this.getQuery(UPDATE_JOB_EXECUTION), parameters, new int[]{93, 93, 12, 12, 12, 4, 93, 93, -5, 4});
            if (count == 0) {
                int curentVersion = this.getJdbcTemplate().queryForInt(this.getQuery(CURRENT_VERSION_JOB_EXECUTION), new Object[]{jobExecution.getId()});
                throw new OptimisticLockingFailureException("Attempt to update job execution id=" + jobExecution.getId() + " with wrong version (" + jobExecution.getVersion() + "), where current version is " + curentVersion);
            }
            jobExecution.incrementVersion();
        }
    }

    @Override
    public JobExecution getLastJobExecution(JobInstance jobInstance) {
        Long id = jobInstance.getId();
        List executions = this.getJdbcTemplate().query(this.getQuery(GET_LAST_EXECUTION), (RowMapper)new JobExecutionRowMapper(jobInstance), new Object[]{id, id});
        Assert.state((executions.size() <= 1 ? 1 : 0) != 0, (String)"There must be at most one latest job execution");
        if (executions.isEmpty()) {
            return null;
        }
        return (JobExecution)executions.get(0);
    }

    @Override
    public JobExecution getJobExecution(Long executionId) {
        try {
            JobExecution jobExecution = (JobExecution)this.getJdbcTemplate().queryForObject(this.getQuery(GET_EXECUTION_BY_ID), (RowMapper)new JobExecutionRowMapper(), new Object[]{executionId});
            return jobExecution;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        final HashSet<JobExecution> result = new HashSet<JobExecution>();
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                JobExecutionRowMapper mapper = new JobExecutionRowMapper();
                result.add(mapper.mapRow(rs, 0));
            }
        };
        this.getJdbcTemplate().query(this.getQuery(GET_RUNNING_EXECUTIONS), new Object[]{jobName}, handler);
        return result;
    }

    @Override
    public void synchronizeStatus(JobExecution jobExecution) {
        int currentVersion = this.getJdbcTemplate().queryForInt(this.getQuery(CURRENT_VERSION_JOB_EXECUTION), new Object[]{jobExecution.getId()});
        if (currentVersion != jobExecution.getVersion()) {
            String status = (String)this.getJdbcTemplate().queryForObject(this.getQuery(GET_STATUS), String.class, new Object[]{jobExecution.getId()});
            jobExecution.upgradeStatus(BatchStatus.valueOf(status));
            jobExecution.setVersion(currentVersion);
        }
    }

    private void insertJobParameters(Long executionId, JobParameters jobParameters) {
        for (Map.Entry<String, JobParameter> entry : jobParameters.getParameters().entrySet()) {
            JobParameter jobParameter = entry.getValue();
            this.insertParameter(executionId, jobParameter.getType(), entry.getKey(), jobParameter.getValue(), jobParameter.isIdentifying());
        }
    }

    private void insertParameter(Long executionId, JobParameter.ParameterType type, String key, Object value, boolean identifying) {
        String identifyingFlag;
        Object[] args = new Object[]{};
        int[] argTypes = new int[]{-5, 12, 12, 12, 93, -5, 8, 1};
        String string = identifyingFlag = identifying ? "Y" : "N";
        if (type == JobParameter.ParameterType.STRING) {
            args = new Object[]{executionId, key, type, value, new Timestamp(0L), 0L, 0.0, identifyingFlag};
        } else if (type == JobParameter.ParameterType.LONG) {
            args = new Object[]{executionId, key, type, "", new Timestamp(0L), value, new Double(0.0), identifyingFlag};
        } else if (type == JobParameter.ParameterType.DOUBLE) {
            args = new Object[]{executionId, key, type, "", new Timestamp(0L), 0L, value, identifyingFlag};
        } else if (type == JobParameter.ParameterType.DATE) {
            args = new Object[]{executionId, key, type, "", value, 0L, 0.0, identifyingFlag};
        }
        this.getJdbcTemplate().update(this.getQuery(CREATE_JOB_PARAMETERS), args, argTypes);
    }

    private JobParameters getJobParameters(Long executionId) {
        final HashMap<String, JobParameter> map = new HashMap<String, JobParameter>();
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                JobParameter.ParameterType type = JobParameter.ParameterType.valueOf(rs.getString(3));
                JobParameter value = null;
                if (type == JobParameter.ParameterType.STRING) {
                    value = new JobParameter(rs.getString(4), rs.getString(8).equalsIgnoreCase("Y"));
                } else if (type == JobParameter.ParameterType.LONG) {
                    value = new JobParameter(rs.getLong(6), rs.getString(8).equalsIgnoreCase("Y"));
                } else if (type == JobParameter.ParameterType.DOUBLE) {
                    value = new JobParameter(rs.getDouble(7), rs.getString(8).equalsIgnoreCase("Y"));
                } else if (type == JobParameter.ParameterType.DATE) {
                    value = new JobParameter(rs.getTimestamp(5), rs.getString(8).equalsIgnoreCase("Y"));
                }
                map.put(rs.getString(2), value);
            }
        };
        this.getJdbcTemplate().query(this.getQuery(FIND_PARAMS_FROM_ID), new Object[]{executionId}, handler);
        return new JobParameters(map);
    }

    private final class JobExecutionRowMapper
    implements ParameterizedRowMapper<JobExecution> {
        private JobInstance jobInstance;
        private JobParameters jobParameters;

        public JobExecutionRowMapper() {
        }

        public JobExecutionRowMapper(JobInstance jobInstance) {
            this.jobInstance = jobInstance;
        }

        public JobExecution mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long id = rs.getLong(1);
            if (this.jobParameters == null) {
                this.jobParameters = JdbcJobExecutionDao.this.getJobParameters(id);
            }
            JobExecution jobExecution = this.jobInstance == null ? new JobExecution(id, this.jobParameters) : new JobExecution(this.jobInstance, id, this.jobParameters);
            jobExecution.setStartTime(rs.getTimestamp(2));
            jobExecution.setEndTime(rs.getTimestamp(3));
            jobExecution.setStatus(BatchStatus.valueOf(rs.getString(4)));
            jobExecution.setExitStatus(new ExitStatus(rs.getString(5), rs.getString(6)));
            jobExecution.setCreateTime(rs.getTimestamp(7));
            jobExecution.setLastUpdated(rs.getTimestamp(8));
            jobExecution.setVersion(rs.getInt(9));
            return jobExecution;
        }
    }
}

