/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecution;
import org.springframework.batch.core.job.flow.FlowExecutionException;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.State;
import org.springframework.batch.core.job.flow.support.StateTransition;
import org.springframework.beans.factory.InitializingBean;

public class SimpleFlow
implements Flow,
InitializingBean {
    private static final Log logger = LogFactory.getLog(SimpleFlow.class);
    private State startState;
    private Map<String, SortedSet<StateTransition>> transitionMap = new HashMap<String, SortedSet<StateTransition>>();
    private Map<String, State> stateMap = new HashMap<String, State>();
    private List<StateTransition> stateTransitions = new ArrayList<StateTransition>();
    private final String name;

    public SimpleFlow(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setStateTransitions(List<StateTransition> stateTransitions) {
        this.stateTransitions = stateTransitions;
    }

    @Override
    public State getState(String stateName) {
        return this.stateMap.get(stateName);
    }

    @Override
    public Collection<State> getStates() {
        return new HashSet<State>(this.stateMap.values());
    }

    public void afterPropertiesSet() throws Exception {
        this.initializeTransitions();
    }

    @Override
    public FlowExecution start(FlowExecutor executor) throws FlowExecutionException {
        if (this.startState == null) {
            this.initializeTransitions();
        }
        State state = this.startState;
        String stateName = state.getName();
        return this.resume(stateName, executor);
    }

    @Override
    public FlowExecution resume(String stateName, FlowExecutor executor) throws FlowExecutionException {
        FlowExecutionStatus status = FlowExecutionStatus.UNKNOWN;
        State state = this.stateMap.get(stateName);
        logger.debug((Object)("Resuming state=" + stateName + " with status=" + status));
        StepExecution stepExecution = null;
        while (this.isFlowContinued(state, status, stepExecution)) {
            stateName = state.getName();
            try {
                logger.debug((Object)("Handling state=" + stateName));
                status = state.handle(executor);
                stepExecution = executor.getStepExecution();
            }
            catch (FlowExecutionException e) {
                executor.close(new FlowExecution(stateName, status));
                throw e;
            }
            catch (Exception e) {
                executor.close(new FlowExecution(stateName, status));
                throw new FlowExecutionException(String.format("Ended flow=%s at state=%s with exception", this.name, stateName), e);
            }
            logger.debug((Object)("Completed state=" + stateName + " with status=" + status));
            state = this.nextState(stateName, status);
        }
        FlowExecution result = new FlowExecution(stateName, status);
        executor.close(result);
        return result;
    }

    private boolean isFlowContinued(State state, FlowExecutionStatus status, StepExecution stepExecution) {
        boolean continued = true;
        boolean bl = continued = state != null && status != FlowExecutionStatus.STOPPED;
        if (stepExecution != null) {
            Boolean reRun = (Boolean)stepExecution.getExecutionContext().get("batch.restart");
            Boolean executed = (Boolean)stepExecution.getExecutionContext().get("batch.executed");
            if (!(executed != null && executed.booleanValue() || reRun == null || !reRun.booleanValue() || status != FlowExecutionStatus.STOPPED || state.getName().endsWith(stepExecution.getStepName()))) {
                continued = true;
            }
        }
        return continued;
    }

    private State nextState(String stateName, FlowExecutionStatus status) throws FlowExecutionException {
        Set set = this.transitionMap.get(stateName);
        if (set == null) {
            throw new FlowExecutionException(String.format("No transitions found in flow=%s for state=%s", this.getName(), stateName));
        }
        String next = null;
        String exitCode = status.getName();
        for (StateTransition stateTransition : set) {
            if (!stateTransition.matches(exitCode) && (!exitCode.equals("PENDING") || !stateTransition.matches("STOPPED"))) continue;
            if (stateTransition.isEnd()) {
                return null;
            }
            next = stateTransition.getNext();
            break;
        }
        if (next == null) {
            throw new FlowExecutionException(String.format("Next state not found in flow=%s for state=%s with exit status=%s", this.getName(), stateName, status.getName()));
        }
        if (!this.stateMap.containsKey(next)) {
            throw new FlowExecutionException(String.format("Next state not specified in flow=%s for next=%s", this.getName(), next));
        }
        return this.stateMap.get(next);
    }

    private void initializeTransitions() {
        State state;
        this.startState = null;
        this.transitionMap.clear();
        this.stateMap.clear();
        boolean hasEndStep = false;
        if (this.stateTransitions.isEmpty()) {
            throw new IllegalArgumentException("No start state was found. You must specify at least one step in a job.");
        }
        for (StateTransition stateTransition : this.stateTransitions) {
            state = stateTransition.getState();
            String stateName = state.getName();
            this.stateMap.put(stateName, state);
        }
        for (StateTransition stateTransition : this.stateTransitions) {
            String name;
            SortedSet<StateTransition> set;
            state = stateTransition.getState();
            if (!stateTransition.isEnd()) {
                String next = stateTransition.getNext();
                if (!this.stateMap.containsKey(next)) {
                    throw new IllegalArgumentException("Missing state for [" + stateTransition + "]");
                }
            } else {
                hasEndStep = true;
            }
            if ((set = this.transitionMap.get(name = state.getName())) == null) {
                set = new TreeSet<StateTransition>();
                this.transitionMap.put(name, set);
            }
            set.add(stateTransition);
        }
        if (!hasEndStep) {
            throw new IllegalArgumentException("No end state was found.  You must specify at least one transition with no next state.");
        }
        this.startState = this.stateTransitions.get(0).getState();
    }
}

