/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.core.serializer.DefaultDeserializer;
import org.springframework.core.serializer.DefaultSerializer;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.util.Assert;

public class DefaultExecutionContextSerializer
implements ExecutionContextSerializer {
    private Serializer serializer = new DefaultSerializer();
    private Deserializer deserializer = new DefaultDeserializer();

    public void serialize(Object context, OutputStream out) throws IOException {
        Assert.notNull((Object)context);
        Assert.notNull((Object)out);
        for (Object value : ((Map)context).values()) {
            Assert.isInstanceOf(Serializable.class, value, (String)("Value: [ " + value + "must be serializable."));
        }
        this.serializer.serialize(context, out);
    }

    public Object deserialize(InputStream inputStream) throws IOException {
        return this.deserializer.deserialize(inputStream);
    }
}

