/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class XStreamExecutionContextStringSerializer
implements ExecutionContextSerializer,
InitializingBean {
    private ReflectionProvider reflectionProvider = null;
    private HierarchicalStreamDriver hierarchicalStreamDriver;
    private XStream xstream;

    public void setReflectionProvider(ReflectionProvider reflectionProvider) {
        this.reflectionProvider = reflectionProvider;
    }

    public void setHierarchicalStreamDriver(HierarchicalStreamDriver hierarchicalStreamDriver) {
        this.hierarchicalStreamDriver = hierarchicalStreamDriver;
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public synchronized void init() throws Exception {
        if (this.hierarchicalStreamDriver == null) {
            this.hierarchicalStreamDriver = new JettisonMappedXmlDriver();
        }
        this.xstream = this.reflectionProvider == null ? new XStream(this.hierarchicalStreamDriver) : new XStream(this.reflectionProvider, this.hierarchicalStreamDriver);
    }

    public void serialize(Object context, OutputStream out) throws IOException {
        Assert.notNull((Object)context);
        Assert.notNull((Object)out);
        out.write(this.xstream.toXML(context).getBytes());
    }

    public Object deserialize(InputStream in) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        return this.xstream.fromXML(sb.toString());
    }
}

