/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.launch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.jsr.JsrJobContextFactoryBean;
import org.springframework.batch.core.jsr.JsrJobExecution;
import org.springframework.batch.core.jsr.JsrStepExecution;
import org.springframework.batch.core.jsr.configuration.xml.JsrXmlApplicationContext;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.core.step.NoSuchStepException;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.core.step.tasklet.StoppableTasklet;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

public class JsrJobOperator
implements JobOperator,
InitializingBean {
    private static final String JSR_JOB_CONTEXT_BEAN_NAME = "jsr_jobContext";
    private final Log logger = LogFactory.getLog(this.getClass());
    private JobExplorer jobExplorer;
    private JobRepository jobRepository;
    private TaskExecutor taskExecutor;
    private JobParametersConverter jobParametersConverter;
    private static ApplicationContext baseContext;
    private static ExecutingJobRegistry jobRegistry;

    public JsrJobOperator() {
        BeanFactoryLocator beanFactoryLocactor = ContextSingletonBeanFactoryLocator.getInstance();
        BeanFactoryReference ref = beanFactoryLocactor.useBeanFactory("baseContext");
        baseContext = (ApplicationContext)ref.getFactory();
        baseContext.getAutowireCapableBeanFactory().autowireBeanProperties((Object)this, 2, false);
        if (this.taskExecutor == null) {
            this.taskExecutor = new SimpleAsyncTaskExecutor();
        }
    }

    public JsrJobOperator(JobExplorer jobExplorer, JobRepository jobRepository, JobParametersConverter jobParametersConverter) {
        Assert.notNull((Object)jobExplorer, (String)"A JobExplorer is required");
        Assert.notNull((Object)jobRepository, (String)"A JobRepository is required");
        Assert.notNull((Object)jobParametersConverter, (String)"A ParametersConverter is required");
        this.jobExplorer = jobExplorer;
        this.jobRepository = jobRepository;
        this.jobParametersConverter = jobParametersConverter;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        Assert.notNull((Object)jobExplorer, (String)"A JobExplorer is required");
        this.jobExplorer = jobExplorer;
    }

    public void setJobRepository(JobRepository jobRepository) {
        Assert.notNull((Object)jobRepository, (String)"A JobRepository is required");
        this.jobRepository = jobRepository;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.taskExecutor == null) {
            this.taskExecutor = new SimpleAsyncTaskExecutor();
        }
    }

    public void setJobParametersConverter(JobParametersConverter converter) {
        Assert.notNull((Object)converter, (String)"A Converter is required");
        this.jobParametersConverter = converter;
    }

    public void abandon(long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        JobExecution jobExecution = this.jobExplorer.getJobExecution(jobExecutionId);
        if (jobExecution == null) {
            throw new NoSuchJobExecutionException("Unable to retrieve JobExecution for id " + jobExecutionId);
        }
        if (jobExecution.isRunning()) {
            throw new JobExecutionIsRunningException("Unable to abandon a job that is currently running");
        }
        jobExecution.upgradeStatus(BatchStatus.ABANDONED);
        this.jobRepository.update(jobExecution);
    }

    public javax.batch.runtime.JobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        JobExecution jobExecution = this.jobExplorer.getJobExecution(executionId);
        if (jobExecution == null) {
            throw new NoSuchJobExecutionException("No execution was found for executionId " + executionId);
        }
        return new JsrJobExecution(jobExecution, this.jobParametersConverter);
    }

    public List<javax.batch.runtime.JobExecution> getJobExecutions(javax.batch.runtime.JobInstance jobInstance) throws NoSuchJobInstanceException, JobSecurityException {
        if (jobInstance == null) {
            throw new NoSuchJobInstanceException("A null JobInstance was provided");
        }
        JobInstance instance = (JobInstance)jobInstance;
        List<JobExecution> batchExecutions = this.jobExplorer.getJobExecutions(instance);
        if (batchExecutions == null || batchExecutions.size() == 0) {
            throw new NoSuchJobInstanceException("Unable to find JobInstance " + jobInstance.getInstanceId());
        }
        ArrayList<javax.batch.runtime.JobExecution> results = new ArrayList<javax.batch.runtime.JobExecution>(batchExecutions.size());
        for (JobExecution jobExecution : batchExecutions) {
            results.add(new JsrJobExecution(jobExecution, this.jobParametersConverter));
        }
        return results;
    }

    public javax.batch.runtime.JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        JobExecution execution = this.jobExplorer.getJobExecution(executionId);
        if (execution == null) {
            throw new NoSuchJobExecutionException("The JobExecution was not found");
        }
        return this.jobExplorer.getJobInstance(execution.getJobInstance().getId());
    }

    public int getJobInstanceCount(String jobName) throws javax.batch.operations.NoSuchJobException, JobSecurityException {
        try {
            int count = this.jobExplorer.getJobInstanceCount(jobName);
            if (count <= 0) {
                throw new javax.batch.operations.NoSuchJobException("No job instances were found for job name " + jobName);
            }
            return count;
        }
        catch (NoSuchJobException e) {
            throw new javax.batch.operations.NoSuchJobException("No job instances were found for job name " + jobName);
        }
    }

    public List<javax.batch.runtime.JobInstance> getJobInstances(String jobName, int start, int count) throws javax.batch.operations.NoSuchJobException, JobSecurityException {
        List<JobInstance> jobInstances = this.jobExplorer.getJobInstances(jobName, start, count);
        if (jobInstances == null || jobInstances.size() == 0) {
            throw new javax.batch.operations.NoSuchJobException("The job was not found");
        }
        return new ArrayList<javax.batch.runtime.JobInstance>(jobInstances);
    }

    public Set<String> getJobNames() throws JobSecurityException {
        return new HashSet<String>(this.jobExplorer.getJobNames());
    }

    public Properties getParameters(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        JobExecution execution = this.jobExplorer.getJobExecution(executionId);
        if (execution == null) {
            throw new NoSuchJobExecutionException("Unable to find the JobExecution for id " + executionId);
        }
        Properties properties = this.jobParametersConverter.getProperties(execution.getJobParameters());
        properties.remove("jsr_batch_run_id");
        return properties;
    }

    public List<Long> getRunningExecutions(String name) throws javax.batch.operations.NoSuchJobException, JobSecurityException {
        Set<JobExecution> findRunningJobExecutions = this.jobExplorer.findRunningJobExecutions(name);
        if (findRunningJobExecutions.isEmpty()) {
            throw new javax.batch.operations.NoSuchJobException("Job name: " + name + " not found.");
        }
        ArrayList<Long> results = new ArrayList<Long>(findRunningJobExecutions.size());
        for (JobExecution jobExecution : findRunningJobExecutions) {
            results.add(jobExecution.getId());
        }
        return results;
    }

    public List<javax.batch.runtime.StepExecution> getStepExecutions(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        JobExecution execution = this.jobExplorer.getJobExecution(executionId);
        if (execution == null) {
            throw new javax.batch.operations.NoSuchJobException("JobExecution with the id " + executionId + " was not found");
        }
        Collection<StepExecution> executions = execution.getStepExecutions();
        ArrayList<javax.batch.runtime.StepExecution> batchExecutions = new ArrayList<javax.batch.runtime.StepExecution>();
        if (executions != null) {
            for (StepExecution stepExecution : executions) {
                if (stepExecution.getStepName().contains(":partition")) continue;
                batchExecutions.add(new JsrStepExecution(this.jobExplorer.getStepExecution(executionId, stepExecution.getId())));
            }
        }
        return batchExecutions;
    }

    public long restart(long executionId, Properties params) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        JobExecution jobExecution;
        JobExecution previousJobExecution = this.jobExplorer.getJobExecution(executionId);
        if (previousJobExecution == null) {
            throw new NoSuchJobExecutionException("No JobExecution found for id: [" + executionId + "]");
        }
        if (previousJobExecution.getStatus().equals((Object)BatchStatus.COMPLETED)) {
            throw new JobExecutionAlreadyCompleteException("The requested job has already completed");
        }
        List<JobExecution> previousExecutions = this.jobExplorer.getJobExecutions(previousJobExecution.getJobInstance());
        for (JobExecution jobExecution2 : previousExecutions) {
            if (jobExecution2.getCreateTime().compareTo(previousJobExecution.getCreateTime()) > 0) {
                throw new JobExecutionNotMostRecentException("The requested JobExecution to restart was not the most recently run");
            }
            if (!jobExecution2.getStatus().equals((Object)BatchStatus.ABANDONED)) continue;
            throw new JobRestartException("JobExecution ID: " + jobExecution2.getId() + " is abandoned and attempted to be restarted.");
        }
        final String jobName = previousJobExecution.getJobInstance().getJobName();
        Properties jobRestartProperties = this.getJobRestartProperties(params, previousJobExecution);
        final JsrXmlApplicationContext batchContext = new JsrXmlApplicationContext(jobRestartProperties);
        batchContext.setValidating(false);
        ClassPathResource batchXml = new ClassPathResource("/META-INF/batch.xml");
        ClassPathResource jobXml = new ClassPathResource(previousJobExecution.getJobConfigurationName());
        if (batchXml.exists()) {
            batchContext.load(new Resource[]{batchXml});
        }
        if (jobXml.exists()) {
            batchContext.load(new Resource[]{jobXml});
        }
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.jsr.JsrJobContextFactoryBean").getBeanDefinition();
        beanDefinition.setScope("singleton");
        batchContext.registerBeanDefinition(JSR_JOB_CONTEXT_BEAN_NAME, (BeanDefinition)beanDefinition);
        batchContext.setParent(baseContext);
        try {
            batchContext.refresh();
        }
        catch (BeanCreationException e) {
            throw new JobRestartException((Throwable)e);
        }
        try {
            JobParameters jobParameters = this.jobParametersConverter.getJobParameters(jobRestartProperties);
            jobExecution = this.jobRepository.createJobExecution(previousJobExecution.getJobInstance(), jobParameters, previousJobExecution.getJobConfigurationName());
        }
        catch (Exception e) {
            throw new JobRestartException((Throwable)e);
        }
        try {
            final Semaphore semaphore = new Semaphore(1);
            final List exceptionHolder = Collections.synchronizedList(new ArrayList());
            semaphore.acquire();
            this.taskExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JsrJobContextFactoryBean factoryBean = null;
                    try {
                        factoryBean = (JsrJobContextFactoryBean)batchContext.getBean("&jsr_jobContext");
                        factoryBean.setJobExecution(jobExecution);
                        Job job = (Job)batchContext.getBean(Job.class);
                        if (!job.isRestartable()) {
                            throw new JobRestartException("Job " + jobName + " is not restartable");
                        }
                        semaphore.release();
                        jobRegistry.register(job, jobExecution);
                        job.execute(jobExecution);
                        jobRegistry.remove(jobExecution);
                    }
                    catch (Exception e) {
                        exceptionHolder.add(e);
                    }
                    finally {
                        if (factoryBean != null) {
                            factoryBean.close();
                        }
                        batchContext.close();
                        if (semaphore.availablePermits() == 0) {
                            semaphore.release();
                        }
                    }
                }
            });
            semaphore.acquire();
            if (exceptionHolder.size() > 0) {
                semaphore.release();
                throw new JobRestartException((Throwable)exceptionHolder.get(0));
            }
        }
        catch (Exception e) {
            jobExecution.upgradeStatus(BatchStatus.FAILED);
            if (jobExecution.getExitStatus().equals(ExitStatus.UNKNOWN)) {
                jobExecution.setExitStatus(ExitStatus.FAILED.addExitDescription(e));
            }
            this.jobRepository.update(jobExecution);
            if (batchContext.isActive()) {
                batchContext.close();
            }
            throw new JobRestartException((Throwable)e);
        }
        return jobExecution.getId();
    }

    protected Properties getJobRestartProperties(Properties params, JobExecution previousJobExecution) {
        JobParameters previousJobParameters;
        Properties jobRestartProperties = new Properties();
        if (previousJobExecution != null && (previousJobParameters = previousJobExecution.getJobParameters()) != null && !previousJobParameters.isEmpty()) {
            jobRestartProperties.putAll((Map<?, ?>)previousJobParameters.toProperties());
        }
        if (params != null) {
            Enumeration<?> propertyNames = params.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String curName = (String)propertyNames.nextElement();
                jobRestartProperties.setProperty(curName, params.getProperty(curName));
            }
        }
        return jobRestartProperties;
    }

    public long start(String jobName, Properties params) throws JobStartException, JobSecurityException {
        JobExecution jobExecution;
        final JsrXmlApplicationContext batchContext = new JsrXmlApplicationContext(params);
        batchContext.setValidating(false);
        ClassPathResource batchXml = new ClassPathResource("/META-INF/batch.xml");
        String jobConfigurationLocation = "/META-INF/batch-jobs/" + jobName + ".xml";
        ClassPathResource jobXml = new ClassPathResource(jobConfigurationLocation);
        if (batchXml.exists()) {
            batchContext.load(new Resource[]{batchXml});
        }
        if (jobXml.exists()) {
            batchContext.load(new Resource[]{jobXml});
        }
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.jsr.JsrJobContextFactoryBean").getBeanDefinition();
        beanDefinition.setScope("singleton");
        batchContext.registerBeanDefinition(JSR_JOB_CONTEXT_BEAN_NAME, (BeanDefinition)beanDefinition);
        batchContext.setParent(baseContext);
        try {
            batchContext.refresh();
        }
        catch (BeanCreationException e) {
            throw new JobStartException((Throwable)e);
        }
        Assert.notNull((Object)jobName, (String)"The job name must not be null.");
        try {
            JobParameters jobParameters = this.jobParametersConverter.getJobParameters(params);
            String[] jobNames = batchContext.getBeanNamesForType(Job.class);
            if (jobNames == null || jobNames.length <= 0) {
                throw new BatchRuntimeException("No Job defined in current context");
            }
            JobInstance jobInstance = this.jobRepository.createJobInstance(jobNames[0], jobParameters);
            jobExecution = this.jobRepository.createJobExecution(jobInstance, jobParameters, jobConfigurationLocation);
        }
        catch (Exception e) {
            throw new JobStartException((Throwable)e);
        }
        try {
            final Semaphore semaphore = new Semaphore(1);
            final List exceptionHolder = Collections.synchronizedList(new ArrayList());
            semaphore.acquire();
            this.taskExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JsrJobContextFactoryBean factoryBean = null;
                    try {
                        factoryBean = (JsrJobContextFactoryBean)batchContext.getBean("&jsr_jobContext");
                        factoryBean.setJobExecution(jobExecution);
                        Job job = (Job)batchContext.getBean(Job.class);
                        semaphore.release();
                        jobRegistry.register(job, jobExecution);
                        job.execute(jobExecution);
                        jobRegistry.remove(jobExecution);
                    }
                    catch (Exception e) {
                        exceptionHolder.add(e);
                    }
                    finally {
                        if (factoryBean != null) {
                            factoryBean.close();
                        }
                        batchContext.close();
                        if (semaphore.availablePermits() == 0) {
                            semaphore.release();
                        }
                    }
                }
            });
            semaphore.acquire();
            if (exceptionHolder.size() > 0) {
                semaphore.release();
                throw new JobStartException((Throwable)exceptionHolder.get(0));
            }
        }
        catch (Exception e) {
            if (jobRegistry.exists(jobExecution.getId())) {
                jobRegistry.remove(jobExecution);
            }
            jobExecution.upgradeStatus(BatchStatus.FAILED);
            if (jobExecution.getExitStatus().equals(ExitStatus.UNKNOWN)) {
                jobExecution.setExitStatus(ExitStatus.FAILED.addExitDescription(e));
            }
            this.jobRepository.update(jobExecution);
            if (batchContext.isActive()) {
                batchContext.close();
            }
            throw new JobStartException((Throwable)e);
        }
        return jobExecution.getId();
    }

    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        JobExecution jobExecution = this.jobExplorer.getJobExecution(executionId);
        BatchStatus status = jobExecution.getStatus();
        if (status != BatchStatus.STARTED && status != BatchStatus.STARTING) {
            throw new JobExecutionNotRunningException("JobExecution must be running so that it can be stopped: " + jobExecution);
        }
        jobExecution.setStatus(BatchStatus.STOPPING);
        this.jobRepository.update(jobExecution);
        try {
            Job job = jobRegistry.getJob(jobExecution.getId());
            if (job instanceof StepLocator) {
                for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
                    if (!stepExecution.getStatus().isRunning()) continue;
                    try {
                        Tasklet tasklet;
                        Step step = ((StepLocator)((Object)job)).getStep(stepExecution.getStepName());
                        if (!(step instanceof TaskletStep) || !((tasklet = ((TaskletStep)step).getTasklet()) instanceof StoppableTasklet)) continue;
                        StepSynchronizationManager.register(stepExecution);
                        ((StoppableTasklet)tasklet).stop();
                        StepSynchronizationManager.release();
                    }
                    catch (NoSuchStepException e) {
                        this.logger.warn((Object)"Step not found", (Throwable)e);
                    }
                }
            }
        }
        catch (javax.batch.operations.NoSuchJobException e) {
            this.logger.warn((Object)"Cannot find Job object", (Throwable)e);
        }
    }

    static {
        jobRegistry = new ExecutingJobRegistry();
    }

    private static class ExecutingJobRegistry {
        private Map<Long, Job> registry = new ConcurrentHashMap<Long, Job>();

        private ExecutingJobRegistry() {
        }

        public void register(Job job, JobExecution jobExecution) throws DuplicateJobException {
            if (this.registry.containsKey(jobExecution.getId())) {
                throw new DuplicateJobException("This job execution has already been registered");
            }
            this.registry.put(jobExecution.getId(), job);
        }

        public void remove(JobExecution jobExecution) {
            if (!this.registry.containsKey(jobExecution.getId())) {
                throw new NoSuchJobExecutionException("The job execution " + jobExecution.getId() + " was not found");
            }
            this.registry.remove(jobExecution.getId());
        }

        public boolean exists(long jobExecutionId) {
            return this.registry.containsKey(jobExecutionId);
        }

        public Job getJob(long jobExecutionId) {
            if (!this.registry.containsKey(jobExecutionId)) {
                throw new NoSuchJobExecutionException("The job execution " + jobExecutionId + " was not found");
            }
            return this.registry.get(jobExecutionId);
        }
    }
}

