/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job;

import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.DefaultJobParametersValidator;
import org.springframework.batch.core.job.SimpleStepHandler;
import org.springframework.batch.core.job.StepHandler;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.listener.CompositeJobExecutionListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.scope.context.JobSynchronizationManager;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.repeat.RepeatException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractJob
implements Job,
StepLocator,
BeanNameAware,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(AbstractJob.class);
    private String name;
    private boolean restartable = true;
    private JobRepository jobRepository;
    private CompositeJobExecutionListener listener = new CompositeJobExecutionListener();
    private JobParametersIncrementer jobParametersIncrementer;
    private JobParametersValidator jobParametersValidator = new DefaultJobParametersValidator();
    private StepHandler stepHandler;

    public AbstractJob() {
    }

    public AbstractJob(String name) {
        this.name = name;
    }

    public void setJobParametersValidator(JobParametersValidator jobParametersValidator) {
        this.jobParametersValidator = jobParametersValidator;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobRepository, (String)"JobRepository must be set");
    }

    public void setBeanName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract Step getStep(String var1);

    @Override
    public abstract Collection<String> getStepNames();

    @Override
    public JobParametersValidator getJobParametersValidator() {
        return this.jobParametersValidator;
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    @Override
    public boolean isRestartable() {
        return this.restartable;
    }

    public void setJobParametersIncrementer(JobParametersIncrementer jobParametersIncrementer) {
        this.jobParametersIncrementer = jobParametersIncrementer;
    }

    @Override
    public JobParametersIncrementer getJobParametersIncrementer() {
        return this.jobParametersIncrementer;
    }

    public void setJobExecutionListeners(JobExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.listener.register(listeners[i]);
        }
    }

    public void registerJobExecutionListener(JobExecutionListener listener) {
        this.listener.register(listener);
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
        this.stepHandler = new SimpleStepHandler(jobRepository);
    }

    protected JobRepository getJobRepository() {
        return this.jobRepository;
    }

    protected abstract void doExecute(JobExecution var1) throws JobExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute(JobExecution execution) {
        block29: {
            logger.debug((Object)("Job execution starting: " + execution));
            JobSynchronizationManager.register(execution);
            try {
                this.jobParametersValidator.validate(execution.getJobParameters());
                if (execution.getStatus() != BatchStatus.STOPPING) {
                    execution.setStartTime(new Date());
                    this.updateStatus(execution, BatchStatus.STARTED);
                    this.listener.beforeJob(execution);
                    try {
                        this.doExecute(execution);
                        logger.debug((Object)("Job execution complete: " + execution));
                        break block29;
                    }
                    catch (RepeatException e) {
                        throw e.getCause();
                    }
                }
                execution.setStatus(BatchStatus.STOPPED);
                execution.setExitStatus(ExitStatus.COMPLETED);
                logger.debug((Object)("Job execution was stopped: " + execution));
            }
            catch (JobInterruptedException e) {
                logger.info((Object)("Encountered interruption executing job: " + e.getMessage()));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Full exception", (Throwable)e);
                }
                execution.setExitStatus(this.getDefaultExitStatusForFailure(e, execution));
                execution.setStatus(BatchStatus.max(BatchStatus.STOPPED, e.getStatus()));
                execution.addFailureException(e);
            }
            catch (Throwable t) {
                logger.error((Object)"Encountered fatal error executing job", t);
                execution.setExitStatus(this.getDefaultExitStatusForFailure(t, execution));
                execution.setStatus(BatchStatus.FAILED);
                execution.addFailureException(t);
            }
            finally {
                try {
                    if (execution.getStatus().isLessThanOrEqualTo(BatchStatus.STOPPED) && execution.getStepExecutions().isEmpty()) {
                        ExitStatus exitStatus = execution.getExitStatus();
                        ExitStatus newExitStatus = ExitStatus.NOOP.addExitDescription("All steps already completed or no steps configured for this job.");
                        execution.setExitStatus(exitStatus.and(newExitStatus));
                    }
                    execution.setEndTime(new Date());
                    try {
                        this.listener.afterJob(execution);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception encountered in afterStep callback", (Throwable)e);
                    }
                    this.jobRepository.update(execution);
                }
                finally {
                    JobSynchronizationManager.release();
                }
            }
        }
    }

    protected final StepExecution handleStep(Step step, JobExecution execution) throws JobInterruptedException, JobRestartException, StartLimitExceededException {
        return this.stepHandler.handleStep(step, execution);
    }

    protected ExitStatus getDefaultExitStatusForFailure(Throwable ex, JobExecution execution) {
        ExitStatus exitStatus = ex instanceof JobInterruptedException || ex.getCause() instanceof JobInterruptedException ? ExitStatus.STOPPED.addExitDescription(JobInterruptedException.class.getName()) : (ex instanceof NoSuchJobException || ex.getCause() instanceof NoSuchJobException ? new ExitStatus("NO_SUCH_JOB", ex.getClass().getName()) : ExitStatus.FAILED.addExitDescription(ex));
        return exitStatus;
    }

    private void updateStatus(JobExecution jobExecution, BatchStatus status) {
        jobExecution.setStatus(status);
        this.jobRepository.update(jobExecution);
    }

    public String toString() {
        return ClassUtils.getShortName(this.getClass()) + ": [name=" + this.name + "]";
    }
}

