/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.repeat.context.SynchronizedAttributeAccessor;
import org.springframework.util.Assert;

public class JobContext
extends SynchronizedAttributeAccessor {
    private JobExecution jobExecution;
    private Map<String, Set<Runnable>> callbacks = new HashMap<String, Set<Runnable>>();

    public JobContext(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution, (String)"A JobContext must have a non-null JobExecution");
        this.jobExecution = jobExecution;
    }

    public String getJobName() {
        Assert.state((this.jobExecution.getJobInstance() != null ? 1 : 0) != 0, (String)"JobExecution does not have a JobInstance");
        return this.jobExecution.getJobInstance().getJobName();
    }

    public Properties getSystemProperties() {
        return System.getProperties();
    }

    public Map<String, Object> getJobExecutionContext() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.jobExecution.getExecutionContext().entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, Object> getJobParameters() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, JobParameter> entry : this.jobExecution.getJobParameters().getParameters().entrySet()) {
            result.put(entry.getKey(), entry.getValue().getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestructionCallback(String name, Runnable callback) {
        Map<String, Set<Runnable>> map = this.callbacks;
        synchronized (map) {
            Set<Runnable> set = this.callbacks.get(name);
            if (set == null) {
                set = new HashSet<Runnable>();
                this.callbacks.put(name, set);
            }
            set.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterDestructionCallbacks(String name) {
        Map<String, Set<Runnable>> map = this.callbacks;
        synchronized (map) {
            this.callbacks.remove(name);
        }
    }

    public Object removeAttribute(String name) {
        this.unregisterDestructionCallbacks(name);
        return super.removeAttribute(name);
    }

    public void close() {
        ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
        Map<String, Set<Runnable>> copy = Collections.unmodifiableMap(this.callbacks);
        for (Map.Entry<String, Set<Runnable>> entry : copy.entrySet()) {
            Set<Runnable> set = entry.getValue();
            for (Runnable callback : set) {
                if (callback == null) continue;
                try {
                    callback.run();
                }
                catch (RuntimeException t) {
                    errors.add(t);
                }
            }
        }
        if (errors.isEmpty()) {
            return;
        }
        Exception error = (Exception)errors.get(0);
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        throw new UnexpectedJobExecutionException("Could not close step context, rethrowing first of " + errors.size() + " exceptions.", error);
    }

    public JobExecution getJobExecution() {
        return this.jobExecution;
    }

    public String getId() {
        Assert.state((this.jobExecution.getId() != null ? 1 : 0) != 0, (String)"JobExecution has no id.  It must be saved before it can be used in job scope.");
        return "jobExecution#" + this.jobExecution.getId();
    }

    public boolean equals(Object other) {
        if (!(other instanceof JobContext)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        JobContext context = (JobContext)((Object)other);
        if (context.jobExecution == this.jobExecution) {
            return true;
        }
        return this.jobExecution.equals(context.jobExecution);
    }

    public int hashCode() {
        return this.jobExecution.hashCode();
    }

    public String toString() {
        return super.toString() + ", jobExecutionContext=" + this.getJobExecutionContext() + ", jobParameters=" + this.getJobParameters();
    }
}

