/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.batch.api.chunk.listener.RetryProcessListener;
import javax.batch.api.chunk.listener.RetryReadListener;
import javax.batch.api.chunk.listener.RetryWriteListener;
import javax.batch.operations.BatchRuntimeException;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.CompositeChunkListener;
import org.springframework.batch.core.listener.CompositeItemProcessListener;
import org.springframework.batch.core.listener.CompositeItemReadListener;
import org.springframework.batch.core.listener.CompositeItemWriteListener;
import org.springframework.batch.core.listener.CompositeRetryProcessListener;
import org.springframework.batch.core.listener.CompositeRetryReadListener;
import org.springframework.batch.core.listener.CompositeRetryWriteListener;
import org.springframework.batch.core.listener.CompositeSkipListener;
import org.springframework.batch.core.listener.CompositeStepExecutionListener;
import org.springframework.batch.core.listener.StepListenerFailedException;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.lang.Nullable;

public class MulticasterBatchListener<T, S>
implements StepExecutionListener,
ChunkListener,
ItemReadListener<T>,
ItemProcessListener<T, S>,
ItemWriteListener<S>,
SkipListener<T, S>,
RetryReadListener,
RetryProcessListener,
RetryWriteListener {
    private CompositeStepExecutionListener stepListener = new CompositeStepExecutionListener();
    private CompositeChunkListener chunkListener = new CompositeChunkListener();
    private CompositeItemReadListener<T> itemReadListener = new CompositeItemReadListener();
    private CompositeItemProcessListener<T, S> itemProcessListener = new CompositeItemProcessListener();
    private CompositeItemWriteListener<S> itemWriteListener = new CompositeItemWriteListener();
    private CompositeSkipListener<T, S> skipListener = new CompositeSkipListener();
    private CompositeRetryReadListener retryReadListener = new CompositeRetryReadListener();
    private CompositeRetryProcessListener retryProcessListener = new CompositeRetryProcessListener();
    private CompositeRetryWriteListener retryWriteListener = new CompositeRetryWriteListener();

    public void setListeners(List<? extends StepListener> listeners) {
        for (StepListener stepListener : listeners) {
            this.register(stepListener);
        }
    }

    public void register(StepListener listener) {
        if (listener instanceof StepExecutionListener) {
            this.stepListener.register((StepExecutionListener)listener);
        }
        if (listener instanceof ChunkListener) {
            this.chunkListener.register((ChunkListener)listener);
        }
        if (listener instanceof ItemReadListener) {
            ItemReadListener itemReadListener = (ItemReadListener)listener;
            this.itemReadListener.register(itemReadListener);
        }
        if (listener instanceof ItemProcessListener) {
            ItemProcessListener itemProcessListener = (ItemProcessListener)listener;
            this.itemProcessListener.register(itemProcessListener);
        }
        if (listener instanceof ItemWriteListener) {
            ItemWriteListener itemWriteListener = (ItemWriteListener)listener;
            this.itemWriteListener.register(itemWriteListener);
        }
        if (listener instanceof SkipListener) {
            SkipListener skipListener = (SkipListener)listener;
            this.skipListener.register(skipListener);
        }
        if (listener instanceof RetryReadListener) {
            this.retryReadListener.register((RetryReadListener)listener);
        }
        if (listener instanceof RetryProcessListener) {
            this.retryProcessListener.register((RetryProcessListener)listener);
        }
        if (listener instanceof RetryWriteListener) {
            this.retryWriteListener.register((RetryWriteListener)listener);
        }
    }

    @Override
    public void afterProcess(T item, @Nullable S result) {
        try {
            this.itemProcessListener.afterProcess(item, result);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in afterProcess.", this.getTargetException(e));
        }
    }

    @Override
    public void beforeProcess(T item) {
        try {
            this.itemProcessListener.beforeProcess(item);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in beforeProcess.", this.getTargetException(e));
        }
    }

    @Override
    public void onProcessError(T item, Exception ex) {
        try {
            this.itemProcessListener.onProcessError(item, ex);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in onProcessError.", e);
        }
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        try {
            return this.stepListener.afterStep(stepExecution);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in afterStep.", e);
        }
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        try {
            this.stepListener.beforeStep(stepExecution);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in beforeStep.", e);
        }
    }

    @Override
    public void afterChunk(ChunkContext context) {
        try {
            this.chunkListener.afterChunk(context);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in afterChunk.", this.getTargetException(e));
        }
    }

    @Override
    public void beforeChunk(ChunkContext context) {
        try {
            this.chunkListener.beforeChunk(context);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in beforeChunk.", this.getTargetException(e));
        }
    }

    @Override
    public void afterRead(T item) {
        try {
            this.itemReadListener.afterRead(item);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in afterRead.", this.getTargetException(e));
        }
    }

    @Override
    public void beforeRead() {
        try {
            this.itemReadListener.beforeRead();
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in beforeRead.", this.getTargetException(e));
        }
    }

    @Override
    public void onReadError(Exception ex) {
        try {
            this.itemReadListener.onReadError(ex);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in onReadError.", e);
        }
    }

    @Override
    public void afterWrite(List<? extends S> items) {
        try {
            this.itemWriteListener.afterWrite(items);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in afterWrite.", this.getTargetException(e));
        }
    }

    @Override
    public void beforeWrite(List<? extends S> items) {
        try {
            this.itemWriteListener.beforeWrite(items);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in beforeWrite.", this.getTargetException(e));
        }
    }

    @Override
    public void onWriteError(Exception ex, List<? extends S> items) {
        try {
            this.itemWriteListener.onWriteError(ex, items);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in onWriteError.", e);
        }
    }

    @Override
    public void onSkipInRead(Throwable t) {
        this.skipListener.onSkipInRead(t);
    }

    @Override
    public void onSkipInWrite(S item, Throwable t) {
        this.skipListener.onSkipInWrite(item, t);
    }

    @Override
    public void onSkipInProcess(T item, Throwable t) {
        this.skipListener.onSkipInProcess(item, t);
    }

    @Override
    public void afterChunkError(ChunkContext context) {
        try {
            this.chunkListener.afterChunkError(context);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in afterFailedChunk.", e);
        }
    }

    public void onRetryReadException(Exception ex) throws Exception {
        try {
            this.retryReadListener.onRetryReadException(ex);
        }
        catch (Exception e) {
            throw new BatchRuntimeException((Throwable)e);
        }
    }

    public void onRetryProcessException(Object item, Exception ex) throws Exception {
        try {
            this.retryProcessListener.onRetryProcessException(item, ex);
        }
        catch (Exception e) {
            throw new BatchRuntimeException((Throwable)e);
        }
    }

    public void onRetryWriteException(List<Object> items, Exception ex) throws Exception {
        try {
            this.retryWriteListener.onRetryWriteException(items, ex);
        }
        catch (Exception e) {
            throw new BatchRuntimeException((Throwable)e);
        }
    }

    private Throwable getTargetException(RuntimeException e) {
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof InvocationTargetException) {
            return ((InvocationTargetException)cause).getTargetException();
        }
        return e;
    }
}

