/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.batch.core.Entity;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.SerializationUtils;

public class MapStepExecutionDao
implements StepExecutionDao {
    private Map<Long, Map<Long, StepExecution>> executionsByJobExecutionId = new ConcurrentHashMap<Long, Map<Long, StepExecution>>();
    private Map<Long, StepExecution> executionsByStepExecutionId = new ConcurrentHashMap<Long, StepExecution>();
    private AtomicLong currentId = new AtomicLong();

    public void clear() {
        this.executionsByJobExecutionId.clear();
        this.executionsByStepExecutionId.clear();
    }

    private static StepExecution copy(StepExecution original) {
        return (StepExecution)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Object)original));
    }

    private static void copy(final StepExecution sourceExecution, final StepExecution targetExecution) {
        ReflectionUtils.doWithFields(StepExecution.class, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                field.setAccessible(true);
                field.set(targetExecution, field.get(sourceExecution));
            }
        }, (ReflectionUtils.FieldFilter)ReflectionUtils.COPYABLE_FIELDS);
    }

    @Override
    public void saveStepExecution(StepExecution stepExecution) {
        Assert.isTrue((stepExecution.getId() == null ? 1 : 0) != 0, (String)"stepExecution id was not null");
        Assert.isTrue((stepExecution.getVersion() == null ? 1 : 0) != 0, (String)"stepExecution version was not null");
        Assert.notNull((Object)stepExecution.getJobExecutionId(), (String)"JobExecution must be saved already.");
        Map<Long, StepExecution> executions = this.executionsByJobExecutionId.get(stepExecution.getJobExecutionId());
        if (executions == null) {
            executions = new ConcurrentHashMap<Long, StepExecution>();
            this.executionsByJobExecutionId.put(stepExecution.getJobExecutionId(), executions);
        }
        stepExecution.setId(this.currentId.incrementAndGet());
        stepExecution.incrementVersion();
        StepExecution copy = MapStepExecutionDao.copy(stepExecution);
        executions.put(stepExecution.getId(), copy);
        this.executionsByStepExecutionId.put(stepExecution.getId(), copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStepExecution(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution.getJobExecutionId(), (String)"jobExecution id is null");
        Map<Long, StepExecution> executions = this.executionsByJobExecutionId.get(stepExecution.getJobExecutionId());
        Assert.notNull(executions, (String)"step executions for given job execution are expected to be already saved");
        StepExecution persistedExecution = this.executionsByStepExecutionId.get(stepExecution.getId());
        Assert.notNull((Object)persistedExecution, (String)"step execution is expected to be already saved");
        StepExecution stepExecution2 = stepExecution;
        synchronized (stepExecution2) {
            if (!persistedExecution.getVersion().equals(stepExecution.getVersion())) {
                throw new OptimisticLockingFailureException("Attempt to update step execution id=" + stepExecution.getId() + " with wrong version (" + stepExecution.getVersion() + "), where current version is " + persistedExecution.getVersion());
            }
            stepExecution.incrementVersion();
            StepExecution copy = new StepExecution(stepExecution.getStepName(), stepExecution.getJobExecution());
            MapStepExecutionDao.copy(stepExecution, copy);
            executions.put(stepExecution.getId(), copy);
            this.executionsByStepExecutionId.put(stepExecution.getId(), copy);
        }
    }

    @Override
    @Nullable
    public StepExecution getStepExecution(JobExecution jobExecution, Long stepExecutionId) {
        return this.executionsByStepExecutionId.get(stepExecutionId);
    }

    @Override
    public void addStepExecutions(JobExecution jobExecution) {
        Map<Long, StepExecution> executions = this.executionsByJobExecutionId.get(jobExecution.getId());
        if (executions == null || executions.isEmpty()) {
            return;
        }
        ArrayList<StepExecution> result = new ArrayList<StepExecution>(executions.values());
        Collections.sort(result, new Comparator<Entity>(){

            @Override
            public int compare(Entity o1, Entity o2) {
                return Long.signum(o2.getId() - o1.getId());
            }
        });
        ArrayList<StepExecution> copy = new ArrayList<StepExecution>(result.size());
        for (StepExecution exec : result) {
            copy.add(MapStepExecutionDao.copy(exec));
        }
        jobExecution.addStepExecutions(copy);
    }

    @Override
    public void saveStepExecutions(Collection<StepExecution> stepExecutions) {
        Assert.notNull(stepExecutions, (String)"Attempt to save an null collect of step executions");
        for (StepExecution stepExecution : stepExecutions) {
            this.saveStepExecution(stepExecution);
        }
    }
}

