/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.Collection;
import java.util.List;
import org.springframework.batch.core.configuration.xml.AbstractListenerParser;
import org.springframework.batch.core.configuration.xml.ExceptionElementParser;
import org.springframework.batch.core.configuration.xml.StepListenerParser;
import org.springframework.batch.core.listener.StepListenerMetaData;
import org.springframework.batch.repeat.policy.SimpleCompletionPolicy;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ChunkElementParser {
    private static final String REF_ATTR = "ref";
    private static final String MERGE_ATTR = "merge";
    private static final String COMMIT_INTERVAL_ATTR = "commit-interval";
    private static final String CHUNK_COMPLETION_POLICY_ATTR = "chunk-completion-policy";
    private static final String BEAN_ELE = "bean";
    private static final String REF_ELE = "ref";
    private static final String ITEM_READER_ADAPTER_CLASS = "org.springframework.batch.item.adapter.ItemReaderAdapter";
    private static final String ITEM_PROCESSOR_ADAPTER_CLASS = "org.springframework.batch.item.adapter.ItemProcessorAdapter";
    private static final String ITEM_WRITER_ADAPTER_CLASS = "org.springframework.batch.item.adapter.ItemWriterAdapter";
    private static final StepListenerParser stepListenerParser = new StepListenerParser(StepListenerMetaData.itemListenerMetaData());

    protected void parse(Element element, AbstractBeanDefinition bd, ParserContext parserContext, boolean underspecified) {
        String isProcessorTransactional;
        String isReaderTransactionalQueue;
        String completionPolicyRef;
        MutablePropertyValues propertyValues = bd.getPropertyValues();
        propertyValues.addPropertyValue("hasChunkElement", (Object)Boolean.TRUE);
        this.handleItemHandler(bd, "reader", "itemReader", ITEM_READER_ADAPTER_CLASS, true, element, parserContext, propertyValues, underspecified);
        this.handleItemHandler(bd, "processor", "itemProcessor", ITEM_PROCESSOR_ADAPTER_CLASS, false, element, parserContext, propertyValues, underspecified);
        this.handleItemHandler(bd, "writer", "itemWriter", ITEM_WRITER_ADAPTER_CLASS, true, element, parserContext, propertyValues, underspecified);
        String commitInterval = element.getAttribute(COMMIT_INTERVAL_ATTR);
        if (StringUtils.hasText((String)commitInterval)) {
            if (commitInterval.startsWith("#")) {
                BeanDefinitionBuilder completionPolicy = BeanDefinitionBuilder.genericBeanDefinition(SimpleCompletionPolicy.class);
                completionPolicy.addConstructorArgValue((Object)commitInterval);
                completionPolicy.setScope("step");
                propertyValues.addPropertyValue("chunkCompletionPolicy", (Object)completionPolicy.getBeanDefinition());
            } else {
                propertyValues.addPropertyValue("commitInterval", (Object)commitInterval);
            }
        }
        if (StringUtils.hasText((String)(completionPolicyRef = element.getAttribute(CHUNK_COMPLETION_POLICY_ATTR)))) {
            RuntimeBeanReference completionPolicy = new RuntimeBeanReference(completionPolicyRef);
            propertyValues.addPropertyValue("chunkCompletionPolicy", (Object)completionPolicy);
        }
        if (!underspecified && propertyValues.contains("commitInterval") == propertyValues.contains("chunkCompletionPolicy")) {
            if (propertyValues.contains("commitInterval")) {
                parserContext.getReaderContext().error("The <" + element.getNodeName() + "/> element must contain either '" + COMMIT_INTERVAL_ATTR + "' or '" + CHUNK_COMPLETION_POLICY_ATTR + "', but not both.", (Object)element);
            } else {
                parserContext.getReaderContext().error("The <" + element.getNodeName() + "/> element must contain either '" + COMMIT_INTERVAL_ATTR + "' or '" + CHUNK_COMPLETION_POLICY_ATTR + "'.", (Object)element);
            }
        }
        String skipLimit = element.getAttribute("skip-limit");
        ManagedMap skippableExceptions = new ExceptionElementParser().parse(element, parserContext, "skippable-exception-classes");
        if (StringUtils.hasText((String)skipLimit)) {
            if (skippableExceptions == null) {
                skippableExceptions = new ManagedMap();
                skippableExceptions.setMergeEnabled(true);
            }
            propertyValues.addPropertyValue("skipLimit", (Object)skipLimit);
        }
        if (skippableExceptions != null) {
            List exceptionClassElements = DomUtils.getChildElementsByTagName((Element)element, (String)"skippable-exception-classes");
            if (!CollectionUtils.isEmpty((Collection)exceptionClassElements)) {
                skippableExceptions.setMergeEnabled(((Element)exceptionClassElements.get(0)).hasAttribute(MERGE_ATTR) && Boolean.valueOf(((Element)exceptionClassElements.get(0)).getAttribute(MERGE_ATTR)) != false);
            }
            propertyValues.addPropertyValue("skippableExceptionClasses", (Object)skippableExceptions);
        }
        this.handleItemHandler(bd, "skip-policy", "skipPolicy", null, false, element, parserContext, propertyValues, underspecified);
        String retryLimit = element.getAttribute("retry-limit");
        ManagedMap retryableExceptions = new ExceptionElementParser().parse(element, parserContext, "retryable-exception-classes");
        if (StringUtils.hasText((String)retryLimit)) {
            if (retryableExceptions == null) {
                retryableExceptions = new ManagedMap();
                retryableExceptions.setMergeEnabled(true);
            }
            propertyValues.addPropertyValue("retryLimit", (Object)retryLimit);
        }
        if (retryableExceptions != null) {
            List exceptionClassElements = DomUtils.getChildElementsByTagName((Element)element, (String)"retryable-exception-classes");
            if (!CollectionUtils.isEmpty((Collection)exceptionClassElements)) {
                retryableExceptions.setMergeEnabled(((Element)exceptionClassElements.get(0)).hasAttribute(MERGE_ATTR) && Boolean.valueOf(((Element)exceptionClassElements.get(0)).getAttribute(MERGE_ATTR)) != false);
            }
            propertyValues.addPropertyValue("retryableExceptionClasses", (Object)retryableExceptions);
        }
        this.handleItemHandler(bd, "retry-policy", "retryPolicy", null, false, element, parserContext, propertyValues, underspecified);
        String cacheCapacity = element.getAttribute("cache-capacity");
        if (StringUtils.hasText((String)cacheCapacity)) {
            propertyValues.addPropertyValue("cacheCapacity", (Object)cacheCapacity);
        }
        if (StringUtils.hasText((String)(isReaderTransactionalQueue = element.getAttribute("reader-transactional-queue")))) {
            propertyValues.addPropertyValue("isReaderTransactionalQueue", (Object)isReaderTransactionalQueue);
        }
        if (StringUtils.hasText((String)(isProcessorTransactional = element.getAttribute("processor-transactional")))) {
            propertyValues.addPropertyValue("processorTransactional", (Object)isProcessorTransactional);
        }
        this.handleRetryListenersElement(element, propertyValues, parserContext, (BeanDefinition)bd);
        this.handleStreamsElement(element, propertyValues, parserContext);
        stepListenerParser.handleListenersElement(element, (BeanDefinition)bd, parserContext);
    }

    private void handleItemHandler(AbstractBeanDefinition enclosing, String handlerName, String propertyName, String adapterClassName, boolean required, Element element, ParserContext parserContext, MutablePropertyValues propertyValues, boolean underspecified) {
        String refName = element.getAttribute(handlerName);
        List children = DomUtils.getChildElementsByTagName((Element)element, (String)handlerName);
        if (children.size() == 1) {
            if (StringUtils.hasText((String)refName)) {
                parserContext.getReaderContext().error("The <" + element.getNodeName() + "/> element may not have both a '" + handlerName + "' attribute and a <" + handlerName + "/> element.", (Object)element);
            }
            this.handleItemHandlerElement(enclosing, propertyName, adapterClassName, propertyValues, (Element)children.get(0), parserContext);
        } else if (children.size() > 1) {
            parserContext.getReaderContext().error("The <" + handlerName + "/> element may not appear more than once in a single <" + element.getNodeName() + "/>.", (Object)element);
        } else if (StringUtils.hasText((String)refName)) {
            propertyValues.addPropertyValue(propertyName, (Object)new RuntimeBeanReference(refName));
        } else if (required && !underspecified) {
            parserContext.getReaderContext().error("The <" + element.getNodeName() + "/> element has neither a '" + handlerName + "' attribute nor a <" + handlerName + "/> element.", (Object)element);
        }
    }

    private void handleItemHandlerElement(AbstractBeanDefinition enclosing, String propertyName, String adapterClassName, MutablePropertyValues propertyValues, Element element, ParserContext parserContext) {
        List beanElements = DomUtils.getChildElementsByTagName((Element)element, (String)BEAN_ELE);
        List refElements = DomUtils.getChildElementsByTagName((Element)element, (String)"ref");
        if (beanElements.size() + refElements.size() != 1) {
            parserContext.getReaderContext().error("The <" + element.getNodeName() + "/> must have exactly one of either a <" + BEAN_ELE + "/> element or a <" + "ref" + "/> element.", (Object)element);
        } else if (beanElements.size() == 1) {
            Element beanElement = (Element)beanElements.get(0);
            BeanDefinitionHolder beanDefinitionHolder = parserContext.getDelegate().parseBeanDefinitionElement(beanElement, (BeanDefinition)enclosing);
            parserContext.getDelegate().decorateBeanDefinitionIfRequired(beanElement, beanDefinitionHolder);
            propertyValues.addPropertyValue(propertyName, (Object)beanDefinitionHolder);
        } else if (refElements.size() == 1) {
            propertyValues.addPropertyValue(propertyName, parserContext.getDelegate().parsePropertySubElement((Element)refElements.get(0), null));
        }
        this.handleAdapterMethodAttribute(propertyName, adapterClassName, propertyValues, element);
    }

    private void handleAdapterMethodAttribute(String propertyName, String adapterClassName, MutablePropertyValues stepPvs, Element element) {
        String adapterMethodName = element.getAttribute("adapter-method");
        if (StringUtils.hasText((String)adapterMethodName)) {
            GenericBeanDefinition adapterDef = new GenericBeanDefinition();
            adapterDef.setBeanClassName(adapterClassName);
            MutablePropertyValues adapterPvs = adapterDef.getPropertyValues();
            adapterPvs.addPropertyValue("targetMethod", (Object)adapterMethodName);
            adapterPvs.addPropertyValue("targetObject", stepPvs.getPropertyValue(propertyName).getValue());
            stepPvs.addPropertyValue(propertyName, (Object)adapterDef);
        }
    }

    private void handleRetryListenersElement(Element element, MutablePropertyValues propertyValues, ParserContext parserContext, BeanDefinition enclosing) {
        Element listenersElement = DomUtils.getChildElementByTagName((Element)element, (String)"retry-listeners");
        if (listenersElement != null) {
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(listenersElement.getTagName(), parserContext.extractSource((Object)element));
            parserContext.pushContainingComponent(compositeDef);
            ManagedList retryListenerBeans = new ManagedList();
            retryListenerBeans.setMergeEnabled(listenersElement.hasAttribute(MERGE_ATTR) && Boolean.valueOf(listenersElement.getAttribute(MERGE_ATTR)) != false);
            this.handleRetryListenerElements(parserContext, listenersElement, (ManagedList<BeanMetadataElement>)retryListenerBeans, enclosing);
            propertyValues.addPropertyValue("retryListeners", (Object)retryListenerBeans);
            parserContext.popAndRegisterContainingComponent();
        }
    }

    private void handleRetryListenerElements(ParserContext parserContext, Element element, ManagedList<BeanMetadataElement> beans, BeanDefinition enclosing) {
        List listenerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"listener");
        if (listenerElements != null) {
            for (Element listenerElement : listenerElements) {
                beans.add((Object)AbstractListenerParser.parseListenerElement(listenerElement, parserContext, enclosing));
            }
        }
    }

    private void handleStreamsElement(Element element, MutablePropertyValues propertyValues, ParserContext parserContext) {
        Element streamsElement = DomUtils.getChildElementByTagName((Element)element, (String)"streams");
        if (streamsElement != null) {
            ManagedList streamBeans = new ManagedList();
            streamBeans.setMergeEnabled(streamsElement.hasAttribute(MERGE_ATTR) && Boolean.valueOf(streamsElement.getAttribute(MERGE_ATTR)) != false);
            List streamElements = DomUtils.getChildElementsByTagName((Element)streamsElement, (String)"stream");
            if (streamElements != null) {
                for (Element streamElement : streamElements) {
                    String streamRef = streamElement.getAttribute("ref");
                    if (StringUtils.hasText((String)streamRef)) {
                        streamBeans.add((Object)new RuntimeBeanReference(streamRef));
                        continue;
                    }
                    parserContext.getReaderContext().error("ref not specified for <" + streamElement.getTagName() + "> element", (Object)element);
                }
            }
            propertyValues.addPropertyValue("streams", (Object)streamBeans);
        }
    }
}

