/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.partition;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.support.SimpleStepExecutionSplitter;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.item.ExecutionContext;

public class JsrStepExecutionSplitter
extends SimpleStepExecutionSplitter {
    private String stepName;
    private JobRepository jobRepository;
    private boolean restoreState;

    public JsrStepExecutionSplitter(JobRepository jobRepository, boolean allowStartIfComplete, String stepName, boolean restoreState) {
        super(jobRepository, allowStartIfComplete, stepName, null);
        this.stepName = stepName;
        this.jobRepository = jobRepository;
        this.restoreState = restoreState;
    }

    @Override
    public String getStepName() {
        return this.stepName;
    }

    @Override
    public Set<StepExecution> split(StepExecution stepExecution, int gridSize) throws JobExecutionException {
        TreeSet<StepExecution> executions = new TreeSet<StepExecution>(new Comparator<StepExecution>(){

            @Override
            public int compare(StepExecution arg0, StepExecution arg1) {
                String r1 = "";
                String r2 = "";
                if (arg0 != null) {
                    r1 = arg0.getStepName();
                }
                if (arg1 != null) {
                    r2 = arg1.getStepName();
                }
                return r1.compareTo(r2);
            }
        });
        JobExecution jobExecution = stepExecution.getJobExecution();
        for (int i = 0; i < gridSize; ++i) {
            String stepName = this.stepName + ":partition" + i;
            JobExecution curJobExecution = new JobExecution(jobExecution);
            StepExecution curStepExecution = new StepExecution(stepName, curJobExecution);
            if (this.restoreState && !this.isStartable(curStepExecution, new ExecutionContext())) continue;
            executions.add(curStepExecution);
        }
        this.jobRepository.addAll(executions);
        return executions;
    }
}

