/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.support;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleJobRepository
implements JobRepository {
    private static final Log logger = LogFactory.getLog(SimpleJobRepository.class);
    private JobInstanceDao jobInstanceDao;
    private JobExecutionDao jobExecutionDao;
    private StepExecutionDao stepExecutionDao;
    private ExecutionContextDao ecDao;

    SimpleJobRepository() {
    }

    public SimpleJobRepository(JobInstanceDao jobInstanceDao, JobExecutionDao jobExecutionDao, StepExecutionDao stepExecutionDao, ExecutionContextDao ecDao) {
        this.jobInstanceDao = jobInstanceDao;
        this.jobExecutionDao = jobExecutionDao;
        this.stepExecutionDao = stepExecutionDao;
        this.ecDao = ecDao;
    }

    @Override
    public boolean isJobInstanceExists(String jobName, JobParameters jobParameters) {
        return this.jobInstanceDao.getJobInstance(jobName, jobParameters) != null;
    }

    @Override
    public JobExecution createJobExecution(String jobName, JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        ExecutionContext executionContext;
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobName, jobParameters);
        if (jobInstance != null) {
            List<JobExecution> executions = this.jobExecutionDao.findJobExecutions(jobInstance);
            if (executions.isEmpty()) {
                throw new IllegalStateException("Cannot find any job execution for job instance: " + jobInstance);
            }
            for (JobExecution execution : executions) {
                if (execution.isRunning() || execution.isStopping()) {
                    throw new JobExecutionAlreadyRunningException("A job execution for this job is already running: " + jobInstance);
                }
                BatchStatus status = execution.getStatus();
                if (status == BatchStatus.UNKNOWN) {
                    throw new JobRestartException("Cannot restart job from UNKNOWN status. The last execution ended with a failure that could not be rolled back, so it may be dangerous to proceed. Manual intervention is probably necessary.");
                }
                Collection<JobParameter> allJobParameters = execution.getJobParameters().getParameters().values();
                long identifyingJobParametersCount = allJobParameters.stream().filter(JobParameter::isIdentifying).count();
                if (identifyingJobParametersCount <= 0L || status != BatchStatus.COMPLETED && status != BatchStatus.ABANDONED) continue;
                throw new JobInstanceAlreadyCompleteException("A job instance already exists and is complete for parameters=" + jobParameters + ".  If you want to run this job again, change the parameters.");
            }
            executionContext = this.ecDao.getExecutionContext(this.jobExecutionDao.getLastJobExecution(jobInstance));
        } else {
            jobInstance = this.jobInstanceDao.createJobInstance(jobName, jobParameters);
            executionContext = new ExecutionContext();
        }
        JobExecution jobExecution = new JobExecution(jobInstance, jobParameters, null);
        jobExecution.setExecutionContext(executionContext);
        jobExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.jobExecutionDao.saveJobExecution(jobExecution);
        this.ecDao.saveExecutionContext(jobExecution);
        return jobExecution;
    }

    @Override
    public void update(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution, (String)"JobExecution cannot be null.");
        Assert.notNull((Object)jobExecution.getJobId(), (String)"JobExecution must have a Job ID set.");
        Assert.notNull((Object)jobExecution.getId(), (String)"JobExecution must be already saved (have an id assigned).");
        jobExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.jobExecutionDao.synchronizeStatus(jobExecution);
        this.jobExecutionDao.updateJobExecution(jobExecution);
    }

    @Override
    public void add(StepExecution stepExecution) {
        this.validateStepExecution(stepExecution);
        stepExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.stepExecutionDao.saveStepExecution(stepExecution);
        this.ecDao.saveExecutionContext(stepExecution);
    }

    @Override
    public void addAll(Collection<StepExecution> stepExecutions) {
        Assert.notNull(stepExecutions, (String)"Attempt to save a null collection of step executions");
        for (StepExecution stepExecution : stepExecutions) {
            this.validateStepExecution(stepExecution);
            stepExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        }
        this.stepExecutionDao.saveStepExecutions(stepExecutions);
        this.ecDao.saveExecutionContexts(stepExecutions);
    }

    @Override
    public void update(StepExecution stepExecution) {
        this.validateStepExecution(stepExecution);
        Assert.notNull((Object)stepExecution.getId(), (String)"StepExecution must already be saved (have an id assigned)");
        stepExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.stepExecutionDao.updateStepExecution(stepExecution);
        this.checkForInterruption(stepExecution);
    }

    private void validateStepExecution(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution, (String)"StepExecution cannot be null.");
        Assert.notNull((Object)stepExecution.getStepName(), (String)"StepExecution's step name cannot be null.");
        Assert.notNull((Object)stepExecution.getJobExecutionId(), (String)"StepExecution must belong to persisted JobExecution");
    }

    @Override
    public void updateExecutionContext(StepExecution stepExecution) {
        this.validateStepExecution(stepExecution);
        Assert.notNull((Object)stepExecution.getId(), (String)"StepExecution must already be saved (have an id assigned)");
        this.ecDao.updateExecutionContext(stepExecution);
    }

    @Override
    public void updateExecutionContext(JobExecution jobExecution) {
        this.ecDao.updateExecutionContext(jobExecution);
    }

    @Override
    @Nullable
    public StepExecution getLastStepExecution(JobInstance jobInstance, String stepName) {
        StepExecution latest = this.stepExecutionDao.getLastStepExecution(jobInstance, stepName);
        if (latest != null) {
            ExecutionContext stepExecutionContext = this.ecDao.getExecutionContext(latest);
            latest.setExecutionContext(stepExecutionContext);
            ExecutionContext jobExecutionContext = this.ecDao.getExecutionContext(latest.getJobExecution());
            latest.getJobExecution().setExecutionContext(jobExecutionContext);
        }
        return latest;
    }

    @Override
    public int getStepExecutionCount(JobInstance jobInstance, String stepName) {
        int count = 0;
        List<JobExecution> jobExecutions = this.jobExecutionDao.findJobExecutions(jobInstance);
        for (JobExecution jobExecution : jobExecutions) {
            this.stepExecutionDao.addStepExecutions(jobExecution);
            for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
                if (!stepName.equals(stepExecution.getStepName())) continue;
                ++count;
            }
        }
        return count;
    }

    private void checkForInterruption(StepExecution stepExecution) {
        JobExecution jobExecution = stepExecution.getJobExecution();
        this.jobExecutionDao.synchronizeStatus(jobExecution);
        if (jobExecution.isStopping()) {
            logger.info((Object)"Parent JobExecution is stopped, so passing message on to StepExecution");
            stepExecution.setTerminateOnly();
        }
    }

    @Override
    @Nullable
    public JobExecution getLastJobExecution(String jobName, JobParameters jobParameters) {
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobName, jobParameters);
        if (jobInstance == null) {
            return null;
        }
        JobExecution jobExecution = this.jobExecutionDao.getLastJobExecution(jobInstance);
        if (jobExecution != null) {
            jobExecution.setExecutionContext(this.ecDao.getExecutionContext(jobExecution));
            this.stepExecutionDao.addStepExecutions(jobExecution);
        }
        return jobExecution;
    }

    @Override
    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Assert.notNull((Object)jobName, (String)"A job name is required to create a JobInstance");
        Assert.notNull((Object)jobParameters, (String)"Job parameters are required to create a JobInstance");
        JobInstance jobInstance = this.jobInstanceDao.createJobInstance(jobName, jobParameters);
        return jobInstance;
    }

    @Override
    public JobExecution createJobExecution(JobInstance jobInstance, JobParameters jobParameters, String jobConfigurationLocation) {
        Assert.notNull((Object)jobInstance, (String)"A JobInstance is required to associate the JobExecution with");
        Assert.notNull((Object)jobParameters, (String)"A JobParameters object is required to create a JobExecution");
        JobExecution jobExecution = new JobExecution(jobInstance, jobParameters, jobConfigurationLocation);
        ExecutionContext executionContext = new ExecutionContext();
        jobExecution.setExecutionContext(executionContext);
        jobExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.jobExecutionDao.saveJobExecution(jobExecution);
        this.ecDao.saveExecutionContext(jobExecution);
        return jobExecution;
    }
}

