/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.partition;

import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import javax.batch.api.partition.PartitionCollector;
import javax.batch.operations.BatchRuntimeException;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.util.Assert;

public class PartitionCollectorAdapter
implements ChunkListener {
    private PartitionCollector collector;
    private Queue<Serializable> partitionQueue;
    private ReentrantLock lock;

    public PartitionCollectorAdapter(Queue<Serializable> queue, PartitionCollector collector) {
        Assert.notNull(queue, (String)"A thread-safe Queue is required");
        Assert.notNull((Object)collector, (String)"A PartitionCollector is required");
        this.partitionQueue = queue;
        this.collector = collector;
    }

    public void setPartitionLock(ReentrantLock lock) {
        this.lock = lock;
    }

    @Override
    public void beforeChunk(ChunkContext context) {
    }

    @Override
    public void afterChunk(ChunkContext context) {
        try {
            if (context.isComplete()) {
                this.lock.lock();
                Serializable collectPartitionData = this.collector.collectPartitionData();
                if (collectPartitionData != null) {
                    this.partitionQueue.add(collectPartitionData);
                }
            }
        }
        catch (Throwable e) {
            throw new BatchRuntimeException("An error occurred while collecting data from the PartitionCollector", e);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void afterChunkError(ChunkContext context) {
        try {
            Serializable collectPartitionData;
            this.lock.lock();
            if (context.isComplete() && (collectPartitionData = this.collector.collectPartitionData()) != null) {
                this.partitionQueue.add(collectPartitionData);
            }
        }
        catch (Throwable e) {
            throw new BatchRuntimeException("An error occurred while collecting data from the PartitionCollector", e);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }
}

