/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.Collection;
import java.util.List;
import org.springframework.batch.core.jsr.configuration.xml.FlowParser;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class JsrSplitParser {
    private static final String TASK_EXECUTOR_PROPERTY_NAME = "taskExecutor";
    private static final String JSR_352_SPLIT_TASK_EXECUTOR_BEAN_NAME = "jsr352splitTaskExecutor";
    private String jobFactoryRef;

    public JsrSplitParser(String jobFactoryRef) {
        this.jobFactoryRef = jobFactoryRef;
    }

    public Collection<BeanDefinition> parse(Element element, ParserContext parserContext) {
        String idAttribute = element.getAttribute("id");
        BeanDefinitionBuilder stateBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.jsr.job.flow.support.state.JsrSplitState");
        List flowElements = DomUtils.getChildElementsByTagName((Element)element, (String)"flow");
        if (flowElements.size() < 2) {
            parserContext.getReaderContext().error("A <split/> must contain at least two 'flow' elements.", (Object)element);
        }
        ManagedList flows = new ManagedList();
        int i = 0;
        for (Element nextElement : flowElements) {
            FlowParser flowParser = new FlowParser(idAttribute + "." + i, this.jobFactoryRef);
            flows.add(flowParser.parse(nextElement, parserContext));
            ++i;
        }
        stateBuilder.addConstructorArgValue((Object)flows);
        stateBuilder.addConstructorArgValue((Object)idAttribute);
        PropertyValue propertyValue = this.getSplitTaskExecutorPropertyValue(parserContext.getRegistry());
        stateBuilder.addPropertyValue(propertyValue.getName(), propertyValue.getValue());
        return FlowParser.getNextElements(parserContext, null, (BeanDefinition)stateBuilder.getBeanDefinition(), element);
    }

    protected PropertyValue getSplitTaskExecutorPropertyValue(BeanDefinitionRegistry beanDefinitionRegistry) {
        PropertyValue propertyValue = this.hasBeanDefinition(beanDefinitionRegistry, JSR_352_SPLIT_TASK_EXECUTOR_BEAN_NAME) ? new PropertyValue(TASK_EXECUTOR_PROPERTY_NAME, (Object)new RuntimeBeanReference(JSR_352_SPLIT_TASK_EXECUTOR_BEAN_NAME)) : new PropertyValue(TASK_EXECUTOR_PROPERTY_NAME, (Object)new SimpleAsyncTaskExecutor());
        return propertyValue;
    }

    private boolean hasBeanDefinition(BeanDefinitionRegistry beanDefinitionRegistry, String beanName) {
        return beanDefinitionRegistry.containsBeanDefinition(beanName);
    }
}

