/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.step;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.batch.api.Decider;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.jsr.JsrStepExecution;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.item.ExecutionContext;

public class DecisionStep
extends AbstractStep {
    private final Decider decider;

    public DecisionStep(Decider decider) {
        this.decider = decider;
    }

    @Override
    protected void doExecute(StepExecution stepExecution) throws Exception {
        ExecutionContext executionContext = stepExecution.getJobExecution().getExecutionContext();
        ArrayList<JsrStepExecution> stepExecutions = new ArrayList<JsrStepExecution>();
        if (executionContext.containsKey("batch.lastSteps")) {
            List stepNames = (List)executionContext.get("batch.lastSteps");
            for (String stepName : stepNames) {
                StepExecution curStepExecution = this.getJobRepository().getLastStepExecution(stepExecution.getJobExecution().getJobInstance(), stepName);
                stepExecutions.add(new JsrStepExecution(curStepExecution));
            }
        } else {
            Collection<StepExecution> currentRunStepExecutions = stepExecution.getJobExecution().getStepExecutions();
            StepExecution lastExecution = null;
            if (stepExecutions != null) {
                for (StepExecution curStepExecution : currentRunStepExecutions) {
                    if (lastExecution != null && (curStepExecution.getEndTime() == null || !curStepExecution.getEndTime().after(lastExecution.getEndTime()))) continue;
                    lastExecution = curStepExecution;
                }
                stepExecutions.add(new JsrStepExecution(lastExecution));
            }
        }
        try {
            ExitStatus exitStatus = new ExitStatus(this.decider.decide(stepExecutions.toArray(new javax.batch.runtime.StepExecution[0])));
            stepExecution.getJobExecution().setExitStatus(exitStatus);
            stepExecution.setExitStatus(exitStatus);
            if (executionContext.containsKey("batch.lastSteps")) {
                executionContext.remove("batch.lastSteps");
            }
        }
        catch (Exception e) {
            stepExecution.setTerminateOnly();
            stepExecution.addFailureException(e);
            throw e;
        }
    }
}

