/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.configuration.ListableJobLocator;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobInstanceAlreadyExistsException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.launch.NoSuchJobInstanceException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.core.step.NoSuchStepException;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.core.step.tasklet.StoppableTasklet;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.support.PropertiesConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class SimpleJobOperator
implements JobOperator,
InitializingBean {
    private static final String ILLEGAL_STATE_MSG = "Illegal state (only happens on a race condition): %s with name=%s and parameters=%s";
    private ListableJobLocator jobRegistry;
    private JobExplorer jobExplorer;
    private JobLauncher jobLauncher;
    private JobRepository jobRepository;
    private JobParametersConverter jobParametersConverter = new DefaultJobParametersConverter();
    private final Log logger = LogFactory.getLog(this.getClass());

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobLauncher, (String)"JobLauncher must be provided");
        Assert.notNull((Object)this.jobRegistry, (String)"JobLocator must be provided");
        Assert.notNull((Object)this.jobExplorer, (String)"JobExplorer must be provided");
        Assert.notNull((Object)this.jobRepository, (String)"JobRepository must be provided");
    }

    public void setJobParametersConverter(JobParametersConverter jobParametersConverter) {
        this.jobParametersConverter = jobParametersConverter;
    }

    public void setJobRegistry(ListableJobLocator jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    @Override
    public List<Long> getExecutions(long instanceId) throws NoSuchJobInstanceException {
        JobInstance jobInstance = this.jobExplorer.getJobInstance(instanceId);
        if (jobInstance == null) {
            throw new NoSuchJobInstanceException(String.format("No job instance with id=%d", instanceId));
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (JobExecution jobExecution : this.jobExplorer.getJobExecutions(jobInstance)) {
            list.add(jobExecution.getId());
        }
        return list;
    }

    @Override
    public Set<String> getJobNames() {
        return new TreeSet<String>(this.jobRegistry.getJobNames());
    }

    @Override
    public List<Long> getJobInstances(String jobName, int start, int count) throws NoSuchJobException {
        ArrayList<Long> list = new ArrayList<Long>();
        List<JobInstance> jobInstances = this.jobExplorer.getJobInstances(jobName, start, count);
        for (JobInstance jobInstance : jobInstances) {
            list.add(jobInstance.getId());
        }
        if (list.isEmpty() && !this.jobRegistry.getJobNames().contains(jobName)) {
            throw new NoSuchJobException("No such job (either in registry or in historical data): " + jobName);
        }
        return list;
    }

    @Override
    public String getParameters(long executionId) throws NoSuchJobExecutionException {
        JobExecution jobExecution = this.findExecutionById(executionId);
        return PropertiesConverter.propertiesToString((Properties)this.jobParametersConverter.getProperties(jobExecution.getJobParameters()));
    }

    @Override
    public Set<Long> getRunningExecutions(String jobName) throws NoSuchJobException {
        LinkedHashSet<Long> set = new LinkedHashSet<Long>();
        for (JobExecution jobExecution : this.jobExplorer.findRunningJobExecutions(jobName)) {
            set.add(jobExecution.getId());
        }
        if (set.isEmpty() && !this.jobRegistry.getJobNames().contains(jobName)) {
            throw new NoSuchJobException("No such job (either in registry or in historical data): " + jobName);
        }
        return set;
    }

    @Override
    public Map<Long, String> getStepExecutionSummaries(long executionId) throws NoSuchJobExecutionException {
        JobExecution jobExecution = this.findExecutionById(executionId);
        LinkedHashMap<Long, String> map = new LinkedHashMap<Long, String>();
        for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
            map.put(stepExecution.getId(), stepExecution.toString());
        }
        return map;
    }

    @Override
    public String getSummary(long executionId) throws NoSuchJobExecutionException {
        JobExecution jobExecution = this.findExecutionById(executionId);
        return jobExecution.toString();
    }

    @Override
    public Long restart(long executionId) throws JobInstanceAlreadyCompleteException, NoSuchJobExecutionException, NoSuchJobException, JobRestartException, JobParametersInvalidException {
        this.logger.info((Object)("Checking status of job execution with id=" + executionId));
        JobExecution jobExecution = this.findExecutionById(executionId);
        String jobName = jobExecution.getJobInstance().getJobName();
        Job job = this.jobRegistry.getJob(jobName);
        JobParameters parameters = jobExecution.getJobParameters();
        this.logger.info((Object)String.format("Attempting to resume job with name=%s and parameters=%s", jobName, parameters));
        try {
            return this.jobLauncher.run(job, parameters).getId();
        }
        catch (JobExecutionAlreadyRunningException e) {
            throw new UnexpectedJobExecutionException(String.format(ILLEGAL_STATE_MSG, "job execution already running", jobName, parameters), e);
        }
    }

    @Override
    public Long start(String jobName, String parameters) throws NoSuchJobException, JobInstanceAlreadyExistsException, JobParametersInvalidException {
        this.logger.info((Object)("Checking status of job with name=" + jobName));
        JobParameters jobParameters = this.jobParametersConverter.getJobParameters(PropertiesConverter.stringToProperties((String)parameters));
        if (this.jobRepository.isJobInstanceExists(jobName, jobParameters)) {
            throw new JobInstanceAlreadyExistsException(String.format("Cannot start a job instance that already exists with name=%s and parameters=%s", jobName, parameters));
        }
        Job job = this.jobRegistry.getJob(jobName);
        this.logger.info((Object)String.format("Attempting to launch job with name=%s and parameters=%s", jobName, parameters));
        try {
            return this.jobLauncher.run(job, jobParameters).getId();
        }
        catch (JobExecutionAlreadyRunningException e) {
            throw new UnexpectedJobExecutionException(String.format(ILLEGAL_STATE_MSG, "job execution already running", jobName, parameters), e);
        }
        catch (JobRestartException e) {
            throw new UnexpectedJobExecutionException(String.format(ILLEGAL_STATE_MSG, "job not restartable", jobName, parameters), e);
        }
        catch (JobInstanceAlreadyCompleteException e) {
            throw new UnexpectedJobExecutionException(String.format(ILLEGAL_STATE_MSG, "job already complete", jobName, parameters), e);
        }
    }

    @Override
    public Long startNextInstance(String jobName) throws NoSuchJobException, UnexpectedJobExecutionException, JobParametersInvalidException {
        this.logger.info((Object)("Locating parameters for next instance of job with name=" + jobName));
        Job job = this.jobRegistry.getJob(jobName);
        JobParameters parameters = new JobParametersBuilder(this.jobExplorer).getNextJobParameters(job).toJobParameters();
        this.logger.info((Object)String.format("Attempting to launch job with name=%s and parameters=%s", jobName, parameters));
        try {
            return this.jobLauncher.run(job, parameters).getId();
        }
        catch (JobExecutionAlreadyRunningException e) {
            throw new UnexpectedJobExecutionException(String.format(ILLEGAL_STATE_MSG, "job already running", jobName, parameters), e);
        }
        catch (JobRestartException e) {
            throw new UnexpectedJobExecutionException(String.format(ILLEGAL_STATE_MSG, "job not restartable", jobName, parameters), e);
        }
        catch (JobInstanceAlreadyCompleteException e) {
            throw new UnexpectedJobExecutionException(String.format(ILLEGAL_STATE_MSG, "job instance already complete", jobName, parameters), e);
        }
    }

    @Override
    @Transactional
    public boolean stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        JobExecution jobExecution = this.findExecutionById(executionId);
        BatchStatus status = jobExecution.getStatus();
        if (status != BatchStatus.STARTED && status != BatchStatus.STARTING) {
            throw new JobExecutionNotRunningException("JobExecution must be running so that it can be stopped: " + jobExecution);
        }
        jobExecution.setStatus(BatchStatus.STOPPING);
        this.jobRepository.update(jobExecution);
        try {
            Job job = this.jobRegistry.getJob(jobExecution.getJobInstance().getJobName());
            if (job instanceof StepLocator) {
                for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
                    if (!stepExecution.getStatus().isRunning()) continue;
                    try {
                        Tasklet tasklet;
                        Step step = ((StepLocator)((Object)job)).getStep(stepExecution.getStepName());
                        if (!(step instanceof TaskletStep) || !((tasklet = ((TaskletStep)step).getTasklet()) instanceof StoppableTasklet)) continue;
                        StepSynchronizationManager.register(stepExecution);
                        ((StoppableTasklet)tasklet).stop();
                        StepSynchronizationManager.release();
                    }
                    catch (NoSuchStepException e) {
                        this.logger.warn((Object)"Step not found", (Throwable)e);
                    }
                }
            }
        }
        catch (NoSuchJobException e) {
            this.logger.warn((Object)"Cannot find Job object in the job registry. StoppableTasklet#stop() will not be called", (Throwable)e);
        }
        return true;
    }

    @Override
    public JobExecution abandon(long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionAlreadyRunningException {
        JobExecution jobExecution = this.findExecutionById(jobExecutionId);
        if (jobExecution.getStatus().isLessThan(BatchStatus.STOPPING)) {
            throw new JobExecutionAlreadyRunningException("JobExecution is running or complete and therefore cannot be aborted");
        }
        this.logger.info((Object)("Aborting job execution: " + jobExecution));
        jobExecution.upgradeStatus(BatchStatus.ABANDONED);
        jobExecution.setEndTime(new Date());
        this.jobRepository.update(jobExecution);
        return jobExecution;
    }

    private JobExecution findExecutionById(long executionId) throws NoSuchJobExecutionException {
        JobExecution jobExecution = this.jobExplorer.getJobExecution(executionId);
        if (jobExecution == null) {
            throw new NoSuchJobExecutionException("No JobExecution found for id: [" + executionId + "]");
        }
        return jobExecution;
    }
}

