/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow.support;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecution;
import org.springframework.batch.core.job.flow.FlowExecutionException;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.State;
import org.springframework.batch.core.job.flow.support.StateTransition;
import org.springframework.beans.factory.InitializingBean;

public class SimpleFlow
implements Flow,
InitializingBean {
    private static final Log logger = LogFactory.getLog(SimpleFlow.class);
    private State startState;
    private Map<String, Set<StateTransition>> transitionMap = new HashMap<String, Set<StateTransition>>();
    private Map<String, State> stateMap = new HashMap<String, State>();
    private List<StateTransition> stateTransitions = new ArrayList<StateTransition>();
    private final String name;
    private Comparator<StateTransition> stateTransitionComparator;

    public void setStateTransitionComparator(Comparator<StateTransition> stateTransitionComparator) {
        this.stateTransitionComparator = stateTransitionComparator;
    }

    public SimpleFlow(String name) {
        this.name = name;
    }

    public State getStartState() {
        return this.startState;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setStateTransitions(List<StateTransition> stateTransitions) {
        this.stateTransitions = stateTransitions;
    }

    @Override
    public State getState(String stateName) {
        return this.stateMap.get(stateName);
    }

    @Override
    public Collection<State> getStates() {
        return new HashSet<State>(this.stateMap.values());
    }

    public void afterPropertiesSet() throws Exception {
        this.initializeTransitionsIfNotInitialized();
    }

    @Override
    public FlowExecution start(FlowExecutor executor) throws FlowExecutionException {
        this.initializeTransitionsIfNotInitialized();
        State state = this.startState;
        String stateName = state.getName();
        return this.resume(stateName, executor);
    }

    @Override
    public FlowExecution resume(String stateName, FlowExecutor executor) throws FlowExecutionException {
        FlowExecutionStatus status = FlowExecutionStatus.UNKNOWN;
        State state = this.stateMap.get(stateName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resuming state=" + stateName + " with status=" + status));
        }
        StepExecution stepExecution = null;
        while (this.isFlowContinued(state, status, stepExecution)) {
            stateName = state.getName();
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Handling state=" + stateName));
                }
                status = state.handle(executor);
                stepExecution = executor.getStepExecution();
            }
            catch (FlowExecutionException e) {
                executor.close(new FlowExecution(stateName, status));
                throw e;
            }
            catch (Exception e) {
                executor.close(new FlowExecution(stateName, status));
                throw new FlowExecutionException(String.format("Ended flow=%s at state=%s with exception", this.name, stateName), e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Completed state=" + stateName + " with status=" + status));
            }
            state = this.nextState(stateName, status, stepExecution);
        }
        FlowExecution result = new FlowExecution(stateName, status);
        executor.close(result);
        return result;
    }

    protected Map<String, Set<StateTransition>> getTransitionMap() {
        return this.transitionMap;
    }

    protected Map<String, State> getStateMap() {
        return this.stateMap;
    }

    protected State nextState(String stateName, FlowExecutionStatus status, StepExecution stepExecution) throws FlowExecutionException {
        Set<StateTransition> set = this.transitionMap.get(stateName);
        if (set == null) {
            throw new FlowExecutionException(String.format("No transitions found in flow=%s for state=%s", this.getName(), stateName));
        }
        String next = null;
        String exitCode = status.getName();
        for (StateTransition stateTransition : set) {
            if (!stateTransition.matches(exitCode) && (!exitCode.equals("PENDING") || !stateTransition.matches("STOPPED"))) continue;
            if (stateTransition.isEnd()) {
                return null;
            }
            next = stateTransition.getNext();
            break;
        }
        if (next == null) {
            throw new FlowExecutionException(String.format("Next state not found in flow=%s for state=%s with exit status=%s", this.getName(), stateName, status.getName()));
        }
        if (!this.stateMap.containsKey(next)) {
            throw new FlowExecutionException(String.format("Next state not specified in flow=%s for next=%s", this.getName(), next));
        }
        return this.stateMap.get(next);
    }

    protected boolean isFlowContinued(State state, FlowExecutionStatus status, StepExecution stepExecution) {
        boolean continued = true;
        boolean bl = continued = state != null && status != FlowExecutionStatus.STOPPED;
        if (stepExecution != null) {
            Boolean reRun = (Boolean)stepExecution.getExecutionContext().get("batch.restart");
            Boolean executed = (Boolean)stepExecution.getExecutionContext().get("batch.executed");
            if (!(executed != null && executed.booleanValue() || reRun == null || !reRun.booleanValue() || status != FlowExecutionStatus.STOPPED || state.getName().endsWith(stepExecution.getStepName()))) {
                continued = true;
            }
        }
        return continued;
    }

    private boolean stateNameEndsWithStepName(State state, StepExecution stepExecution) {
        return stepExecution != null && state != null && !state.getName().endsWith(stepExecution.getStepName());
    }

    private synchronized void initializeTransitionsIfNotInitialized() {
        if (this.startState == null) {
            this.initializeTransitions();
        }
    }

    private void initializeTransitions() {
        State state;
        this.startState = null;
        this.transitionMap.clear();
        this.stateMap.clear();
        boolean hasEndStep = false;
        if (this.stateTransitions.isEmpty()) {
            throw new IllegalArgumentException("No start state was found. You must specify at least one step in a job.");
        }
        for (StateTransition stateTransition : this.stateTransitions) {
            state = stateTransition.getState();
            String stateName = state.getName();
            this.stateMap.put(stateName, state);
        }
        for (StateTransition stateTransition : this.stateTransitions) {
            String name;
            AbstractSet set;
            state = stateTransition.getState();
            if (!stateTransition.isEnd()) {
                String next = stateTransition.getNext();
                if (!this.stateMap.containsKey(next)) {
                    throw new IllegalArgumentException("Missing state for [" + stateTransition + "]");
                }
            } else {
                hasEndStep = true;
            }
            if ((set = this.transitionMap.get(name = state.getName())) == null) {
                set = this.stateTransitionComparator == null ? new LinkedHashSet<StateTransition>() : new TreeSet<StateTransition>(this.stateTransitionComparator);
                this.transitionMap.put(name, set);
            }
            set.add((StateTransition)stateTransition);
        }
        if (!hasEndStep) {
            throw new IllegalArgumentException("No end state was found.  You must specify at least one transition with no next state.");
        }
        this.startState = this.stateTransitions.get(0).getState();
    }
}

