/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.support;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.Assert;

public class BatchPropertyContext {
    private static final String PARTITION_INDICATOR = ":partition";
    private Properties jobProperties = new Properties();
    private Map<String, Properties> stepProperties = new HashMap<String, Properties>();
    private Map<String, Properties> artifactProperties = new HashMap<String, Properties>();
    private Map<String, Map<String, Properties>> stepArtifactProperties = new HashMap<String, Map<String, Properties>>();

    public Properties getJobProperties() {
        return this.jobProperties;
    }

    public void setJobProperties(Properties properties) {
        Assert.notNull((Object)properties, (String)"Job properties cannot be null");
        this.jobProperties.putAll((Map<?, ?>)properties);
    }

    public Properties getStepProperties(String stepName) {
        Assert.hasText((String)stepName, (String)"Step name must be provided");
        Properties properties = new Properties();
        if (this.stepProperties.containsKey(stepName)) {
            properties.putAll((Map<?, ?>)this.stepProperties.get(stepName));
        }
        if (stepName.contains(PARTITION_INDICATOR)) {
            String parentStepName = stepName.substring(0, stepName.indexOf(PARTITION_INDICATOR));
            properties.putAll((Map<?, ?>)this.getStepProperties(parentStepName));
        }
        return properties;
    }

    public void setStepProperties(Map<String, Properties> properties) {
        Assert.notNull(properties, (String)"Step properties cannot be null");
        for (Map.Entry<String, Properties> propertiesEntry : properties.entrySet()) {
            String stepName = propertiesEntry.getKey();
            Properties stepProperties = propertiesEntry.getValue();
            if (stepProperties.isEmpty()) continue;
            if (this.stepProperties.containsKey(stepName)) {
                Properties existingStepProperties = this.stepProperties.get(stepName);
                Enumeration<?> stepPropertyNames = stepProperties.propertyNames();
                while (stepPropertyNames.hasMoreElements()) {
                    String propertyEntryName = (String)stepPropertyNames.nextElement();
                    existingStepProperties.put(propertyEntryName, stepProperties.getProperty(propertyEntryName));
                }
                this.stepProperties.put(stepName, existingStepProperties);
                continue;
            }
            this.stepProperties.put(stepName, propertiesEntry.getValue());
        }
    }

    public void setStepProperties(String stepName, Properties properties) {
        Assert.hasText((String)stepName, (String)"Step name must be provided");
        Assert.notNull((Object)properties, (String)"Step properties must not be null");
        HashMap<String, Properties> stepProperties = new HashMap<String, Properties>();
        stepProperties.put(stepName, properties);
        this.setStepProperties(stepProperties);
    }

    public Properties getArtifactProperties(String artifactName) {
        Properties properties = new Properties();
        if (this.artifactProperties.containsKey(artifactName)) {
            properties.putAll((Map<?, ?>)this.artifactProperties.get(artifactName));
        }
        return properties;
    }

    public void setArtifactProperties(Map<String, Properties> properties) {
        Assert.notNull(properties, (String)"Step properties cannot be null");
        for (Map.Entry<String, Properties> propertiesEntry : properties.entrySet()) {
            String artifactName = propertiesEntry.getKey();
            Properties artifactProperties = propertiesEntry.getValue();
            if (artifactProperties.isEmpty()) continue;
            this.artifactProperties.put(artifactName, artifactProperties);
        }
    }

    public Properties getStepArtifactProperties(String stepName, String artifactName) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.getStepProperties(stepName));
        Map<String, Properties> artifactProperties = this.stepArtifactProperties.get(stepName);
        if (artifactProperties != null && artifactProperties.containsKey(artifactName)) {
            properties.putAll((Map<?, ?>)artifactProperties.get(artifactName));
        }
        if (stepName.contains(PARTITION_INDICATOR)) {
            String parentStepName = stepName.substring(0, stepName.indexOf(PARTITION_INDICATOR));
            properties.putAll((Map<?, ?>)this.getStepProperties(parentStepName));
            Map<String, Properties> parentArtifactProperties = this.stepArtifactProperties.get(parentStepName);
            if (parentArtifactProperties != null && parentArtifactProperties.containsKey(artifactName)) {
                properties.putAll((Map<?, ?>)parentArtifactProperties.get(artifactName));
            }
        }
        return properties;
    }

    public void setStepArtifactProperties(Map<String, Map<String, Properties>> properties) {
        Assert.notNull(properties, (String)"Step artifact properties cannot be null");
        for (Map.Entry<String, Map<String, Properties>> propertyEntries : properties.entrySet()) {
            String stepName = propertyEntries.getKey();
            for (Map.Entry<String, Properties> artifactEntries : propertyEntries.getValue().entrySet()) {
                final String artifactName = artifactEntries.getKey();
                final Properties props = artifactEntries.getValue();
                Map<String, Properties> artifactProperties = this.stepArtifactProperties.get(stepName);
                if (artifactProperties == null) {
                    this.stepArtifactProperties.put(stepName, (Map<String, Properties>)new HashMap<String, Properties>(){
                        {
                            this.put(artifactName, props);
                        }
                    });
                    continue;
                }
                artifactProperties.put(artifactName, props);
            }
        }
    }
}

