/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.partition.support;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.support.AbstractPartitionHandler;
import org.springframework.batch.core.step.StepHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.util.Assert;

public class TaskExecutorPartitionHandler
extends AbstractPartitionHandler
implements StepHolder,
InitializingBean {
    private TaskExecutor taskExecutor = new SyncTaskExecutor();
    private Step step;

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.step != null ? 1 : 0) != 0, (String)"A Step must be provided.");
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setStep(Step step) {
        this.step = step;
    }

    @Override
    public Step getStep() {
        return this.step;
    }

    @Override
    protected Set<StepExecution> doHandle(StepExecution managerStepExecution, Set<StepExecution> partitionStepExecutions) throws Exception {
        Assert.notNull((Object)this.step, (String)"A Step must be provided.");
        HashSet<FutureTask<StepExecution>> tasks = new HashSet<FutureTask<StepExecution>>(this.getGridSize());
        HashSet<StepExecution> result = new HashSet<StepExecution>();
        for (StepExecution stepExecution : partitionStepExecutions) {
            FutureTask<StepExecution> task = this.createTask(this.step, stepExecution);
            try {
                this.taskExecutor.execute(task);
                tasks.add(task);
            }
            catch (TaskRejectedException e) {
                ExitStatus exitStatus = ExitStatus.FAILED.addExitDescription("TaskExecutor rejected the task for this step.");
                stepExecution.setStatus(BatchStatus.FAILED);
                stepExecution.setExitStatus(exitStatus);
                result.add(stepExecution);
            }
        }
        for (Future future : tasks) {
            result.add((StepExecution)future.get());
        }
        return result;
    }

    protected FutureTask<StepExecution> createTask(final Step step, final StepExecution stepExecution) {
        return new FutureTask<StepExecution>(new Callable<StepExecution>(){

            @Override
            public StepExecution call() throws Exception {
                step.execute(stepExecution);
                return stepExecution;
            }
        });
    }
}

